/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An output event for an AI-generated response in an Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TextOutputEvent implements SdkPojo, Serializable, ToCopyableBuilder<TextOutputEvent.Builder, TextOutputEvent>,
        ChatOutputStream {
    private static final SdkField<String> SYSTEM_MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageType").getter(getter(TextOutputEvent::systemMessageTypeAsString))
            .setter(setter(Builder::systemMessageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageType").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(TextOutputEvent::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessageId").getter(getter(TextOutputEvent::userMessageId)).setter(setter(Builder::userMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageId").getter(getter(TextOutputEvent::systemMessageId))
            .setter(setter(Builder::systemMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessage").getter(getter(TextOutputEvent::systemMessage)).setter(setter(Builder::systemMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_MESSAGE_TYPE_FIELD,
            CONVERSATION_ID_FIELD, USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String systemMessageType;

    private final String conversationId;

    private final String userMessageId;

    private final String systemMessageId;

    private final String systemMessage;

    protected TextOutputEvent(BuilderImpl builder) {
        this.systemMessageType = builder.systemMessageType;
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.systemMessage = builder.systemMessage;
    }

    /**
     * <p>
     * The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports two
     * types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RESPONSE</code> - The Amazon Q Business system response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q Business.
     * Available only if hallucination reduction is supported and configured for the application and detected in the end
     * user chat query by Amazon Q Business.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemMessageType}
     * will return {@link SystemMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #systemMessageTypeAsString}.
     * </p>
     * 
     * @return The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports
     *         two types of messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RESPONSE</code> - The Amazon Q Business system response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
     *         Business. Available only if hallucination reduction is supported and configured for the application and
     *         detected in the end user chat query by Amazon Q Business.
     *         </p>
     *         </li>
     * @see SystemMessageType
     */
    public final SystemMessageType systemMessageType() {
        return SystemMessageType.fromValue(systemMessageType);
    }

    /**
     * <p>
     * The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports two
     * types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RESPONSE</code> - The Amazon Q Business system response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q Business.
     * Available only if hallucination reduction is supported and configured for the application and detected in the end
     * user chat query by Amazon Q Business.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemMessageType}
     * will return {@link SystemMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #systemMessageTypeAsString}.
     * </p>
     * 
     * @return The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports
     *         two types of messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RESPONSE</code> - The Amazon Q Business system response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
     *         Business. Available only if hallucination reduction is supported and configured for the application and
     *         detected in the end user chat query by Amazon Q Business.
     *         </p>
     *         </li>
     * @see SystemMessageType
     */
    public final String systemMessageTypeAsString() {
        return systemMessageType;
    }

    /**
     * <p>
     * The identifier of the conversation with which the text output event is associated.
     * </p>
     * 
     * @return The identifier of the conversation with which the text output event is associated.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of an end user message in a <code>TextOutputEvent</code>.
     * </p>
     * 
     * @return The identifier of an end user message in a <code>TextOutputEvent</code>.
     */
    public final String userMessageId() {
        return userMessageId;
    }

    /**
     * <p>
     * The identifier of an AI-generated message in a <code>TextOutputEvent</code>.
     * </p>
     * 
     * @return The identifier of an AI-generated message in a <code>TextOutputEvent</code>.
     */
    public final String systemMessageId() {
        return systemMessageId;
    }

    /**
     * <p>
     * An AI-generated message in a <code>TextOutputEvent</code>.
     * </p>
     * 
     * @return An AI-generated message in a <code>TextOutputEvent</code>.
     */
    public final String systemMessage() {
        return systemMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextOutputEvent)) {
            return false;
        }
        TextOutputEvent other = (TextOutputEvent) obj;
        return Objects.equals(systemMessageTypeAsString(), other.systemMessageTypeAsString())
                && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(userMessageId(), other.userMessageId())
                && Objects.equals(systemMessageId(), other.systemMessageId())
                && Objects.equals(systemMessage(), other.systemMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextOutputEvent").add("SystemMessageType", systemMessageTypeAsString())
                .add("ConversationId", conversationId()).add("UserMessageId", userMessageId())
                .add("SystemMessageId", systemMessageId()).add("SystemMessage", systemMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "systemMessageType":
            return Optional.ofNullable(clazz.cast(systemMessageTypeAsString()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "userMessageId":
            return Optional.ofNullable(clazz.cast(userMessageId()));
        case "systemMessageId":
            return Optional.ofNullable(clazz.cast(systemMessageId()));
        case "systemMessage":
            return Optional.ofNullable(clazz.cast(systemMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TextOutputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("systemMessageType", SYSTEM_MESSAGE_TYPE_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("systemMessage", SYSTEM_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextOutputEvent, T> g) {
        return obj -> g.apply((TextOutputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link TextOutputEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextOutputEvent> {
        /**
         * <p>
         * The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports two
         * types of messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RESPONSE</code> - The Amazon Q Business system response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
         * Business. Available only if hallucination reduction is supported and configured for the application and
         * detected in the end user chat query by Amazon Q Business.
         * </p>
         * </li>
         * </ul>
         * 
         * @param systemMessageType
         *        The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently
         *        supports two types of messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RESPONSE</code> - The Amazon Q Business system response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
         *        Business. Available only if hallucination reduction is supported and configured for the application
         *        and detected in the end user chat query by Amazon Q Business.
         *        </p>
         *        </li>
         * @see SystemMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemMessageType
         */
        Builder systemMessageType(String systemMessageType);

        /**
         * <p>
         * The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently supports two
         * types of messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RESPONSE</code> - The Amazon Q Business system response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
         * Business. Available only if hallucination reduction is supported and configured for the application and
         * detected in the end user chat query by Amazon Q Business.
         * </p>
         * </li>
         * </ul>
         * 
         * @param systemMessageType
         *        The type of AI-generated message in a <code>TextOutputEvent</code>. Amazon Q Business currently
         *        supports two types of messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RESPONSE</code> - The Amazon Q Business system response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUNDED_RESPONSE</code> - The corrected, hallucination-reduced, response returned by Amazon Q
         *        Business. Available only if hallucination reduction is supported and configured for the application
         *        and detected in the end user chat query by Amazon Q Business.
         *        </p>
         *        </li>
         * @see SystemMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemMessageType
         */
        Builder systemMessageType(SystemMessageType systemMessageType);

        /**
         * <p>
         * The identifier of the conversation with which the text output event is associated.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the conversation with which the text output event is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of an end user message in a <code>TextOutputEvent</code>.
         * </p>
         * 
         * @param userMessageId
         *        The identifier of an end user message in a <code>TextOutputEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessageId(String userMessageId);

        /**
         * <p>
         * The identifier of an AI-generated message in a <code>TextOutputEvent</code>.
         * </p>
         * 
         * @param systemMessageId
         *        The identifier of an AI-generated message in a <code>TextOutputEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageId(String systemMessageId);

        /**
         * <p>
         * An AI-generated message in a <code>TextOutputEvent</code>.
         * </p>
         * 
         * @param systemMessage
         *        An AI-generated message in a <code>TextOutputEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessage(String systemMessage);
    }

    protected static class BuilderImpl implements Builder {
        private String systemMessageType;

        private String conversationId;

        private String userMessageId;

        private String systemMessageId;

        private String systemMessage;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TextOutputEvent model) {
            systemMessageType(model.systemMessageType);
            conversationId(model.conversationId);
            userMessageId(model.userMessageId);
            systemMessageId(model.systemMessageId);
            systemMessage(model.systemMessage);
        }

        public final String getSystemMessageType() {
            return systemMessageType;
        }

        public final void setSystemMessageType(String systemMessageType) {
            this.systemMessageType = systemMessageType;
        }

        @Override
        public final Builder systemMessageType(String systemMessageType) {
            this.systemMessageType = systemMessageType;
            return this;
        }

        @Override
        public final Builder systemMessageType(SystemMessageType systemMessageType) {
            this.systemMessageType(systemMessageType == null ? null : systemMessageType.toString());
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getSystemMessage() {
            return systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        @Override
        public TextOutputEvent build() {
            return new TextOutputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
