/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for details about different types of media sources (image, audio, or video).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<SourceDetails.Builder, SourceDetails> {
    private static final SdkField<ImageSourceDetails> IMAGE_SOURCE_DETAILS_FIELD = SdkField
            .<ImageSourceDetails> builder(MarshallingType.SDK_POJO).memberName("imageSourceDetails")
            .getter(getter(SourceDetails::imageSourceDetails)).setter(setter(Builder::imageSourceDetails))
            .constructor(ImageSourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSourceDetails").build())
            .build();

    private static final SdkField<AudioSourceDetails> AUDIO_SOURCE_DETAILS_FIELD = SdkField
            .<AudioSourceDetails> builder(MarshallingType.SDK_POJO).memberName("audioSourceDetails")
            .getter(getter(SourceDetails::audioSourceDetails)).setter(setter(Builder::audioSourceDetails))
            .constructor(AudioSourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSourceDetails").build())
            .build();

    private static final SdkField<VideoSourceDetails> VIDEO_SOURCE_DETAILS_FIELD = SdkField
            .<VideoSourceDetails> builder(MarshallingType.SDK_POJO).memberName("videoSourceDetails")
            .getter(getter(SourceDetails::videoSourceDetails)).setter(setter(Builder::videoSourceDetails))
            .constructor(VideoSourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSourceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SOURCE_DETAILS_FIELD,
            AUDIO_SOURCE_DETAILS_FIELD, VIDEO_SOURCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageSourceDetails imageSourceDetails;

    private final AudioSourceDetails audioSourceDetails;

    private final VideoSourceDetails videoSourceDetails;

    private final Type type;

    private SourceDetails(BuilderImpl builder) {
        this.imageSourceDetails = builder.imageSourceDetails;
        this.audioSourceDetails = builder.audioSourceDetails;
        this.videoSourceDetails = builder.videoSourceDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details specific to image content within the source.
     * </p>
     * 
     * @return Details specific to image content within the source.
     */
    public final ImageSourceDetails imageSourceDetails() {
        return imageSourceDetails;
    }

    /**
     * <p>
     * Details specific to audio content within the source.
     * </p>
     * 
     * @return Details specific to audio content within the source.
     */
    public final AudioSourceDetails audioSourceDetails() {
        return audioSourceDetails;
    }

    /**
     * <p>
     * Details specific to video content within the source.
     * </p>
     * 
     * @return Details specific to video content within the source.
     */
    public final VideoSourceDetails videoSourceDetails() {
        return videoSourceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageSourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(audioSourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(videoSourceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetails)) {
            return false;
        }
        SourceDetails other = (SourceDetails) obj;
        return Objects.equals(imageSourceDetails(), other.imageSourceDetails())
                && Objects.equals(audioSourceDetails(), other.audioSourceDetails())
                && Objects.equals(videoSourceDetails(), other.videoSourceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDetails").add("ImageSourceDetails", imageSourceDetails())
                .add("AudioSourceDetails", audioSourceDetails()).add("VideoSourceDetails", videoSourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageSourceDetails":
            return Optional.ofNullable(clazz.cast(imageSourceDetails()));
        case "audioSourceDetails":
            return Optional.ofNullable(clazz.cast(audioSourceDetails()));
        case "videoSourceDetails":
            return Optional.ofNullable(clazz.cast(videoSourceDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #imageSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to image content within the source.
     * </p>
     * 
     * @param imageSourceDetails
     *        Details specific to image content within the source.
     */
    public static SourceDetails fromImageSourceDetails(ImageSourceDetails imageSourceDetails) {
        return builder().imageSourceDetails(imageSourceDetails).build();
    }

    /**
     * Create an instance of this class with {@link #imageSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to image content within the source.
     * </p>
     * 
     * @param imageSourceDetails
     *        Details specific to image content within the source.
     */
    public static SourceDetails fromImageSourceDetails(Consumer<ImageSourceDetails.Builder> imageSourceDetails) {
        ImageSourceDetails.Builder builder = ImageSourceDetails.builder();
        imageSourceDetails.accept(builder);
        return fromImageSourceDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #audioSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to audio content within the source.
     * </p>
     * 
     * @param audioSourceDetails
     *        Details specific to audio content within the source.
     */
    public static SourceDetails fromAudioSourceDetails(AudioSourceDetails audioSourceDetails) {
        return builder().audioSourceDetails(audioSourceDetails).build();
    }

    /**
     * Create an instance of this class with {@link #audioSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to audio content within the source.
     * </p>
     * 
     * @param audioSourceDetails
     *        Details specific to audio content within the source.
     */
    public static SourceDetails fromAudioSourceDetails(Consumer<AudioSourceDetails.Builder> audioSourceDetails) {
        AudioSourceDetails.Builder builder = AudioSourceDetails.builder();
        audioSourceDetails.accept(builder);
        return fromAudioSourceDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #videoSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to video content within the source.
     * </p>
     * 
     * @param videoSourceDetails
     *        Details specific to video content within the source.
     */
    public static SourceDetails fromVideoSourceDetails(VideoSourceDetails videoSourceDetails) {
        return builder().videoSourceDetails(videoSourceDetails).build();
    }

    /**
     * Create an instance of this class with {@link #videoSourceDetails()} initialized to the given value.
     *
     * <p>
     * Details specific to video content within the source.
     * </p>
     * 
     * @param videoSourceDetails
     *        Details specific to video content within the source.
     */
    public static SourceDetails fromVideoSourceDetails(Consumer<VideoSourceDetails.Builder> videoSourceDetails) {
        VideoSourceDetails.Builder builder = VideoSourceDetails.builder();
        videoSourceDetails.accept(builder);
        return fromVideoSourceDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageSourceDetails", IMAGE_SOURCE_DETAILS_FIELD);
        map.put("audioSourceDetails", AUDIO_SOURCE_DETAILS_FIELD);
        map.put("videoSourceDetails", VIDEO_SOURCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDetails, T> g) {
        return obj -> g.apply((SourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDetails> {
        /**
         * <p>
         * Details specific to image content within the source.
         * </p>
         * 
         * @param imageSourceDetails
         *        Details specific to image content within the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSourceDetails(ImageSourceDetails imageSourceDetails);

        /**
         * <p>
         * Details specific to image content within the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSourceDetails.Builder} avoiding the
         * need to create one manually via {@link ImageSourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #imageSourceDetails(ImageSourceDetails)}.
         * 
         * @param imageSourceDetails
         *        a consumer that will call methods on {@link ImageSourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageSourceDetails(ImageSourceDetails)
         */
        default Builder imageSourceDetails(Consumer<ImageSourceDetails.Builder> imageSourceDetails) {
            return imageSourceDetails(ImageSourceDetails.builder().applyMutation(imageSourceDetails).build());
        }

        /**
         * <p>
         * Details specific to audio content within the source.
         * </p>
         * 
         * @param audioSourceDetails
         *        Details specific to audio content within the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSourceDetails(AudioSourceDetails audioSourceDetails);

        /**
         * <p>
         * Details specific to audio content within the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioSourceDetails.Builder} avoiding the
         * need to create one manually via {@link AudioSourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioSourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #audioSourceDetails(AudioSourceDetails)}.
         * 
         * @param audioSourceDetails
         *        a consumer that will call methods on {@link AudioSourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioSourceDetails(AudioSourceDetails)
         */
        default Builder audioSourceDetails(Consumer<AudioSourceDetails.Builder> audioSourceDetails) {
            return audioSourceDetails(AudioSourceDetails.builder().applyMutation(audioSourceDetails).build());
        }

        /**
         * <p>
         * Details specific to video content within the source.
         * </p>
         * 
         * @param videoSourceDetails
         *        Details specific to video content within the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSourceDetails(VideoSourceDetails videoSourceDetails);

        /**
         * <p>
         * Details specific to video content within the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoSourceDetails.Builder} avoiding the
         * need to create one manually via {@link VideoSourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #videoSourceDetails(VideoSourceDetails)}.
         * 
         * @param videoSourceDetails
         *        a consumer that will call methods on {@link VideoSourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSourceDetails(VideoSourceDetails)
         */
        default Builder videoSourceDetails(Consumer<VideoSourceDetails.Builder> videoSourceDetails) {
            return videoSourceDetails(VideoSourceDetails.builder().applyMutation(videoSourceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageSourceDetails imageSourceDetails;

        private AudioSourceDetails audioSourceDetails;

        private VideoSourceDetails videoSourceDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetails model) {
            imageSourceDetails(model.imageSourceDetails);
            audioSourceDetails(model.audioSourceDetails);
            videoSourceDetails(model.videoSourceDetails);
        }

        public final ImageSourceDetails.Builder getImageSourceDetails() {
            return imageSourceDetails != null ? imageSourceDetails.toBuilder() : null;
        }

        public final void setImageSourceDetails(ImageSourceDetails.BuilderImpl imageSourceDetails) {
            Object oldValue = this.imageSourceDetails;
            this.imageSourceDetails = imageSourceDetails != null ? imageSourceDetails.build() : null;
            handleUnionValueChange(Type.IMAGE_SOURCE_DETAILS, oldValue, this.imageSourceDetails);
        }

        @Override
        public final Builder imageSourceDetails(ImageSourceDetails imageSourceDetails) {
            Object oldValue = this.imageSourceDetails;
            this.imageSourceDetails = imageSourceDetails;
            handleUnionValueChange(Type.IMAGE_SOURCE_DETAILS, oldValue, this.imageSourceDetails);
            return this;
        }

        public final AudioSourceDetails.Builder getAudioSourceDetails() {
            return audioSourceDetails != null ? audioSourceDetails.toBuilder() : null;
        }

        public final void setAudioSourceDetails(AudioSourceDetails.BuilderImpl audioSourceDetails) {
            Object oldValue = this.audioSourceDetails;
            this.audioSourceDetails = audioSourceDetails != null ? audioSourceDetails.build() : null;
            handleUnionValueChange(Type.AUDIO_SOURCE_DETAILS, oldValue, this.audioSourceDetails);
        }

        @Override
        public final Builder audioSourceDetails(AudioSourceDetails audioSourceDetails) {
            Object oldValue = this.audioSourceDetails;
            this.audioSourceDetails = audioSourceDetails;
            handleUnionValueChange(Type.AUDIO_SOURCE_DETAILS, oldValue, this.audioSourceDetails);
            return this;
        }

        public final VideoSourceDetails.Builder getVideoSourceDetails() {
            return videoSourceDetails != null ? videoSourceDetails.toBuilder() : null;
        }

        public final void setVideoSourceDetails(VideoSourceDetails.BuilderImpl videoSourceDetails) {
            Object oldValue = this.videoSourceDetails;
            this.videoSourceDetails = videoSourceDetails != null ? videoSourceDetails.build() : null;
            handleUnionValueChange(Type.VIDEO_SOURCE_DETAILS, oldValue, this.videoSourceDetails);
        }

        @Override
        public final Builder videoSourceDetails(VideoSourceDetails videoSourceDetails) {
            Object oldValue = this.videoSourceDetails;
            this.videoSourceDetails = videoSourceDetails;
            handleUnionValueChange(Type.VIDEO_SOURCE_DETAILS, oldValue, this.videoSourceDetails);
            return this;
        }

        @Override
        public SourceDetails build() {
            return new SourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SourceDetails#type()
     */
    public enum Type {
        IMAGE_SOURCE_DETAILS,

        AUDIO_SOURCE_DETAILS,

        VIDEO_SOURCE_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
