/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the relevance score of content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScoreAttributes implements SdkPojo, Serializable, ToCopyableBuilder<ScoreAttributes.Builder, ScoreAttributes> {
    private static final SdkField<String> SCORE_CONFIDENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scoreConfidence").getter(getter(ScoreAttributes::scoreConfidenceAsString))
            .setter(setter(Builder::scoreConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreConfidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scoreConfidence;

    private ScoreAttributes(BuilderImpl builder) {
        this.scoreConfidence = builder.scoreConfidence;
    }

    /**
     * <p>
     * The confidence level of the relevance score.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scoreConfidence}
     * will return {@link ScoreConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scoreConfidenceAsString}.
     * </p>
     * 
     * @return The confidence level of the relevance score.
     * @see ScoreConfidence
     */
    public final ScoreConfidence scoreConfidence() {
        return ScoreConfidence.fromValue(scoreConfidence);
    }

    /**
     * <p>
     * The confidence level of the relevance score.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scoreConfidence}
     * will return {@link ScoreConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scoreConfidenceAsString}.
     * </p>
     * 
     * @return The confidence level of the relevance score.
     * @see ScoreConfidence
     */
    public final String scoreConfidenceAsString() {
        return scoreConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scoreConfidenceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScoreAttributes)) {
            return false;
        }
        ScoreAttributes other = (ScoreAttributes) obj;
        return Objects.equals(scoreConfidenceAsString(), other.scoreConfidenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScoreAttributes").add("ScoreConfidence", scoreConfidenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scoreConfidence":
            return Optional.ofNullable(clazz.cast(scoreConfidenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scoreConfidence", SCORE_CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScoreAttributes, T> g) {
        return obj -> g.apply((ScoreAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScoreAttributes> {
        /**
         * <p>
         * The confidence level of the relevance score.
         * </p>
         * 
         * @param scoreConfidence
         *        The confidence level of the relevance score.
         * @see ScoreConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScoreConfidence
         */
        Builder scoreConfidence(String scoreConfidence);

        /**
         * <p>
         * The confidence level of the relevance score.
         * </p>
         * 
         * @param scoreConfidence
         *        The confidence level of the relevance score.
         * @see ScoreConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScoreConfidence
         */
        Builder scoreConfidence(ScoreConfidence scoreConfidence);
    }

    static final class BuilderImpl implements Builder {
        private String scoreConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ScoreAttributes model) {
            scoreConfidence(model.scoreConfidence);
        }

        public final String getScoreConfidence() {
            return scoreConfidence;
        }

        public final void setScoreConfidence(String scoreConfidence) {
            this.scoreConfidence = scoreConfidence;
        }

        @Override
        public final Builder scoreConfidence(String scoreConfidence) {
            this.scoreConfidence = scoreConfidence;
            return this;
        }

        @Override
        public final Builder scoreConfidence(ScoreConfidence scoreConfidence) {
            this.scoreConfidence(scoreConfidence == null ? null : scoreConfidence.toString());
            return this;
        }

        @Override
        public ScoreAttributes build() {
            return new ScoreAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
