/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a piece of content that is relevant to a search query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelevantContent implements SdkPojo, Serializable, ToCopyableBuilder<RelevantContent.Builder, RelevantContent> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(RelevantContent::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentId").getter(getter(RelevantContent::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentId").build()).build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentTitle").getter(getter(RelevantContent::documentTitle)).setter(setter(Builder::documentTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentTitle").build()).build();

    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentUri").getter(getter(RelevantContent::documentUri)).setter(setter(Builder::documentUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentUri").build()).build();

    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("documentAttributes")
            .getter(getter(RelevantContent::documentAttributes))
            .setter(setter(Builder::documentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField
            .<ScoreAttributes> builder(MarshallingType.SDK_POJO).memberName("scoreAttributes")
            .getter(getter(RelevantContent::scoreAttributes)).setter(setter(Builder::scoreAttributes))
            .constructor(ScoreAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String documentId;

    private final String documentTitle;

    private final String documentUri;

    private final List<DocumentAttribute> documentAttributes;

    private final ScoreAttributes scoreAttributes;

    private RelevantContent(BuilderImpl builder) {
        this.content = builder.content;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentUri = builder.documentUri;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
    }

    /**
     * <p>
     * The actual content of the relevant item.
     * </p>
     * 
     * @return The actual content of the relevant item.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The unique identifier of the document containing the relevant content.
     * </p>
     * 
     * @return The unique identifier of the document containing the relevant content.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The title of the document containing the relevant content.
     * </p>
     * 
     * @return The title of the document containing the relevant content.
     */
    public final String documentTitle() {
        return documentTitle;
    }

    /**
     * <p>
     * The URI of the document containing the relevant content.
     * </p>
     * 
     * @return The URI of the document containing the relevant content.
     */
    public final String documentUri() {
        return documentUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentAttributes() {
        return documentAttributes != null && !(documentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional attributes of the document containing the relevant content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributes} method.
     * </p>
     * 
     * @return Additional attributes of the document containing the relevant content.
     */
    public final List<DocumentAttribute> documentAttributes() {
        return documentAttributes;
    }

    /**
     * <p>
     * Attributes related to the relevance score of the content.
     * </p>
     * 
     * @return Attributes related to the relevance score of the content.
     */
    public final ScoreAttributes scoreAttributes() {
        return scoreAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentAttributes() ? documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoreAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelevantContent)) {
            return false;
        }
        RelevantContent other = (RelevantContent) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(documentId(), other.documentId())
                && Objects.equals(documentTitle(), other.documentTitle()) && Objects.equals(documentUri(), other.documentUri())
                && hasDocumentAttributes() == other.hasDocumentAttributes()
                && Objects.equals(documentAttributes(), other.documentAttributes())
                && Objects.equals(scoreAttributes(), other.scoreAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelevantContent").add("Content", content()).add("DocumentId", documentId())
                .add("DocumentTitle", documentTitle()).add("DocumentUri", documentUri())
                .add("DocumentAttributes", hasDocumentAttributes() ? documentAttributes() : null)
                .add("ScoreAttributes", scoreAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "documentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "documentTitle":
            return Optional.ofNullable(clazz.cast(documentTitle()));
        case "documentUri":
            return Optional.ofNullable(clazz.cast(documentUri()));
        case "documentAttributes":
            return Optional.ofNullable(clazz.cast(documentAttributes()));
        case "scoreAttributes":
            return Optional.ofNullable(clazz.cast(scoreAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("documentId", DOCUMENT_ID_FIELD);
        map.put("documentTitle", DOCUMENT_TITLE_FIELD);
        map.put("documentUri", DOCUMENT_URI_FIELD);
        map.put("documentAttributes", DOCUMENT_ATTRIBUTES_FIELD);
        map.put("scoreAttributes", SCORE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelevantContent, T> g) {
        return obj -> g.apply((RelevantContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelevantContent> {
        /**
         * <p>
         * The actual content of the relevant item.
         * </p>
         * 
         * @param content
         *        The actual content of the relevant item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The unique identifier of the document containing the relevant content.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the document containing the relevant content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The title of the document containing the relevant content.
         * </p>
         * 
         * @param documentTitle
         *        The title of the document containing the relevant content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitle(String documentTitle);

        /**
         * <p>
         * The URI of the document containing the relevant content.
         * </p>
         * 
         * @param documentUri
         *        The URI of the document containing the relevant content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentUri(String documentUri);

        /**
         * <p>
         * Additional attributes of the document containing the relevant content.
         * </p>
         * 
         * @param documentAttributes
         *        Additional attributes of the document containing the relevant content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(Collection<DocumentAttribute> documentAttributes);

        /**
         * <p>
         * Additional attributes of the document containing the relevant content.
         * </p>
         * 
         * @param documentAttributes
         *        Additional attributes of the document containing the relevant content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(DocumentAttribute... documentAttributes);

        /**
         * <p>
         * Additional attributes of the document containing the relevant content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #documentAttributes(List<DocumentAttribute>)}.
         * 
         * @param documentAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributes(java.util.Collection<DocumentAttribute>)
         */
        Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes);

        /**
         * <p>
         * Attributes related to the relevance score of the content.
         * </p>
         * 
         * @param scoreAttributes
         *        Attributes related to the relevance score of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreAttributes(ScoreAttributes scoreAttributes);

        /**
         * <p>
         * Attributes related to the relevance score of the content.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScoreAttributes.Builder} avoiding the
         * need to create one manually via {@link ScoreAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScoreAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #scoreAttributes(ScoreAttributes)}.
         * 
         * @param scoreAttributes
         *        a consumer that will call methods on {@link ScoreAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoreAttributes(ScoreAttributes)
         */
        default Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return scoreAttributes(ScoreAttributes.builder().applyMutation(scoreAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String documentId;

        private String documentTitle;

        private String documentUri;

        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private ScoreAttributes scoreAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RelevantContent model) {
            content(model.content);
            documentId(model.documentId);
            documentTitle(model.documentTitle);
            documentUri(model.documentUri);
            documentAttributes(model.documentAttributes);
            scoreAttributes(model.scoreAttributes);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentTitle() {
            return documentTitle;
        }

        public final void setDocumentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
        }

        @Override
        public final Builder documentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final String getDocumentUri() {
            return documentUri;
        }

        public final void setDocumentUri(String documentUri) {
            this.documentUri = documentUri;
        }

        @Override
        public final Builder documentUri(String documentUri) {
            this.documentUri = documentUri;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributesCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributesCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributesCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute... documentAttributes) {
            documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes) {
            documentAttributes(Stream.of(documentAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return scoreAttributes != null ? scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        @Override
        public RelevantContent build() {
            return new RelevantContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
