/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Authentication configuration information for an Amazon Q Business plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginAuthConfiguration.Builder, PluginAuthConfiguration> {
    private static final SdkField<BasicAuthConfiguration> BASIC_AUTH_CONFIGURATION_FIELD = SdkField
            .<BasicAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("basicAuthConfiguration")
            .getter(getter(PluginAuthConfiguration::basicAuthConfiguration)).setter(setter(Builder::basicAuthConfiguration))
            .constructor(BasicAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthConfiguration").build())
            .build();

    private static final SdkField<OAuth2ClientCredentialConfiguration> O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD = SdkField
            .<OAuth2ClientCredentialConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("oAuth2ClientCredentialConfiguration")
            .getter(getter(PluginAuthConfiguration::oAuth2ClientCredentialConfiguration))
            .setter(setter(Builder::oAuth2ClientCredentialConfiguration))
            .constructor(OAuth2ClientCredentialConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("oAuth2ClientCredentialConfiguration").build()).build();

    private static final SdkField<NoAuthConfiguration> NO_AUTH_CONFIGURATION_FIELD = SdkField
            .<NoAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("noAuthConfiguration")
            .getter(getter(PluginAuthConfiguration::noAuthConfiguration)).setter(setter(Builder::noAuthConfiguration))
            .constructor(NoAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noAuthConfiguration").build())
            .build();

    private static final SdkField<IdcAuthConfiguration> IDC_AUTH_CONFIGURATION_FIELD = SdkField
            .<IdcAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("idcAuthConfiguration")
            .getter(getter(PluginAuthConfiguration::idcAuthConfiguration)).setter(setter(Builder::idcAuthConfiguration))
            .constructor(IdcAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcAuthConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASIC_AUTH_CONFIGURATION_FIELD, O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD, NO_AUTH_CONFIGURATION_FIELD,
            IDC_AUTH_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BasicAuthConfiguration basicAuthConfiguration;

    private final OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration;

    private final NoAuthConfiguration noAuthConfiguration;

    private final IdcAuthConfiguration idcAuthConfiguration;

    private final Type type;

    private PluginAuthConfiguration(BuilderImpl builder) {
        this.basicAuthConfiguration = builder.basicAuthConfiguration;
        this.oAuth2ClientCredentialConfiguration = builder.oAuth2ClientCredentialConfiguration;
        this.noAuthConfiguration = builder.noAuthConfiguration;
        this.idcAuthConfiguration = builder.idcAuthConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about the basic authentication credentials used to configure a plugin.
     * </p>
     * 
     * @return Information about the basic authentication credentials used to configure a plugin.
     */
    public final BasicAuthConfiguration basicAuthConfiguration() {
        return basicAuthConfiguration;
    }

    /**
     * <p>
     * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     * </p>
     * 
     * @return Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     */
    public final OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration() {
        return oAuth2ClientCredentialConfiguration;
    }

    /**
     * <p>
     * Information about invoking a custom plugin without any authentication.
     * </p>
     * 
     * @return Information about invoking a custom plugin without any authentication.
     */
    public final NoAuthConfiguration noAuthConfiguration() {
        return noAuthConfiguration;
    }

    /**
     * <p>
     * Information about the IAM Identity Center Application used to configure authentication for a plugin.
     * </p>
     * 
     * @return Information about the IAM Identity Center Application used to configure authentication for a plugin.
     */
    public final IdcAuthConfiguration idcAuthConfiguration() {
        return idcAuthConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2ClientCredentialConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(noAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(idcAuthConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginAuthConfiguration)) {
            return false;
        }
        PluginAuthConfiguration other = (PluginAuthConfiguration) obj;
        return Objects.equals(basicAuthConfiguration(), other.basicAuthConfiguration())
                && Objects.equals(oAuth2ClientCredentialConfiguration(), other.oAuth2ClientCredentialConfiguration())
                && Objects.equals(noAuthConfiguration(), other.noAuthConfiguration())
                && Objects.equals(idcAuthConfiguration(), other.idcAuthConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginAuthConfiguration").add("BasicAuthConfiguration", basicAuthConfiguration())
                .add("OAuth2ClientCredentialConfiguration", oAuth2ClientCredentialConfiguration())
                .add("NoAuthConfiguration", noAuthConfiguration()).add("IdcAuthConfiguration", idcAuthConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "basicAuthConfiguration":
            return Optional.ofNullable(clazz.cast(basicAuthConfiguration()));
        case "oAuth2ClientCredentialConfiguration":
            return Optional.ofNullable(clazz.cast(oAuth2ClientCredentialConfiguration()));
        case "noAuthConfiguration":
            return Optional.ofNullable(clazz.cast(noAuthConfiguration()));
        case "idcAuthConfiguration":
            return Optional.ofNullable(clazz.cast(idcAuthConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #basicAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about the basic authentication credentials used to configure a plugin.
     * </p>
     * 
     * @param basicAuthConfiguration
     *        Information about the basic authentication credentials used to configure a plugin.
     */
    public static PluginAuthConfiguration fromBasicAuthConfiguration(BasicAuthConfiguration basicAuthConfiguration) {
        return builder().basicAuthConfiguration(basicAuthConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #basicAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about the basic authentication credentials used to configure a plugin.
     * </p>
     * 
     * @param basicAuthConfiguration
     *        Information about the basic authentication credentials used to configure a plugin.
     */
    public static PluginAuthConfiguration fromBasicAuthConfiguration(
            Consumer<BasicAuthConfiguration.Builder> basicAuthConfiguration) {
        BasicAuthConfiguration.Builder builder = BasicAuthConfiguration.builder();
        basicAuthConfiguration.accept(builder);
        return fromBasicAuthConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #oAuth2ClientCredentialConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     * </p>
     * 
     * @param oAuth2ClientCredentialConfiguration
     *        Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     */
    public static PluginAuthConfiguration fromOAuth2ClientCredentialConfiguration(
            OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration) {
        return builder().oAuth2ClientCredentialConfiguration(oAuth2ClientCredentialConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #oAuth2ClientCredentialConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     * </p>
     * 
     * @param oAuth2ClientCredentialConfiguration
     *        Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     */
    public static PluginAuthConfiguration fromOAuth2ClientCredentialConfiguration(
            Consumer<OAuth2ClientCredentialConfiguration.Builder> oAuth2ClientCredentialConfiguration) {
        OAuth2ClientCredentialConfiguration.Builder builder = OAuth2ClientCredentialConfiguration.builder();
        oAuth2ClientCredentialConfiguration.accept(builder);
        return fromOAuth2ClientCredentialConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about invoking a custom plugin without any authentication.
     * </p>
     * 
     * @param noAuthConfiguration
     *        Information about invoking a custom plugin without any authentication.
     */
    public static PluginAuthConfiguration fromNoAuthConfiguration(NoAuthConfiguration noAuthConfiguration) {
        return builder().noAuthConfiguration(noAuthConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #noAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about invoking a custom plugin without any authentication.
     * </p>
     * 
     * @param noAuthConfiguration
     *        Information about invoking a custom plugin without any authentication.
     */
    public static PluginAuthConfiguration fromNoAuthConfiguration(Consumer<NoAuthConfiguration.Builder> noAuthConfiguration) {
        NoAuthConfiguration.Builder builder = NoAuthConfiguration.builder();
        noAuthConfiguration.accept(builder);
        return fromNoAuthConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #idcAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about the IAM Identity Center Application used to configure authentication for a plugin.
     * </p>
     * 
     * @param idcAuthConfiguration
     *        Information about the IAM Identity Center Application used to configure authentication for a plugin.
     */
    public static PluginAuthConfiguration fromIdcAuthConfiguration(IdcAuthConfiguration idcAuthConfiguration) {
        return builder().idcAuthConfiguration(idcAuthConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #idcAuthConfiguration()} initialized to the given value.
     *
     * <p>
     * Information about the IAM Identity Center Application used to configure authentication for a plugin.
     * </p>
     * 
     * @param idcAuthConfiguration
     *        Information about the IAM Identity Center Application used to configure authentication for a plugin.
     */
    public static PluginAuthConfiguration fromIdcAuthConfiguration(Consumer<IdcAuthConfiguration.Builder> idcAuthConfiguration) {
        IdcAuthConfiguration.Builder builder = IdcAuthConfiguration.builder();
        idcAuthConfiguration.accept(builder);
        return fromIdcAuthConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("basicAuthConfiguration", BASIC_AUTH_CONFIGURATION_FIELD);
        map.put("oAuth2ClientCredentialConfiguration", O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD);
        map.put("noAuthConfiguration", NO_AUTH_CONFIGURATION_FIELD);
        map.put("idcAuthConfiguration", IDC_AUTH_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginAuthConfiguration, T> g) {
        return obj -> g.apply((PluginAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginAuthConfiguration> {
        /**
         * <p>
         * Information about the basic authentication credentials used to configure a plugin.
         * </p>
         * 
         * @param basicAuthConfiguration
         *        Information about the basic authentication credentials used to configure a plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthConfiguration(BasicAuthConfiguration basicAuthConfiguration);

        /**
         * <p>
         * Information about the basic authentication credentials used to configure a plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link BasicAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #basicAuthConfiguration(BasicAuthConfiguration)}.
         * 
         * @param basicAuthConfiguration
         *        a consumer that will call methods on {@link BasicAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthConfiguration(BasicAuthConfiguration)
         */
        default Builder basicAuthConfiguration(Consumer<BasicAuthConfiguration.Builder> basicAuthConfiguration) {
            return basicAuthConfiguration(BasicAuthConfiguration.builder().applyMutation(basicAuthConfiguration).build());
        }

        /**
         * <p>
         * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
         * </p>
         * 
         * @param oAuth2ClientCredentialConfiguration
         *        Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration);

        /**
         * <p>
         * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OAuth2ClientCredentialConfiguration.Builder} avoiding the need to create one manually via
         * {@link OAuth2ClientCredentialConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2ClientCredentialConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration)}.
         * 
         * @param oAuth2ClientCredentialConfiguration
         *        a consumer that will call methods on {@link OAuth2ClientCredentialConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration)
         */
        default Builder oAuth2ClientCredentialConfiguration(
                Consumer<OAuth2ClientCredentialConfiguration.Builder> oAuth2ClientCredentialConfiguration) {
            return oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration.builder()
                    .applyMutation(oAuth2ClientCredentialConfiguration).build());
        }

        /**
         * <p>
         * Information about invoking a custom plugin without any authentication.
         * </p>
         * 
         * @param noAuthConfiguration
         *        Information about invoking a custom plugin without any authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noAuthConfiguration(NoAuthConfiguration noAuthConfiguration);

        /**
         * <p>
         * Information about invoking a custom plugin without any authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoAuthConfiguration.Builder} avoiding the
         * need to create one manually via {@link NoAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoAuthConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #noAuthConfiguration(NoAuthConfiguration)}.
         * 
         * @param noAuthConfiguration
         *        a consumer that will call methods on {@link NoAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noAuthConfiguration(NoAuthConfiguration)
         */
        default Builder noAuthConfiguration(Consumer<NoAuthConfiguration.Builder> noAuthConfiguration) {
            return noAuthConfiguration(NoAuthConfiguration.builder().applyMutation(noAuthConfiguration).build());
        }

        /**
         * <p>
         * Information about the IAM Identity Center Application used to configure authentication for a plugin.
         * </p>
         * 
         * @param idcAuthConfiguration
         *        Information about the IAM Identity Center Application used to configure authentication for a plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcAuthConfiguration(IdcAuthConfiguration idcAuthConfiguration);

        /**
         * <p>
         * Information about the IAM Identity Center Application used to configure authentication for a plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdcAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link IdcAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdcAuthConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #idcAuthConfiguration(IdcAuthConfiguration)}.
         * 
         * @param idcAuthConfiguration
         *        a consumer that will call methods on {@link IdcAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idcAuthConfiguration(IdcAuthConfiguration)
         */
        default Builder idcAuthConfiguration(Consumer<IdcAuthConfiguration.Builder> idcAuthConfiguration) {
            return idcAuthConfiguration(IdcAuthConfiguration.builder().applyMutation(idcAuthConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BasicAuthConfiguration basicAuthConfiguration;

        private OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration;

        private NoAuthConfiguration noAuthConfiguration;

        private IdcAuthConfiguration idcAuthConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PluginAuthConfiguration model) {
            basicAuthConfiguration(model.basicAuthConfiguration);
            oAuth2ClientCredentialConfiguration(model.oAuth2ClientCredentialConfiguration);
            noAuthConfiguration(model.noAuthConfiguration);
            idcAuthConfiguration(model.idcAuthConfiguration);
        }

        public final BasicAuthConfiguration.Builder getBasicAuthConfiguration() {
            return basicAuthConfiguration != null ? basicAuthConfiguration.toBuilder() : null;
        }

        public final void setBasicAuthConfiguration(BasicAuthConfiguration.BuilderImpl basicAuthConfiguration) {
            Object oldValue = this.basicAuthConfiguration;
            this.basicAuthConfiguration = basicAuthConfiguration != null ? basicAuthConfiguration.build() : null;
            handleUnionValueChange(Type.BASIC_AUTH_CONFIGURATION, oldValue, this.basicAuthConfiguration);
        }

        @Override
        public final Builder basicAuthConfiguration(BasicAuthConfiguration basicAuthConfiguration) {
            Object oldValue = this.basicAuthConfiguration;
            this.basicAuthConfiguration = basicAuthConfiguration;
            handleUnionValueChange(Type.BASIC_AUTH_CONFIGURATION, oldValue, this.basicAuthConfiguration);
            return this;
        }

        public final OAuth2ClientCredentialConfiguration.Builder getOAuth2ClientCredentialConfiguration() {
            return oAuth2ClientCredentialConfiguration != null ? oAuth2ClientCredentialConfiguration.toBuilder() : null;
        }

        public final void setOAuth2ClientCredentialConfiguration(
                OAuth2ClientCredentialConfiguration.BuilderImpl oAuth2ClientCredentialConfiguration) {
            Object oldValue = this.oAuth2ClientCredentialConfiguration;
            this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration != null ? oAuth2ClientCredentialConfiguration
                    .build() : null;
            handleUnionValueChange(Type.O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION, oldValue,
                    this.oAuth2ClientCredentialConfiguration);
        }

        @Override
        public final Builder oAuth2ClientCredentialConfiguration(
                OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration) {
            Object oldValue = this.oAuth2ClientCredentialConfiguration;
            this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration;
            handleUnionValueChange(Type.O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION, oldValue,
                    this.oAuth2ClientCredentialConfiguration);
            return this;
        }

        public final NoAuthConfiguration.Builder getNoAuthConfiguration() {
            return noAuthConfiguration != null ? noAuthConfiguration.toBuilder() : null;
        }

        public final void setNoAuthConfiguration(NoAuthConfiguration.BuilderImpl noAuthConfiguration) {
            Object oldValue = this.noAuthConfiguration;
            this.noAuthConfiguration = noAuthConfiguration != null ? noAuthConfiguration.build() : null;
            handleUnionValueChange(Type.NO_AUTH_CONFIGURATION, oldValue, this.noAuthConfiguration);
        }

        @Override
        public final Builder noAuthConfiguration(NoAuthConfiguration noAuthConfiguration) {
            Object oldValue = this.noAuthConfiguration;
            this.noAuthConfiguration = noAuthConfiguration;
            handleUnionValueChange(Type.NO_AUTH_CONFIGURATION, oldValue, this.noAuthConfiguration);
            return this;
        }

        public final IdcAuthConfiguration.Builder getIdcAuthConfiguration() {
            return idcAuthConfiguration != null ? idcAuthConfiguration.toBuilder() : null;
        }

        public final void setIdcAuthConfiguration(IdcAuthConfiguration.BuilderImpl idcAuthConfiguration) {
            Object oldValue = this.idcAuthConfiguration;
            this.idcAuthConfiguration = idcAuthConfiguration != null ? idcAuthConfiguration.build() : null;
            handleUnionValueChange(Type.IDC_AUTH_CONFIGURATION, oldValue, this.idcAuthConfiguration);
        }

        @Override
        public final Builder idcAuthConfiguration(IdcAuthConfiguration idcAuthConfiguration) {
            Object oldValue = this.idcAuthConfiguration;
            this.idcAuthConfiguration = idcAuthConfiguration;
            handleUnionValueChange(Type.IDC_AUTH_CONFIGURATION, oldValue, this.idcAuthConfiguration);
            return this;
        }

        @Override
        public PluginAuthConfiguration build() {
            return new PluginAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PluginAuthConfiguration#type()
     */
    public enum Type {
        BASIC_AUTH_CONFIGURATION,

        O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION,

        NO_AUTH_CONFIGURATION,

        IDC_AUTH_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
