/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscriptionsResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListSubscriptionsResponse.Builder, ListSubscriptionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubscriptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .memberName("subscriptions")
            .getter(getter(ListSubscriptionsResponse::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUBSCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Subscription> subscriptions;

    private ListSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subscriptions = builder.subscriptions;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Q Business returns this token. You can use this token in a subsequent
     * request to retrieve the next set of subscriptions.
     * </p>
     * 
     * @return If the response is truncated, Amazon Q Business returns this token. You can use this token in a
     *         subsequent request to retrieve the next set of subscriptions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information on the subscriptions configured for an Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptions} method.
     * </p>
     * 
     * @return An array of summary information on the subscriptions configured for an Amazon Q Business application.
     */
    public final List<Subscription> subscriptions() {
        return subscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptions() ? subscriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsResponse)) {
            return false;
        }
        ListSubscriptionsResponse other = (ListSubscriptionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSubscriptions() == other.hasSubscriptions()
                && Objects.equals(subscriptions(), other.subscriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscriptionsResponse").add("NextToken", nextToken())
                .add("Subscriptions", hasSubscriptions() ? subscriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("subscriptions", SUBSCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListSubscriptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscriptionsResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon Q Business returns this token. You can use this token in a subsequent
         * request to retrieve the next set of subscriptions.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Q Business returns this token. You can use this token in a
         *        subsequent request to retrieve the next set of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of summary information on the subscriptions configured for an Amazon Q Business application.
         * </p>
         * 
         * @param subscriptions
         *        An array of summary information on the subscriptions configured for an Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * An array of summary information on the subscriptions configured for an Amazon Q Business application.
         * </p>
         * 
         * @param subscriptions
         *        An array of summary information on the subscriptions configured for an Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * An array of summary information on the subscriptions configured for an Amazon Q Business application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Subscription.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.Subscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Subscription.Builder#build()} is called immediately
         * and its result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(java.util.Collection<Subscription>)
         */
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            subscriptions(model.subscriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionsCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionsCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSubscriptionsResponse build() {
            return new ListSubscriptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
