/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChatResponseConfigurationsResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListChatResponseConfigurationsResponse.Builder, ListChatResponseConfigurationsResponse> {
    private static final SdkField<List<ChatResponseConfiguration>> CHAT_RESPONSE_CONFIGURATIONS_FIELD = SdkField
            .<List<ChatResponseConfiguration>> builder(MarshallingType.LIST)
            .memberName("chatResponseConfigurations")
            .getter(getter(ListChatResponseConfigurationsResponse::chatResponseConfigurations))
            .setter(setter(Builder::chatResponseConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChatResponseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChatResponseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListChatResponseConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHAT_RESPONSE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChatResponseConfiguration> chatResponseConfigurations;

    private final String nextToken;

    private ListChatResponseConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.chatResponseConfigurations = builder.chatResponseConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChatResponseConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChatResponseConfigurations() {
        return chatResponseConfigurations != null && !(chatResponseConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of chat response configuration summaries, each containing key information about an available configuration
     * in the specified application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChatResponseConfigurations} method.
     * </p>
     * 
     * @return A list of chat response configuration summaries, each containing key information about an available
     *         configuration in the specified application.
     */
    public final List<ChatResponseConfiguration> chatResponseConfigurations() {
        return chatResponseConfigurations;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent request to retrieve additional chat response configurations
     * if the results were truncated due to the <code>maxResults</code> parameter.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent request to retrieve additional chat response
     *         configurations if the results were truncated due to the <code>maxResults</code> parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChatResponseConfigurations() ? chatResponseConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChatResponseConfigurationsResponse)) {
            return false;
        }
        ListChatResponseConfigurationsResponse other = (ListChatResponseConfigurationsResponse) obj;
        return hasChatResponseConfigurations() == other.hasChatResponseConfigurations()
                && Objects.equals(chatResponseConfigurations(), other.chatResponseConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChatResponseConfigurationsResponse")
                .add("ChatResponseConfigurations", hasChatResponseConfigurations() ? chatResponseConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatResponseConfigurations":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chatResponseConfigurations", CHAT_RESPONSE_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChatResponseConfigurationsResponse, T> g) {
        return obj -> g.apply((ListChatResponseConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChatResponseConfigurationsResponse> {
        /**
         * <p>
         * A list of chat response configuration summaries, each containing key information about an available
         * configuration in the specified application.
         * </p>
         * 
         * @param chatResponseConfigurations
         *        A list of chat response configuration summaries, each containing key information about an available
         *        configuration in the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurations(Collection<ChatResponseConfiguration> chatResponseConfigurations);

        /**
         * <p>
         * A list of chat response configuration summaries, each containing key information about an available
         * configuration in the specified application.
         * </p>
         * 
         * @param chatResponseConfigurations
         *        A list of chat response configuration summaries, each containing key information about an available
         *        configuration in the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurations(ChatResponseConfiguration... chatResponseConfigurations);

        /**
         * <p>
         * A list of chat response configuration summaries, each containing key information about an available
         * configuration in the specified application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chatResponseConfigurations(List<ChatResponseConfiguration>)}.
         * 
         * @param chatResponseConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatResponseConfigurations(java.util.Collection<ChatResponseConfiguration>)
         */
        Builder chatResponseConfigurations(Consumer<ChatResponseConfiguration.Builder>... chatResponseConfigurations);

        /**
         * <p>
         * A pagination token that can be used in a subsequent request to retrieve additional chat response
         * configurations if the results were truncated due to the <code>maxResults</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent request to retrieve additional chat response
         *        configurations if the results were truncated due to the <code>maxResults</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<ChatResponseConfiguration> chatResponseConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChatResponseConfigurationsResponse model) {
            super(model);
            chatResponseConfigurations(model.chatResponseConfigurations);
            nextToken(model.nextToken);
        }

        public final List<ChatResponseConfiguration.Builder> getChatResponseConfigurations() {
            List<ChatResponseConfiguration.Builder> result = ChatResponseConfigurationsCopier
                    .copyToBuilder(this.chatResponseConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChatResponseConfigurations(
                Collection<ChatResponseConfiguration.BuilderImpl> chatResponseConfigurations) {
            this.chatResponseConfigurations = ChatResponseConfigurationsCopier.copyFromBuilder(chatResponseConfigurations);
        }

        @Override
        public final Builder chatResponseConfigurations(Collection<ChatResponseConfiguration> chatResponseConfigurations) {
            this.chatResponseConfigurations = ChatResponseConfigurationsCopier.copy(chatResponseConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chatResponseConfigurations(ChatResponseConfiguration... chatResponseConfigurations) {
            chatResponseConfigurations(Arrays.asList(chatResponseConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chatResponseConfigurations(Consumer<ChatResponseConfiguration.Builder>... chatResponseConfigurations) {
            chatResponseConfigurations(Stream.of(chatResponseConfigurations)
                    .map(c -> ChatResponseConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChatResponseConfigurationsResponse build() {
            return new ListChatResponseConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
