/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting
 * documents into Amazon Q Business.
 * </p>
 * <p>
 * To apply advanced logic, to go beyond what you can do with basic logic, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_HookConfiguration.html">
 * <code>HookConfiguration</code> </a>.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document
 * enrichment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineDocumentEnrichmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineDocumentEnrichmentConfiguration.Builder, InlineDocumentEnrichmentConfiguration> {
    private static final SdkField<DocumentAttributeCondition> CONDITION_FIELD = SdkField
            .<DocumentAttributeCondition> builder(MarshallingType.SDK_POJO).memberName("condition")
            .getter(getter(InlineDocumentEnrichmentConfiguration::condition)).setter(setter(Builder::condition))
            .constructor(DocumentAttributeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<DocumentAttributeTarget> TARGET_FIELD = SdkField
            .<DocumentAttributeTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(InlineDocumentEnrichmentConfiguration::target)).setter(setter(Builder::target))
            .constructor(DocumentAttributeTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> DOCUMENT_CONTENT_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentContentOperator")
            .getter(getter(InlineDocumentEnrichmentConfiguration::documentContentOperatorAsString))
            .setter(setter(Builder::documentContentOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentContentOperator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, TARGET_FIELD,
            DOCUMENT_CONTENT_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentAttributeCondition condition;

    private final DocumentAttributeTarget target;

    private final String documentContentOperator;

    private InlineDocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.condition = builder.condition;
        this.target = builder.target;
        this.documentContentOperator = builder.documentContentOperator;
    }

    /**
     * Returns the value of the Condition property for this object.
     * 
     * @return The value of the Condition property for this object.
     */
    public final DocumentAttributeCondition condition() {
        return condition;
    }

    /**
     * Returns the value of the Target property for this object.
     * 
     * @return The value of the Target property for this object.
     */
    public final DocumentAttributeTarget target() {
        return target;
    }

    /**
     * <p>
     * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentOperator} will return {@link DocumentContentOperator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #documentContentOperatorAsString}.
     * </p>
     * 
     * @return <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     * @see DocumentContentOperator
     */
    public final DocumentContentOperator documentContentOperator() {
        return DocumentContentOperator.fromValue(documentContentOperator);
    }

    /**
     * <p>
     * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentOperator} will return {@link DocumentContentOperator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #documentContentOperatorAsString}.
     * </p>
     * 
     * @return <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     * @see DocumentContentOperator
     */
    public final String documentContentOperatorAsString() {
        return documentContentOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(documentContentOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineDocumentEnrichmentConfiguration)) {
            return false;
        }
        InlineDocumentEnrichmentConfiguration other = (InlineDocumentEnrichmentConfiguration) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(target(), other.target())
                && Objects.equals(documentContentOperatorAsString(), other.documentContentOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineDocumentEnrichmentConfiguration").add("Condition", condition()).add("Target", target())
                .add("DocumentContentOperator", documentContentOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "documentContentOperator":
            return Optional.ofNullable(clazz.cast(documentContentOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("condition", CONDITION_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("documentContentOperator", DOCUMENT_CONTENT_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineDocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((InlineDocumentEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineDocumentEnrichmentConfiguration> {
        /**
         * Sets the value of the Condition property for this object.
         *
         * @param condition
         *        The new value for the Condition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(DocumentAttributeCondition condition);

        /**
         * Sets the value of the Condition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentAttributeCondition.Builder}
         * avoiding the need to create one manually via {@link DocumentAttributeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #condition(DocumentAttributeCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link DocumentAttributeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(DocumentAttributeCondition)
         */
        default Builder condition(Consumer<DocumentAttributeCondition.Builder> condition) {
            return condition(DocumentAttributeCondition.builder().applyMutation(condition).build());
        }

        /**
         * Sets the value of the Target property for this object.
         *
         * @param target
         *        The new value for the Target property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(DocumentAttributeTarget target);

        /**
         * Sets the value of the Target property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentAttributeTarget.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #target(DocumentAttributeTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link DocumentAttributeTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(DocumentAttributeTarget)
         */
        default Builder target(Consumer<DocumentAttributeTarget.Builder> target) {
            return target(DocumentAttributeTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * </p>
         * 
         * @param documentContentOperator
         *        <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * @see DocumentContentOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentContentOperator
         */
        Builder documentContentOperator(String documentContentOperator);

        /**
         * <p>
         * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * </p>
         * 
         * @param documentContentOperator
         *        <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * @see DocumentContentOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentContentOperator
         */
        Builder documentContentOperator(DocumentContentOperator documentContentOperator);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttributeCondition condition;

        private DocumentAttributeTarget target;

        private String documentContentOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineDocumentEnrichmentConfiguration model) {
            condition(model.condition);
            target(model.target);
            documentContentOperator(model.documentContentOperator);
        }

        public final DocumentAttributeCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(DocumentAttributeCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(DocumentAttributeCondition condition) {
            this.condition = condition;
            return this;
        }

        public final DocumentAttributeTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(DocumentAttributeTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DocumentAttributeTarget target) {
            this.target = target;
            return this;
        }

        public final String getDocumentContentOperator() {
            return documentContentOperator;
        }

        public final void setDocumentContentOperator(String documentContentOperator) {
            this.documentContentOperator = documentContentOperator;
        }

        @Override
        public final Builder documentContentOperator(String documentContentOperator) {
            this.documentContentOperator = documentContentOperator;
            return this;
        }

        @Override
        public final Builder documentContentOperator(DocumentContentOperator documentContentOperator) {
            this.documentContentOperator(documentContentOperator == null ? null : documentContentOperator.toString());
            return this;
        }

        @Override
        public InlineDocumentEnrichmentConfiguration build() {
            return new InlineDocumentEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
