/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of documents in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexStatistics implements SdkPojo, Serializable, ToCopyableBuilder<IndexStatistics.Builder, IndexStatistics> {
    private static final SdkField<TextDocumentStatistics> TEXT_DOCUMENT_STATISTICS_FIELD = SdkField
            .<TextDocumentStatistics> builder(MarshallingType.SDK_POJO).memberName("textDocumentStatistics")
            .getter(getter(IndexStatistics::textDocumentStatistics)).setter(setter(Builder::textDocumentStatistics))
            .constructor(TextDocumentStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textDocumentStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEXT_DOCUMENT_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextDocumentStatistics textDocumentStatistics;

    private IndexStatistics(BuilderImpl builder) {
        this.textDocumentStatistics = builder.textDocumentStatistics;
    }

    /**
     * <p>
     * The number of documents indexed.
     * </p>
     * 
     * @return The number of documents indexed.
     */
    public final TextDocumentStatistics textDocumentStatistics() {
        return textDocumentStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textDocumentStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexStatistics)) {
            return false;
        }
        IndexStatistics other = (IndexStatistics) obj;
        return Objects.equals(textDocumentStatistics(), other.textDocumentStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexStatistics").add("TextDocumentStatistics", textDocumentStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textDocumentStatistics":
            return Optional.ofNullable(clazz.cast(textDocumentStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textDocumentStatistics", TEXT_DOCUMENT_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexStatistics, T> g) {
        return obj -> g.apply((IndexStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexStatistics> {
        /**
         * <p>
         * The number of documents indexed.
         * </p>
         * 
         * @param textDocumentStatistics
         *        The number of documents indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDocumentStatistics(TextDocumentStatistics textDocumentStatistics);

        /**
         * <p>
         * The number of documents indexed.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextDocumentStatistics.Builder} avoiding
         * the need to create one manually via {@link TextDocumentStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextDocumentStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #textDocumentStatistics(TextDocumentStatistics)}.
         * 
         * @param textDocumentStatistics
         *        a consumer that will call methods on {@link TextDocumentStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDocumentStatistics(TextDocumentStatistics)
         */
        default Builder textDocumentStatistics(Consumer<TextDocumentStatistics.Builder> textDocumentStatistics) {
            return textDocumentStatistics(TextDocumentStatistics.builder().applyMutation(textDocumentStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextDocumentStatistics textDocumentStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexStatistics model) {
            textDocumentStatistics(model.textDocumentStatistics);
        }

        public final TextDocumentStatistics.Builder getTextDocumentStatistics() {
            return textDocumentStatistics != null ? textDocumentStatistics.toBuilder() : null;
        }

        public final void setTextDocumentStatistics(TextDocumentStatistics.BuilderImpl textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics != null ? textDocumentStatistics.build() : null;
        }

        @Override
        public final Builder textDocumentStatistics(TextDocumentStatistics textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics;
            return this;
        }

        @Override
        public IndexStatistics build() {
            return new IndexStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
