/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an image source, including its identifier and format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageSourceDetails.Builder, ImageSourceDetails> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(ImageSourceDetails::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaMimeType").getter(getter(ImageSourceDetails::mediaMimeType)).setter(setter(Builder::mediaMimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD,
            MEDIA_MIME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaId;

    private final String mediaMimeType;

    private ImageSourceDetails(BuilderImpl builder) {
        this.mediaId = builder.mediaId;
        this.mediaMimeType = builder.mediaMimeType;
    }

    /**
     * <p>
     * Unique identifier for the image file.
     * </p>
     * 
     * @return Unique identifier for the image file.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The MIME type of the image file.
     * </p>
     * 
     * @return The MIME type of the image file.
     */
    public final String mediaMimeType() {
        return mediaMimeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaMimeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSourceDetails)) {
            return false;
        }
        ImageSourceDetails other = (ImageSourceDetails) obj;
        return Objects.equals(mediaId(), other.mediaId()) && Objects.equals(mediaMimeType(), other.mediaMimeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSourceDetails").add("MediaId", mediaId()).add("MediaMimeType", mediaMimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "mediaMimeType":
            return Optional.ofNullable(clazz.cast(mediaMimeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSourceDetails, T> g) {
        return obj -> g.apply((ImageSourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSourceDetails> {
        /**
         * <p>
         * Unique identifier for the image file.
         * </p>
         * 
         * @param mediaId
         *        Unique identifier for the image file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The MIME type of the image file.
         * </p>
         * 
         * @param mediaMimeType
         *        The MIME type of the image file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaMimeType(String mediaMimeType);
    }

    static final class BuilderImpl implements Builder {
        private String mediaId;

        private String mediaMimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSourceDetails model) {
            mediaId(model.mediaId);
            mediaMimeType(model.mediaMimeType);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getMediaMimeType() {
            return mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        @Override
        public ImageSourceDetails build() {
            return new ImageSourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
