/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for extracting semantic meaning from images in documents. For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
 * semantic meaning from images and visuals</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageExtractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageExtractionConfiguration.Builder, ImageExtractionConfiguration> {
    private static final SdkField<String> IMAGE_EXTRACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageExtractionStatus").getter(getter(ImageExtractionConfiguration::imageExtractionStatusAsString))
            .setter(setter(Builder::imageExtractionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageExtractionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IMAGE_EXTRACTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageExtractionStatus;

    private ImageExtractionConfiguration(BuilderImpl builder) {
        this.imageExtractionStatus = builder.imageExtractionStatus;
    }

    /**
     * <p>
     * Specify whether to extract semantic meaning from images and visuals from documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageExtractionStatus} will return {@link ImageExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageExtractionStatusAsString}.
     * </p>
     * 
     * @return Specify whether to extract semantic meaning from images and visuals from documents.
     * @see ImageExtractionStatus
     */
    public final ImageExtractionStatus imageExtractionStatus() {
        return ImageExtractionStatus.fromValue(imageExtractionStatus);
    }

    /**
     * <p>
     * Specify whether to extract semantic meaning from images and visuals from documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageExtractionStatus} will return {@link ImageExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageExtractionStatusAsString}.
     * </p>
     * 
     * @return Specify whether to extract semantic meaning from images and visuals from documents.
     * @see ImageExtractionStatus
     */
    public final String imageExtractionStatusAsString() {
        return imageExtractionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageExtractionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageExtractionConfiguration)) {
            return false;
        }
        ImageExtractionConfiguration other = (ImageExtractionConfiguration) obj;
        return Objects.equals(imageExtractionStatusAsString(), other.imageExtractionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageExtractionConfiguration").add("ImageExtractionStatus", imageExtractionStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageExtractionStatus":
            return Optional.ofNullable(clazz.cast(imageExtractionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageExtractionStatus", IMAGE_EXTRACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageExtractionConfiguration, T> g) {
        return obj -> g.apply((ImageExtractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageExtractionConfiguration> {
        /**
         * <p>
         * Specify whether to extract semantic meaning from images and visuals from documents.
         * </p>
         * 
         * @param imageExtractionStatus
         *        Specify whether to extract semantic meaning from images and visuals from documents.
         * @see ImageExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageExtractionStatus
         */
        Builder imageExtractionStatus(String imageExtractionStatus);

        /**
         * <p>
         * Specify whether to extract semantic meaning from images and visuals from documents.
         * </p>
         * 
         * @param imageExtractionStatus
         *        Specify whether to extract semantic meaning from images and visuals from documents.
         * @see ImageExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageExtractionStatus
         */
        Builder imageExtractionStatus(ImageExtractionStatus imageExtractionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String imageExtractionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageExtractionConfiguration model) {
            imageExtractionStatus(model.imageExtractionStatus);
        }

        public final String getImageExtractionStatus() {
            return imageExtractionStatus;
        }

        public final void setImageExtractionStatus(String imageExtractionStatus) {
            this.imageExtractionStatus = imageExtractionStatus;
        }

        @Override
        public final Builder imageExtractionStatus(String imageExtractionStatus) {
            this.imageExtractionStatus = imageExtractionStatus;
            return this;
        }

        @Override
        public final Builder imageExtractionStatus(ImageExtractionStatus imageExtractionStatus) {
            this.imageExtractionStatus(imageExtractionStatus == null ? null : imageExtractionStatus.toString());
            return this;
        }

        @Override
        public ImageExtractionConfiguration build() {
            return new ImageExtractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
