/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
 * experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderConfiguration.Builder, IdentityProviderConfiguration> {
    private static final SdkField<SamlProviderConfiguration> SAML_CONFIGURATION_FIELD = SdkField
            .<SamlProviderConfiguration> builder(MarshallingType.SDK_POJO).memberName("samlConfiguration")
            .getter(getter(IdentityProviderConfiguration::samlConfiguration)).setter(setter(Builder::samlConfiguration))
            .constructor(SamlProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()).build();

    private static final SdkField<OpenIDConnectProviderConfiguration> OPEN_ID_CONNECT_CONFIGURATION_FIELD = SdkField
            .<OpenIDConnectProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("openIDConnectConfiguration")
            .getter(getter(IdentityProviderConfiguration::openIDConnectConfiguration))
            .setter(setter(Builder::openIDConnectConfiguration))
            .constructor(OpenIDConnectProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_CONFIGURATION_FIELD,
            OPEN_ID_CONNECT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SamlProviderConfiguration samlConfiguration;

    private final OpenIDConnectProviderConfiguration openIDConnectConfiguration;

    private final Type type;

    private IdentityProviderConfiguration(BuilderImpl builder) {
        this.samlConfiguration = builder.samlConfiguration;
        this.openIDConnectConfiguration = builder.openIDConnectConfiguration;
        this.type = builder.type;
    }

    /**
     * Returns the value of the SamlConfiguration property for this object.
     * 
     * @return The value of the SamlConfiguration property for this object.
     */
    public final SamlProviderConfiguration samlConfiguration() {
        return samlConfiguration;
    }

    /**
     * Returns the value of the OpenIDConnectConfiguration property for this object.
     * 
     * @return The value of the OpenIDConnectConfiguration property for this object.
     */
    public final OpenIDConnectProviderConfiguration openIDConnectConfiguration() {
        return openIDConnectConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderConfiguration)) {
            return false;
        }
        IdentityProviderConfiguration other = (IdentityProviderConfiguration) obj;
        return Objects.equals(samlConfiguration(), other.samlConfiguration())
                && Objects.equals(openIDConnectConfiguration(), other.openIDConnectConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderConfiguration").add("SamlConfiguration", samlConfiguration())
                .add("OpenIDConnectConfiguration", openIDConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "samlConfiguration":
            return Optional.ofNullable(clazz.cast(samlConfiguration()));
        case "openIDConnectConfiguration":
            return Optional.ofNullable(clazz.cast(openIDConnectConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #samlConfiguration()} initialized to the given value.
     *
     * Sets the value of the SamlConfiguration property for this object.
     *
     * @param samlConfiguration
     *        The new value for the SamlConfiguration property for this object.
     */
    public static IdentityProviderConfiguration fromSamlConfiguration(SamlProviderConfiguration samlConfiguration) {
        return builder().samlConfiguration(samlConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #samlConfiguration()} initialized to the given value.
     *
     * Sets the value of the SamlConfiguration property for this object.
     *
     * @param samlConfiguration
     *        The new value for the SamlConfiguration property for this object.
     */
    public static IdentityProviderConfiguration fromSamlConfiguration(
            Consumer<SamlProviderConfiguration.Builder> samlConfiguration) {
        SamlProviderConfiguration.Builder builder = SamlProviderConfiguration.builder();
        samlConfiguration.accept(builder);
        return fromSamlConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #openIDConnectConfiguration()} initialized to the given value.
     *
     * Sets the value of the OpenIDConnectConfiguration property for this object.
     *
     * @param openIDConnectConfiguration
     *        The new value for the OpenIDConnectConfiguration property for this object.
     */
    public static IdentityProviderConfiguration fromOpenIDConnectConfiguration(
            OpenIDConnectProviderConfiguration openIDConnectConfiguration) {
        return builder().openIDConnectConfiguration(openIDConnectConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #openIDConnectConfiguration()} initialized to the given value.
     *
     * Sets the value of the OpenIDConnectConfiguration property for this object.
     *
     * @param openIDConnectConfiguration
     *        The new value for the OpenIDConnectConfiguration property for this object.
     */
    public static IdentityProviderConfiguration fromOpenIDConnectConfiguration(
            Consumer<OpenIDConnectProviderConfiguration.Builder> openIDConnectConfiguration) {
        OpenIDConnectProviderConfiguration.Builder builder = OpenIDConnectProviderConfiguration.builder();
        openIDConnectConfiguration.accept(builder);
        return fromOpenIDConnectConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("samlConfiguration", SAML_CONFIGURATION_FIELD);
        map.put("openIDConnectConfiguration", OPEN_ID_CONNECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderConfiguration, T> g) {
        return obj -> g.apply((IdentityProviderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderConfiguration> {
        /**
         * Sets the value of the SamlConfiguration property for this object.
         *
         * @param samlConfiguration
         *        The new value for the SamlConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlConfiguration(SamlProviderConfiguration samlConfiguration);

        /**
         * Sets the value of the SamlConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SamlProviderConfiguration.Builder}
         * avoiding the need to create one manually via {@link SamlProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlProviderConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #samlConfiguration(SamlProviderConfiguration)}.
         * 
         * @param samlConfiguration
         *        a consumer that will call methods on {@link SamlProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlConfiguration(SamlProviderConfiguration)
         */
        default Builder samlConfiguration(Consumer<SamlProviderConfiguration.Builder> samlConfiguration) {
            return samlConfiguration(SamlProviderConfiguration.builder().applyMutation(samlConfiguration).build());
        }

        /**
         * Sets the value of the OpenIDConnectConfiguration property for this object.
         *
         * @param openIDConnectConfiguration
         *        The new value for the OpenIDConnectConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfiguration(OpenIDConnectProviderConfiguration openIDConnectConfiguration);

        /**
         * Sets the value of the OpenIDConnectConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link OpenIDConnectProviderConfiguration.Builder} avoiding the need to create one manually via
         * {@link OpenIDConnectProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIDConnectProviderConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #openIDConnectConfiguration(OpenIDConnectProviderConfiguration)}.
         * 
         * @param openIDConnectConfiguration
         *        a consumer that will call methods on {@link OpenIDConnectProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfiguration(OpenIDConnectProviderConfiguration)
         */
        default Builder openIDConnectConfiguration(Consumer<OpenIDConnectProviderConfiguration.Builder> openIDConnectConfiguration) {
            return openIDConnectConfiguration(OpenIDConnectProviderConfiguration.builder()
                    .applyMutation(openIDConnectConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SamlProviderConfiguration samlConfiguration;

        private OpenIDConnectProviderConfiguration openIDConnectConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderConfiguration model) {
            samlConfiguration(model.samlConfiguration);
            openIDConnectConfiguration(model.openIDConnectConfiguration);
        }

        public final SamlProviderConfiguration.Builder getSamlConfiguration() {
            return samlConfiguration != null ? samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlProviderConfiguration.BuilderImpl samlConfiguration) {
            Object oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
            handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
        }

        @Override
        public final Builder samlConfiguration(SamlProviderConfiguration samlConfiguration) {
            Object oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration;
            handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
            return this;
        }

        public final OpenIDConnectProviderConfiguration.Builder getOpenIDConnectConfiguration() {
            return openIDConnectConfiguration != null ? openIDConnectConfiguration.toBuilder() : null;
        }

        public final void setOpenIDConnectConfiguration(OpenIDConnectProviderConfiguration.BuilderImpl openIDConnectConfiguration) {
            Object oldValue = this.openIDConnectConfiguration;
            this.openIDConnectConfiguration = openIDConnectConfiguration != null ? openIDConnectConfiguration.build() : null;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIDConnectConfiguration);
        }

        @Override
        public final Builder openIDConnectConfiguration(OpenIDConnectProviderConfiguration openIDConnectConfiguration) {
            Object oldValue = this.openIDConnectConfiguration;
            this.openIDConnectConfiguration = openIDConnectConfiguration;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIDConnectConfiguration);
            return this;
        }

        @Override
        public IdentityProviderConfiguration build() {
            return new IdentityProviderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IdentityProviderConfiguration#type()
     */
    public enum Type {
        SAML_CONFIGURATION,

        OPEN_ID_CONNECT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
