/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information required to setup hallucination reduction. For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/hallucination-reduction.html"> hallucination
 * reduction</a>.
 * </p>
 * <note>
 * <p>
 * The hallucination reduction feature won't work if chat orchestration controls are enabled for your application.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HallucinationReductionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HallucinationReductionConfiguration.Builder, HallucinationReductionConfiguration> {
    private static final SdkField<String> HALLUCINATION_REDUCTION_CONTROL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("hallucinationReductionControl")
            .getter(getter(HallucinationReductionConfiguration::hallucinationReductionControlAsString))
            .setter(setter(Builder::hallucinationReductionControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hallucinationReductionControl")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HALLUCINATION_REDUCTION_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hallucinationReductionControl;

    private HallucinationReductionConfiguration(BuilderImpl builder) {
        this.hallucinationReductionControl = builder.hallucinationReductionControl;
    }

    /**
     * <p>
     * Controls whether hallucination reduction has been enabled or disabled for your application. The default status is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hallucinationReductionControl} will return {@link HallucinationReductionControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hallucinationReductionControlAsString}.
     * </p>
     * 
     * @return Controls whether hallucination reduction has been enabled or disabled for your application. The default
     *         status is <code>DISABLED</code>.
     * @see HallucinationReductionControl
     */
    public final HallucinationReductionControl hallucinationReductionControl() {
        return HallucinationReductionControl.fromValue(hallucinationReductionControl);
    }

    /**
     * <p>
     * Controls whether hallucination reduction has been enabled or disabled for your application. The default status is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hallucinationReductionControl} will return {@link HallucinationReductionControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hallucinationReductionControlAsString}.
     * </p>
     * 
     * @return Controls whether hallucination reduction has been enabled or disabled for your application. The default
     *         status is <code>DISABLED</code>.
     * @see HallucinationReductionControl
     */
    public final String hallucinationReductionControlAsString() {
        return hallucinationReductionControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hallucinationReductionControlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HallucinationReductionConfiguration)) {
            return false;
        }
        HallucinationReductionConfiguration other = (HallucinationReductionConfiguration) obj;
        return Objects.equals(hallucinationReductionControlAsString(), other.hallucinationReductionControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HallucinationReductionConfiguration")
                .add("HallucinationReductionControl", hallucinationReductionControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hallucinationReductionControl":
            return Optional.ofNullable(clazz.cast(hallucinationReductionControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hallucinationReductionControl", HALLUCINATION_REDUCTION_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HallucinationReductionConfiguration, T> g) {
        return obj -> g.apply((HallucinationReductionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HallucinationReductionConfiguration> {
        /**
         * <p>
         * Controls whether hallucination reduction has been enabled or disabled for your application. The default
         * status is <code>DISABLED</code>.
         * </p>
         * 
         * @param hallucinationReductionControl
         *        Controls whether hallucination reduction has been enabled or disabled for your application. The
         *        default status is <code>DISABLED</code>.
         * @see HallucinationReductionControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HallucinationReductionControl
         */
        Builder hallucinationReductionControl(String hallucinationReductionControl);

        /**
         * <p>
         * Controls whether hallucination reduction has been enabled or disabled for your application. The default
         * status is <code>DISABLED</code>.
         * </p>
         * 
         * @param hallucinationReductionControl
         *        Controls whether hallucination reduction has been enabled or disabled for your application. The
         *        default status is <code>DISABLED</code>.
         * @see HallucinationReductionControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HallucinationReductionControl
         */
        Builder hallucinationReductionControl(HallucinationReductionControl hallucinationReductionControl);
    }

    static final class BuilderImpl implements Builder {
        private String hallucinationReductionControl;

        private BuilderImpl() {
        }

        private BuilderImpl(HallucinationReductionConfiguration model) {
            hallucinationReductionControl(model.hallucinationReductionControl);
        }

        public final String getHallucinationReductionControl() {
            return hallucinationReductionControl;
        }

        public final void setHallucinationReductionControl(String hallucinationReductionControl) {
            this.hallucinationReductionControl = hallucinationReductionControl;
        }

        @Override
        public final Builder hallucinationReductionControl(String hallucinationReductionControl) {
            this.hallucinationReductionControl = hallucinationReductionControl;
            return this;
        }

        @Override
        public final Builder hallucinationReductionControl(HallucinationReductionControl hallucinationReductionControl) {
            this.hallucinationReductionControl(hallucinationReductionControl == null ? null : hallucinationReductionControl
                    .toString());
            return this;
        }

        @Override
        public HallucinationReductionConfiguration build() {
            return new HallucinationReductionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
