/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetUserResponse.Builder, GetUserResponse> {
    private static final SdkField<List<UserAlias>> USER_ALIASES_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliases")
            .getter(getter(GetUserResponse::userAliases))
            .setter(setter(Builder::userAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ALIASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserAlias> userAliases;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.userAliases = builder.userAliases;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliases() {
        return userAliases != null && !(userAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user aliases attached to a user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliases} method.
     * </p>
     * 
     * @return A list of user aliases attached to a user.
     */
    public final List<UserAlias> userAliases() {
        return userAliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliases() ? userAliases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse) obj;
        return hasUserAliases() == other.hasUserAliases() && Objects.equals(userAliases(), other.userAliases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserResponse").add("UserAliases", hasUserAliases() ? userAliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAliases":
            return Optional.ofNullable(clazz.cast(userAliases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userAliases", USER_ALIASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserResponse, T> g) {
        return obj -> g.apply((GetUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserResponse> {
        /**
         * <p>
         * A list of user aliases attached to a user.
         * </p>
         * 
         * @param userAliases
         *        A list of user aliases attached to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(Collection<UserAlias> userAliases);

        /**
         * <p>
         * A list of user aliases attached to a user.
         * </p>
         * 
         * @param userAliases
         *        A list of user aliases attached to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(UserAlias... userAliases);

        /**
         * <p>
         * A list of user aliases attached to a user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliases(List<UserAlias>)}.
         * 
         * @param userAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliases(java.util.Collection<UserAlias>)
         */
        Builder userAliases(Consumer<UserAlias.Builder>... userAliases);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<UserAlias> userAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            userAliases(model.userAliases);
        }

        public final List<UserAlias.Builder> getUserAliases() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliases(Collection<UserAlias.BuilderImpl> userAliases) {
            this.userAliases = UserAliasesCopier.copyFromBuilder(userAliases);
        }

        @Override
        public final Builder userAliases(Collection<UserAlias> userAliases) {
            this.userAliases = UserAliasesCopier.copy(userAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(UserAlias... userAliases) {
            userAliases(Arrays.asList(userAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(Consumer<UserAlias.Builder>... userAliases) {
            userAliases(Stream.of(userAliases).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
