/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetGroupResponse.Builder, GetGroupResponse> {
    private static final SdkField<GroupStatusDetail> STATUS_FIELD = SdkField
            .<GroupStatusDetail> builder(MarshallingType.SDK_POJO).memberName("status").getter(getter(GetGroupResponse::status))
            .setter(setter(Builder::status)).constructor(GroupStatusDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<GroupStatusDetail>> STATUS_HISTORY_FIELD = SdkField
            .<List<GroupStatusDetail>> builder(MarshallingType.LIST)
            .memberName("statusHistory")
            .getter(getter(GetGroupResponse::statusHistory))
            .setter(setter(Builder::statusHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupStatusDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupStatusDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GroupStatusDetail status;

    private final List<GroupStatusDetail> statusHistory;

    private GetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusHistory = builder.statusHistory;
    }

    /**
     * <p>
     * The current status of the group.
     * </p>
     * 
     * @return The current status of the group.
     */
    public final GroupStatusDetail status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusHistory property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusHistory() {
        return statusHistory != null && !(statusHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status history of the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusHistory} method.
     * </p>
     * 
     * @return The status history of the group.
     */
    public final List<GroupStatusDetail> statusHistory() {
        return statusHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusHistory() ? statusHistory() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResponse)) {
            return false;
        }
        GetGroupResponse other = (GetGroupResponse) obj;
        return Objects.equals(status(), other.status()) && hasStatusHistory() == other.hasStatusHistory()
                && Objects.equals(statusHistory(), other.statusHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupResponse").add("Status", status())
                .add("StatusHistory", hasStatusHistory() ? statusHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "statusHistory":
            return Optional.ofNullable(clazz.cast(statusHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("statusHistory", STATUS_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGroupResponse, T> g) {
        return obj -> g.apply((GetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupResponse> {
        /**
         * <p>
         * The current status of the group.
         * </p>
         * 
         * @param status
         *        The current status of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(GroupStatusDetail status);

        /**
         * <p>
         * The current status of the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupStatusDetail.Builder} avoiding the
         * need to create one manually via {@link GroupStatusDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupStatusDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #status(GroupStatusDetail)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link GroupStatusDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(GroupStatusDetail)
         */
        default Builder status(Consumer<GroupStatusDetail.Builder> status) {
            return status(GroupStatusDetail.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The status history of the group.
         * </p>
         * 
         * @param statusHistory
         *        The status history of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusHistory(Collection<GroupStatusDetail> statusHistory);

        /**
         * <p>
         * The status history of the group.
         * </p>
         * 
         * @param statusHistory
         *        The status history of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusHistory(GroupStatusDetail... statusHistory);

        /**
         * <p>
         * The status history of the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.GroupStatusDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.GroupStatusDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.GroupStatusDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #statusHistory(List<GroupStatusDetail>)}.
         * 
         * @param statusHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.GroupStatusDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusHistory(java.util.Collection<GroupStatusDetail>)
         */
        Builder statusHistory(Consumer<GroupStatusDetail.Builder>... statusHistory);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private GroupStatusDetail status;

        private List<GroupStatusDetail> statusHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupResponse model) {
            super(model);
            status(model.status);
            statusHistory(model.statusHistory);
        }

        public final GroupStatusDetail.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(GroupStatusDetail.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(GroupStatusDetail status) {
            this.status = status;
            return this;
        }

        public final List<GroupStatusDetail.Builder> getStatusHistory() {
            List<GroupStatusDetail.Builder> result = GroupStatusDetailsCopier.copyToBuilder(this.statusHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusHistory(Collection<GroupStatusDetail.BuilderImpl> statusHistory) {
            this.statusHistory = GroupStatusDetailsCopier.copyFromBuilder(statusHistory);
        }

        @Override
        public final Builder statusHistory(Collection<GroupStatusDetail> statusHistory) {
            this.statusHistory = GroupStatusDetailsCopier.copy(statusHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusHistory(GroupStatusDetail... statusHistory) {
            statusHistory(Arrays.asList(statusHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusHistory(Consumer<GroupStatusDetail.Builder>... statusHistory) {
            statusHistory(Stream.of(statusHistory).map(c -> GroupStatusDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetGroupResponse build() {
            return new GetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
