/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentContentRequest extends QBusinessRequest implements
        ToCopyableBuilder<GetDocumentContentRequest.Builder, GetDocumentContentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetDocumentContentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(GetDocumentContentRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(GetDocumentContentRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentId").getter(getter(GetDocumentContentRequest::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("documentId").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputFormat").getter(getter(GetDocumentContentRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("outputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, DOCUMENT_ID_FIELD, OUTPUT_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String indexId;

    private final String dataSourceId;

    private final String documentId;

    private final String outputFormat;

    private GetDocumentContentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.documentId = builder.documentId;
        this.outputFormat = builder.outputFormat;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application containing the document. This ensures the request is
     * scoped to the correct application environment and its associated security policies.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application containing the document. This ensures the
     *         request is scoped to the correct application environment and its associated security policies.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the index where documents are indexed.
     * </p>
     * 
     * @return The identifier of the index where documents are indexed.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source from which the document was ingested. This field is not present if the document
     * is ingested by directly calling the BatchPutDocument API. If the document is from a file-upload data source, the
     * datasource will be "uploaded-docs-file-stat-datasourceid".
     * </p>
     * 
     * @return The identifier of the data source from which the document was ingested. This field is not present if the
     *         document is ingested by directly calling the BatchPutDocument API. If the document is from a file-upload
     *         data source, the datasource will be "uploaded-docs-file-stat-datasourceid".
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The unique identifier of the document that is indexed via BatchPutDocument API or file-upload or connector sync.
     * It is also found in chat or chatSync response.
     * </p>
     * 
     * @return The unique identifier of the document that is indexed via BatchPutDocument API or file-upload or
     *         connector sync. It is also found in chat or chatSync response.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * Document outputFormat. Defaults to RAW if not selected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return Document outputFormat. Defaults to RAW if not selected.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * Document outputFormat. Defaults to RAW if not selected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return Document outputFormat. Defaults to RAW if not selected.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentContentRequest)) {
            return false;
        }
        GetDocumentContentRequest other = (GetDocumentContentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(documentId(), other.documentId())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentContentRequest").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("DataSourceId", dataSourceId()).add("DocumentId", documentId()).add("OutputFormat", outputFormatAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "documentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "outputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("documentId", DOCUMENT_ID_FIELD);
        map.put("outputFormat", OUTPUT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentContentRequest, T> g) {
        return obj -> g.apply((GetDocumentContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentContentRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application containing the document. This ensures the request
         * is scoped to the correct application environment and its associated security policies.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Amazon Q Business application containing the document. This ensures the
         *        request is scoped to the correct application environment and its associated security policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the index where documents are indexed.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index where documents are indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source from which the document was ingested. This field is not present if the
         * document is ingested by directly calling the BatchPutDocument API. If the document is from a file-upload data
         * source, the datasource will be "uploaded-docs-file-stat-datasourceid".
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source from which the document was ingested. This field is not present if
         *        the document is ingested by directly calling the BatchPutDocument API. If the document is from a
         *        file-upload data source, the datasource will be "uploaded-docs-file-stat-datasourceid".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The unique identifier of the document that is indexed via BatchPutDocument API or file-upload or connector
         * sync. It is also found in chat or chatSync response.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the document that is indexed via BatchPutDocument API or file-upload or
         *        connector sync. It is also found in chat or chatSync response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * Document outputFormat. Defaults to RAW if not selected.
         * </p>
         * 
         * @param outputFormat
         *        Document outputFormat. Defaults to RAW if not selected.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * Document outputFormat. Defaults to RAW if not selected.
         * </p>
         * 
         * @param outputFormat
         *        Document outputFormat. Defaults to RAW if not selected.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String dataSourceId;

        private String documentId;

        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentContentRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            documentId(model.documentId);
            outputFormat(model.outputFormat);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentContentRequest build() {
            return new GetDocumentContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
