/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChatResponseConfigurationResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetChatResponseConfigurationResponse.Builder, GetChatResponseConfigurationResponse> {
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationId")
            .getter(getter(GetChatResponseConfigurationResponse::chatResponseConfigurationId))
            .setter(setter(Builder::chatResponseConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationId")
                    .build()).build();

    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationArn")
            .getter(getter(GetChatResponseConfigurationResponse::chatResponseConfigurationArn))
            .setter(setter(Builder::chatResponseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetChatResponseConfigurationResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetChatResponseConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ChatResponseConfigurationDetail> IN_USE_CONFIGURATION_FIELD = SdkField
            .<ChatResponseConfigurationDetail> builder(MarshallingType.SDK_POJO).memberName("inUseConfiguration")
            .getter(getter(GetChatResponseConfigurationResponse::inUseConfiguration)).setter(setter(Builder::inUseConfiguration))
            .constructor(ChatResponseConfigurationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseConfiguration").build())
            .build();

    private static final SdkField<ChatResponseConfigurationDetail> LAST_UPDATE_CONFIGURATION_FIELD = SdkField
            .<ChatResponseConfigurationDetail> builder(MarshallingType.SDK_POJO).memberName("lastUpdateConfiguration")
            .getter(getter(GetChatResponseConfigurationResponse::lastUpdateConfiguration))
            .setter(setter(Builder::lastUpdateConfiguration)).constructor(ChatResponseConfigurationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHAT_RESPONSE_CONFIGURATION_ID_FIELD, CHAT_RESPONSE_CONFIGURATION_ARN_FIELD, DISPLAY_NAME_FIELD, CREATED_AT_FIELD,
            IN_USE_CONFIGURATION_FIELD, LAST_UPDATE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String chatResponseConfigurationId;

    private final String chatResponseConfigurationArn;

    private final String displayName;

    private final Instant createdAt;

    private final ChatResponseConfigurationDetail inUseConfiguration;

    private final ChatResponseConfigurationDetail lastUpdateConfiguration;

    private GetChatResponseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
        this.chatResponseConfigurationArn = builder.chatResponseConfigurationArn;
        this.displayName = builder.displayName;
        this.createdAt = builder.createdAt;
        this.inUseConfiguration = builder.inUseConfiguration;
        this.lastUpdateConfiguration = builder.lastUpdateConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the retrieved chat response configuration.
     * </p>
     * 
     * @return The unique identifier of the retrieved chat response configuration.
     */
    public final String chatResponseConfigurationId() {
        return chatResponseConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the retrieved chat response configuration, which uniquely identifies the
     * resource across all Amazon Web Services services.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the retrieved chat response configuration, which uniquely identifies
     *         the resource across all Amazon Web Services services.
     */
    public final String chatResponseConfigurationArn() {
        return chatResponseConfigurationArn;
    }

    /**
     * <p>
     * The human-readable name of the retrieved chat response configuration, making it easier to identify among multiple
     * configurations.
     * </p>
     * 
     * @return The human-readable name of the retrieved chat response configuration, making it easier to identify among
     *         multiple configurations.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The timestamp indicating when the chat response configuration was initially created.
     * </p>
     * 
     * @return The timestamp indicating when the chat response configuration was initially created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The currently active configuration settings that are being used to generate responses in the Amazon Q Business
     * application.
     * </p>
     * 
     * @return The currently active configuration settings that are being used to generate responses in the Amazon Q
     *         Business application.
     */
    public final ChatResponseConfigurationDetail inUseConfiguration() {
        return inUseConfiguration;
    }

    /**
     * <p>
     * Information about the most recent update to the configuration, including timestamp and modification details.
     * </p>
     * 
     * @return Information about the most recent update to the configuration, including timestamp and modification
     *         details.
     */
    public final ChatResponseConfigurationDetail lastUpdateConfiguration() {
        return lastUpdateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(inUseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChatResponseConfigurationResponse)) {
            return false;
        }
        GetChatResponseConfigurationResponse other = (GetChatResponseConfigurationResponse) obj;
        return Objects.equals(chatResponseConfigurationId(), other.chatResponseConfigurationId())
                && Objects.equals(chatResponseConfigurationArn(), other.chatResponseConfigurationArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(inUseConfiguration(), other.inUseConfiguration())
                && Objects.equals(lastUpdateConfiguration(), other.lastUpdateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChatResponseConfigurationResponse")
                .add("ChatResponseConfigurationId", chatResponseConfigurationId())
                .add("ChatResponseConfigurationArn", chatResponseConfigurationArn()).add("DisplayName", displayName())
                .add("CreatedAt", createdAt()).add("InUseConfiguration", inUseConfiguration())
                .add("LastUpdateConfiguration", lastUpdateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatResponseConfigurationId":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationId()));
        case "chatResponseConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "inUseConfiguration":
            return Optional.ofNullable(clazz.cast(inUseConfiguration()));
        case "lastUpdateConfiguration":
            return Optional.ofNullable(clazz.cast(lastUpdateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        map.put("chatResponseConfigurationArn", CHAT_RESPONSE_CONFIGURATION_ARN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("inUseConfiguration", IN_USE_CONFIGURATION_FIELD);
        map.put("lastUpdateConfiguration", LAST_UPDATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChatResponseConfigurationResponse, T> g) {
        return obj -> g.apply((GetChatResponseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetChatResponseConfigurationResponse> {
        /**
         * <p>
         * The unique identifier of the retrieved chat response configuration.
         * </p>
         * 
         * @param chatResponseConfigurationId
         *        The unique identifier of the retrieved chat response configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationId(String chatResponseConfigurationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the retrieved chat response configuration, which uniquely identifies the
         * resource across all Amazon Web Services services.
         * </p>
         * 
         * @param chatResponseConfigurationArn
         *        The Amazon Resource Name (ARN) of the retrieved chat response configuration, which uniquely identifies
         *        the resource across all Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationArn(String chatResponseConfigurationArn);

        /**
         * <p>
         * The human-readable name of the retrieved chat response configuration, making it easier to identify among
         * multiple configurations.
         * </p>
         * 
         * @param displayName
         *        The human-readable name of the retrieved chat response configuration, making it easier to identify
         *        among multiple configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The timestamp indicating when the chat response configuration was initially created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp indicating when the chat response configuration was initially created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The currently active configuration settings that are being used to generate responses in the Amazon Q
         * Business application.
         * </p>
         * 
         * @param inUseConfiguration
         *        The currently active configuration settings that are being used to generate responses in the Amazon Q
         *        Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseConfiguration(ChatResponseConfigurationDetail inUseConfiguration);

        /**
         * <p>
         * The currently active configuration settings that are being used to generate responses in the Amazon Q
         * Business application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatResponseConfigurationDetail.Builder}
         * avoiding the need to create one manually via {@link ChatResponseConfigurationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatResponseConfigurationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #inUseConfiguration(ChatResponseConfigurationDetail)}.
         * 
         * @param inUseConfiguration
         *        a consumer that will call methods on {@link ChatResponseConfigurationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inUseConfiguration(ChatResponseConfigurationDetail)
         */
        default Builder inUseConfiguration(Consumer<ChatResponseConfigurationDetail.Builder> inUseConfiguration) {
            return inUseConfiguration(ChatResponseConfigurationDetail.builder().applyMutation(inUseConfiguration).build());
        }

        /**
         * <p>
         * Information about the most recent update to the configuration, including timestamp and modification details.
         * </p>
         * 
         * @param lastUpdateConfiguration
         *        Information about the most recent update to the configuration, including timestamp and modification
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateConfiguration(ChatResponseConfigurationDetail lastUpdateConfiguration);

        /**
         * <p>
         * Information about the most recent update to the configuration, including timestamp and modification details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatResponseConfigurationDetail.Builder}
         * avoiding the need to create one manually via {@link ChatResponseConfigurationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatResponseConfigurationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #lastUpdateConfiguration(ChatResponseConfigurationDetail)}.
         * 
         * @param lastUpdateConfiguration
         *        a consumer that will call methods on {@link ChatResponseConfigurationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdateConfiguration(ChatResponseConfigurationDetail)
         */
        default Builder lastUpdateConfiguration(Consumer<ChatResponseConfigurationDetail.Builder> lastUpdateConfiguration) {
            return lastUpdateConfiguration(ChatResponseConfigurationDetail.builder().applyMutation(lastUpdateConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String chatResponseConfigurationId;

        private String chatResponseConfigurationArn;

        private String displayName;

        private Instant createdAt;

        private ChatResponseConfigurationDetail inUseConfiguration;

        private ChatResponseConfigurationDetail lastUpdateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChatResponseConfigurationResponse model) {
            super(model);
            chatResponseConfigurationId(model.chatResponseConfigurationId);
            chatResponseConfigurationArn(model.chatResponseConfigurationArn);
            displayName(model.displayName);
            createdAt(model.createdAt);
            inUseConfiguration(model.inUseConfiguration);
            lastUpdateConfiguration(model.lastUpdateConfiguration);
        }

        public final String getChatResponseConfigurationId() {
            return chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        public final String getChatResponseConfigurationArn() {
            return chatResponseConfigurationArn;
        }

        public final void setChatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
        }

        @Override
        public final Builder chatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ChatResponseConfigurationDetail.Builder getInUseConfiguration() {
            return inUseConfiguration != null ? inUseConfiguration.toBuilder() : null;
        }

        public final void setInUseConfiguration(ChatResponseConfigurationDetail.BuilderImpl inUseConfiguration) {
            this.inUseConfiguration = inUseConfiguration != null ? inUseConfiguration.build() : null;
        }

        @Override
        public final Builder inUseConfiguration(ChatResponseConfigurationDetail inUseConfiguration) {
            this.inUseConfiguration = inUseConfiguration;
            return this;
        }

        public final ChatResponseConfigurationDetail.Builder getLastUpdateConfiguration() {
            return lastUpdateConfiguration != null ? lastUpdateConfiguration.toBuilder() : null;
        }

        public final void setLastUpdateConfiguration(ChatResponseConfigurationDetail.BuilderImpl lastUpdateConfiguration) {
            this.lastUpdateConfiguration = lastUpdateConfiguration != null ? lastUpdateConfiguration.build() : null;
        }

        @Override
        public final Builder lastUpdateConfiguration(ChatResponseConfigurationDetail lastUpdateConfiguration) {
            this.lastUpdateConfiguration = lastUpdateConfiguration;
            return this;
        }

        @Override
        public GetChatResponseConfigurationResponse build() {
            return new GetChatResponseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
