/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetApplicationResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetApplicationResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(GetApplicationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityType").getter(getter(GetApplicationResponse::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityType").build()).build();

    private static final SdkField<String> IAM_IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamIdentityProviderArn").getter(getter(GetApplicationResponse::iamIdentityProviderArn))
            .setter(setter(Builder::iamIdentityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityProviderArn").build())
            .build();

    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("identityCenterApplicationArn")
            .getter(getter(GetApplicationResponse::identityCenterApplicationArn))
            .setter(setter(Builder::identityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterApplicationArn")
                    .build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetApplicationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(GetApplicationResponse::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetApplicationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetApplicationResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetApplicationResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<AppliedAttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField
            .<AppliedAttachmentsConfiguration> builder(MarshallingType.SDK_POJO).memberName("attachmentsConfiguration")
            .getter(getter(GetApplicationResponse::attachmentsConfiguration)).setter(setter(Builder::attachmentsConfiguration))
            .constructor(AppliedAttachmentsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build())
            .build();

    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField
            .<QAppsConfiguration> builder(MarshallingType.SDK_POJO).memberName("qAppsConfiguration")
            .getter(getter(GetApplicationResponse::qAppsConfiguration)).setter(setter(Builder::qAppsConfiguration))
            .constructor(QAppsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build())
            .build();

    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField
            .<PersonalizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("personalizationConfiguration")
            .getter(getter(GetApplicationResponse::personalizationConfiguration))
            .setter(setter(Builder::personalizationConfiguration))
            .constructor(PersonalizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration")
                    .build()).build();

    private static final SdkField<AutoSubscriptionConfiguration> AUTO_SUBSCRIPTION_CONFIGURATION_FIELD = SdkField
            .<AutoSubscriptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("autoSubscriptionConfiguration")
            .getter(getter(GetApplicationResponse::autoSubscriptionConfiguration))
            .setter(setter(Builder::autoSubscriptionConfiguration))
            .constructor(AutoSubscriptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubscriptionConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> CLIENT_IDS_FOR_OIDC_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clientIdsForOIDC")
            .getter(getter(GetApplicationResponse::clientIdsForOIDC))
            .setter(setter(Builder::clientIdsForOIDC))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIdsForOIDC").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QuickSightConfiguration> QUICK_SIGHT_CONFIGURATION_FIELD = SdkField
            .<QuickSightConfiguration> builder(MarshallingType.SDK_POJO).memberName("quickSightConfiguration")
            .getter(getter(GetApplicationResponse::quickSightConfiguration)).setter(setter(Builder::quickSightConfiguration))
            .constructor(QuickSightConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickSightConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            APPLICATION_ID_FIELD, APPLICATION_ARN_FIELD, IDENTITY_TYPE_FIELD, IAM_IDENTITY_PROVIDER_ARN_FIELD,
            IDENTITY_CENTER_APPLICATION_ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ERROR_FIELD, ATTACHMENTS_CONFIGURATION_FIELD,
            Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD, AUTO_SUBSCRIPTION_CONFIGURATION_FIELD,
            CLIENT_IDS_FOR_OIDC_FIELD, QUICK_SIGHT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String displayName;

    private final String applicationId;

    private final String applicationArn;

    private final String identityType;

    private final String iamIdentityProviderArn;

    private final String identityCenterApplicationArn;

    private final String roleArn;

    private final String status;

    private final String description;

    private final EncryptionConfiguration encryptionConfiguration;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final ErrorDetail error;

    private final AppliedAttachmentsConfiguration attachmentsConfiguration;

    private final QAppsConfiguration qAppsConfiguration;

    private final PersonalizationConfiguration personalizationConfiguration;

    private final AutoSubscriptionConfiguration autoSubscriptionConfiguration;

    private final List<String> clientIdsForOIDC;

    private final QuickSightConfiguration quickSightConfiguration;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.identityType = builder.identityType;
        this.iamIdentityProviderArn = builder.iamIdentityProviderArn;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.error = builder.error;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
        this.autoSubscriptionConfiguration = builder.autoSubscriptionConfiguration;
        this.clientIdsForOIDC = builder.clientIdsForOIDC;
        this.quickSightConfiguration = builder.quickSightConfiguration;
    }

    /**
     * <p>
     * The name of the Amazon Q Business application.
     * </p>
     * 
     * @return The name of the Amazon Q Business application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q Business application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     */
    public final String iamIdentityProviderArn() {
        return iamIdentityProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business
     * application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business
     *         application.
     */
    public final String identityCenterApplicationArn() {
        return identityCenterApplicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business application.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description for the Amazon Q Business application.
     * </p>
     * 
     * @return A description for the Amazon Q Business application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q Business doesn't
     * support asymmetric keys.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q Business
     *         doesn't support asymmetric keys.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the synchronization to fail.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the synchronization to fail.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * Settings for whether end users can upload files directly during chat.
     * </p>
     * 
     * @return Settings for whether end users can upload files directly during chat.
     */
    public final AppliedAttachmentsConfiguration attachmentsConfiguration() {
        return attachmentsConfiguration;
    }

    /**
     * <p>
     * Settings for whether end users can create and use Amazon Q Apps in the web experience.
     * </p>
     * 
     * @return Settings for whether end users can create and use Amazon Q Apps in the web experience.
     */
    public final QAppsConfiguration qAppsConfiguration() {
        return qAppsConfiguration;
    }

    /**
     * <p>
     * Configuration information about chat response personalization. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing
     * chat responses</a>.
     * </p>
     * 
     * @return Configuration information about chat response personalization. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
     *         >Personalizing chat responses</a>.
     */
    public final PersonalizationConfiguration personalizationConfiguration() {
        return personalizationConfiguration;
    }

    /**
     * <p>
     * Settings for auto-subscription behavior for this application. This is only applicable to SAML and OIDC
     * applications.
     * </p>
     * 
     * @return Settings for auto-subscription behavior for this application. This is only applicable to SAML and OIDC
     *         applications.
     */
    public final AutoSubscriptionConfiguration autoSubscriptionConfiguration() {
        return autoSubscriptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientIdsForOIDC property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientIdsForOIDC() {
        return clientIdsForOIDC != null && !(clientIdsForOIDC instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OIDC client ID for a Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientIdsForOIDC} method.
     * </p>
     * 
     * @return The OIDC client ID for a Amazon Q Business application.
     */
    public final List<String> clientIdsForOIDC() {
        return clientIdsForOIDC;
    }

    /**
     * <p>
     * The Amazon QuickSight authentication configuration for the Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon QuickSight authentication configuration for the Amazon Q Business application.
     */
    public final QuickSightConfiguration quickSightConfiguration() {
        return quickSightConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(personalizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoSubscriptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientIdsForOIDC() ? clientIdsForOIDC() : null);
        hashCode = 31 * hashCode + Objects.hashCode(quickSightConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(iamIdentityProviderArn(), other.iamIdentityProviderArn())
                && Objects.equals(identityCenterApplicationArn(), other.identityCenterApplicationArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(error(), other.error())
                && Objects.equals(attachmentsConfiguration(), other.attachmentsConfiguration())
                && Objects.equals(qAppsConfiguration(), other.qAppsConfiguration())
                && Objects.equals(personalizationConfiguration(), other.personalizationConfiguration())
                && Objects.equals(autoSubscriptionConfiguration(), other.autoSubscriptionConfiguration())
                && hasClientIdsForOIDC() == other.hasClientIdsForOIDC()
                && Objects.equals(clientIdsForOIDC(), other.clientIdsForOIDC())
                && Objects.equals(quickSightConfiguration(), other.quickSightConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("DisplayName", displayName()).add("ApplicationId", applicationId())
                .add("ApplicationArn", applicationArn()).add("IdentityType", identityTypeAsString())
                .add("IamIdentityProviderArn", iamIdentityProviderArn())
                .add("IdentityCenterApplicationArn", identityCenterApplicationArn()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).add("Description", description())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Error", error()).add("AttachmentsConfiguration", attachmentsConfiguration())
                .add("QAppsConfiguration", qAppsConfiguration())
                .add("PersonalizationConfiguration", personalizationConfiguration())
                .add("AutoSubscriptionConfiguration", autoSubscriptionConfiguration())
                .add("ClientIdsForOIDC", hasClientIdsForOIDC() ? clientIdsForOIDC() : null)
                .add("QuickSightConfiguration", quickSightConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "identityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "iamIdentityProviderArn":
            return Optional.ofNullable(clazz.cast(iamIdentityProviderArn()));
        case "identityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(identityCenterApplicationArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "attachmentsConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentsConfiguration()));
        case "qAppsConfiguration":
            return Optional.ofNullable(clazz.cast(qAppsConfiguration()));
        case "personalizationConfiguration":
            return Optional.ofNullable(clazz.cast(personalizationConfiguration()));
        case "autoSubscriptionConfiguration":
            return Optional.ofNullable(clazz.cast(autoSubscriptionConfiguration()));
        case "clientIdsForOIDC":
            return Optional.ofNullable(clazz.cast(clientIdsForOIDC()));
        case "quickSightConfiguration":
            return Optional.ofNullable(clazz.cast(quickSightConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("identityType", IDENTITY_TYPE_FIELD);
        map.put("iamIdentityProviderArn", IAM_IDENTITY_PROVIDER_ARN_FIELD);
        map.put("identityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("attachmentsConfiguration", ATTACHMENTS_CONFIGURATION_FIELD);
        map.put("qAppsConfiguration", Q_APPS_CONFIGURATION_FIELD);
        map.put("personalizationConfiguration", PERSONALIZATION_CONFIGURATION_FIELD);
        map.put("autoSubscriptionConfiguration", AUTO_SUBSCRIPTION_CONFIGURATION_FIELD);
        map.put("clientIdsForOIDC", CLIENT_IDS_FOR_OIDC_FIELD);
        map.put("quickSightConfiguration", QUICK_SIGHT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The name of the Amazon Q Business application.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier of the Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q Business application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
         * </p>
         * 
         * @param iamIdentityProviderArn
         *        The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityProviderArn(String iamIdentityProviderArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business
         * application.
         * </p>
         * 
         * @param identityCenterApplicationArn
         *        The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q
         *        Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterApplicationArn(String identityCenterApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the Amazon Q Business application.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Q Business application.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * A description for the Amazon Q Business application.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q Business
         * doesn't support asymmetric keys.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q Business
         *        doesn't support asymmetric keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q Business
         * doesn't support asymmetric keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
         * description of the error that caused the synchronization to fail.
         * </p>
         * 
         * @param error
         *        If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the synchronization to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
         * description of the error that caused the synchronization to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * Settings for whether end users can upload files directly during chat.
         * </p>
         * 
         * @param attachmentsConfiguration
         *        Settings for whether end users can upload files directly during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsConfiguration(AppliedAttachmentsConfiguration attachmentsConfiguration);

        /**
         * <p>
         * Settings for whether end users can upload files directly during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppliedAttachmentsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AppliedAttachmentsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppliedAttachmentsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #attachmentsConfiguration(AppliedAttachmentsConfiguration)}.
         * 
         * @param attachmentsConfiguration
         *        a consumer that will call methods on {@link AppliedAttachmentsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsConfiguration(AppliedAttachmentsConfiguration)
         */
        default Builder attachmentsConfiguration(Consumer<AppliedAttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return attachmentsConfiguration(AppliedAttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration)
                    .build());
        }

        /**
         * <p>
         * Settings for whether end users can create and use Amazon Q Apps in the web experience.
         * </p>
         * 
         * @param qAppsConfiguration
         *        Settings for whether end users can create and use Amazon Q Apps in the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration);

        /**
         * <p>
         * Settings for whether end users can create and use Amazon Q Apps in the web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link QAppsConfiguration.Builder} avoiding the
         * need to create one manually via {@link QAppsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QAppsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #qAppsConfiguration(QAppsConfiguration)}.
         * 
         * @param qAppsConfiguration
         *        a consumer that will call methods on {@link QAppsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qAppsConfiguration(QAppsConfiguration)
         */
        default Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return qAppsConfiguration(QAppsConfiguration.builder().applyMutation(qAppsConfiguration).build());
        }

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>.
         * </p>
         * 
         * @param personalizationConfiguration
         *        Configuration information about chat response personalization. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         *        >Personalizing chat responses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration);

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PersonalizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link PersonalizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PersonalizationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #personalizationConfiguration(PersonalizationConfiguration)}.
         * 
         * @param personalizationConfiguration
         *        a consumer that will call methods on {@link PersonalizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalizationConfiguration(PersonalizationConfiguration)
         */
        default Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return personalizationConfiguration(PersonalizationConfiguration.builder()
                    .applyMutation(personalizationConfiguration).build());
        }

        /**
         * <p>
         * Settings for auto-subscription behavior for this application. This is only applicable to SAML and OIDC
         * applications.
         * </p>
         * 
         * @param autoSubscriptionConfiguration
         *        Settings for auto-subscription behavior for this application. This is only applicable to SAML and OIDC
         *        applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSubscriptionConfiguration(AutoSubscriptionConfiguration autoSubscriptionConfiguration);

        /**
         * <p>
         * Settings for auto-subscription behavior for this application. This is only applicable to SAML and OIDC
         * applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoSubscriptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoSubscriptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoSubscriptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #autoSubscriptionConfiguration(AutoSubscriptionConfiguration)}.
         * 
         * @param autoSubscriptionConfiguration
         *        a consumer that will call methods on {@link AutoSubscriptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoSubscriptionConfiguration(AutoSubscriptionConfiguration)
         */
        default Builder autoSubscriptionConfiguration(
                Consumer<AutoSubscriptionConfiguration.Builder> autoSubscriptionConfiguration) {
            return autoSubscriptionConfiguration(AutoSubscriptionConfiguration.builder()
                    .applyMutation(autoSubscriptionConfiguration).build());
        }

        /**
         * <p>
         * The OIDC client ID for a Amazon Q Business application.
         * </p>
         * 
         * @param clientIdsForOIDC
         *        The OIDC client ID for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIdsForOIDC(Collection<String> clientIdsForOIDC);

        /**
         * <p>
         * The OIDC client ID for a Amazon Q Business application.
         * </p>
         * 
         * @param clientIdsForOIDC
         *        The OIDC client ID for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIdsForOIDC(String... clientIdsForOIDC);

        /**
         * <p>
         * The Amazon QuickSight authentication configuration for the Amazon Q Business application.
         * </p>
         * 
         * @param quickSightConfiguration
         *        The Amazon QuickSight authentication configuration for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSightConfiguration(QuickSightConfiguration quickSightConfiguration);

        /**
         * <p>
         * The Amazon QuickSight authentication configuration for the Amazon Q Business application.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickSightConfiguration.Builder} avoiding
         * the need to create one manually via {@link QuickSightConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickSightConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #quickSightConfiguration(QuickSightConfiguration)}.
         * 
         * @param quickSightConfiguration
         *        a consumer that will call methods on {@link QuickSightConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickSightConfiguration(QuickSightConfiguration)
         */
        default Builder quickSightConfiguration(Consumer<QuickSightConfiguration.Builder> quickSightConfiguration) {
            return quickSightConfiguration(QuickSightConfiguration.builder().applyMutation(quickSightConfiguration).build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String displayName;

        private String applicationId;

        private String applicationArn;

        private String identityType;

        private String iamIdentityProviderArn;

        private String identityCenterApplicationArn;

        private String roleArn;

        private String status;

        private String description;

        private EncryptionConfiguration encryptionConfiguration;

        private Instant createdAt;

        private Instant updatedAt;

        private ErrorDetail error;

        private AppliedAttachmentsConfiguration attachmentsConfiguration;

        private QAppsConfiguration qAppsConfiguration;

        private PersonalizationConfiguration personalizationConfiguration;

        private AutoSubscriptionConfiguration autoSubscriptionConfiguration;

        private List<String> clientIdsForOIDC = DefaultSdkAutoConstructList.getInstance();

        private QuickSightConfiguration quickSightConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            displayName(model.displayName);
            applicationId(model.applicationId);
            applicationArn(model.applicationArn);
            identityType(model.identityType);
            iamIdentityProviderArn(model.iamIdentityProviderArn);
            identityCenterApplicationArn(model.identityCenterApplicationArn);
            roleArn(model.roleArn);
            status(model.status);
            description(model.description);
            encryptionConfiguration(model.encryptionConfiguration);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            error(model.error);
            attachmentsConfiguration(model.attachmentsConfiguration);
            qAppsConfiguration(model.qAppsConfiguration);
            personalizationConfiguration(model.personalizationConfiguration);
            autoSubscriptionConfiguration(model.autoSubscriptionConfiguration);
            clientIdsForOIDC(model.clientIdsForOIDC);
            quickSightConfiguration(model.quickSightConfiguration);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIamIdentityProviderArn() {
            return iamIdentityProviderArn;
        }

        public final void setIamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
        }

        @Override
        public final Builder iamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final AppliedAttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return attachmentsConfiguration != null ? attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AppliedAttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AppliedAttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return qAppsConfiguration != null ? qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return personalizationConfiguration != null ? personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        public final AutoSubscriptionConfiguration.Builder getAutoSubscriptionConfiguration() {
            return autoSubscriptionConfiguration != null ? autoSubscriptionConfiguration.toBuilder() : null;
        }

        public final void setAutoSubscriptionConfiguration(AutoSubscriptionConfiguration.BuilderImpl autoSubscriptionConfiguration) {
            this.autoSubscriptionConfiguration = autoSubscriptionConfiguration != null ? autoSubscriptionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder autoSubscriptionConfiguration(AutoSubscriptionConfiguration autoSubscriptionConfiguration) {
            this.autoSubscriptionConfiguration = autoSubscriptionConfiguration;
            return this;
        }

        public final Collection<String> getClientIdsForOIDC() {
            if (clientIdsForOIDC instanceof SdkAutoConstructList) {
                return null;
            }
            return clientIdsForOIDC;
        }

        public final void setClientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
        }

        @Override
        public final Builder clientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIdsForOIDC(String... clientIdsForOIDC) {
            clientIdsForOIDC(Arrays.asList(clientIdsForOIDC));
            return this;
        }

        public final QuickSightConfiguration.Builder getQuickSightConfiguration() {
            return quickSightConfiguration != null ? quickSightConfiguration.toBuilder() : null;
        }

        public final void setQuickSightConfiguration(QuickSightConfiguration.BuilderImpl quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration != null ? quickSightConfiguration.build() : null;
        }

        @Override
        public final Builder quickSightConfiguration(QuickSightConfiguration quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
