/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A failed file upload during web experience chat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FailedAttachmentEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedAttachmentEvent.Builder, FailedAttachmentEvent>, ChatOutputStream {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(FailedAttachmentEvent::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessageId").getter(getter(FailedAttachmentEvent::userMessageId))
            .setter(setter(Builder::userMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageId").getter(getter(FailedAttachmentEvent::systemMessageId))
            .setter(setter(Builder::systemMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()).build();

    private static final SdkField<AttachmentOutput> ATTACHMENT_FIELD = SdkField
            .<AttachmentOutput> builder(MarshallingType.SDK_POJO).memberName("attachment")
            .getter(getter(FailedAttachmentEvent::attachment)).setter(setter(Builder::attachment))
            .constructor(AttachmentOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD,
            USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conversationId;

    private final String userMessageId;

    private final String systemMessageId;

    private final AttachmentOutput attachment;

    protected FailedAttachmentEvent(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * The identifier of the conversation associated with the failed file upload.
     * </p>
     * 
     * @return The identifier of the conversation associated with the failed file upload.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of the end user chat message associated with the file upload.
     * </p>
     * 
     * @return The identifier of the end user chat message associated with the file upload.
     */
    public final String userMessageId() {
        return userMessageId;
    }

    /**
     * <p>
     * The identifier of the AI-generated message associated with the file upload.
     * </p>
     * 
     * @return The identifier of the AI-generated message associated with the file upload.
     */
    public final String systemMessageId() {
        return systemMessageId;
    }

    /**
     * Returns the value of the Attachment property for this object.
     * 
     * @return The value of the Attachment property for this object.
     */
    public final AttachmentOutput attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedAttachmentEvent)) {
            return false;
        }
        FailedAttachmentEvent other = (FailedAttachmentEvent) obj;
        return Objects.equals(conversationId(), other.conversationId()) && Objects.equals(userMessageId(), other.userMessageId())
                && Objects.equals(systemMessageId(), other.systemMessageId()) && Objects.equals(attachment(), other.attachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedAttachmentEvent").add("ConversationId", conversationId())
                .add("UserMessageId", userMessageId()).add("SystemMessageId", systemMessageId()).add("Attachment", attachment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "userMessageId":
            return Optional.ofNullable(clazz.cast(userMessageId()));
        case "systemMessageId":
            return Optional.ofNullable(clazz.cast(systemMessageId()));
        case "attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final FailedAttachmentEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("attachment", ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedAttachmentEvent, T> g) {
        return obj -> g.apply((FailedAttachmentEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link FailedAttachmentEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedAttachmentEvent> {
        /**
         * <p>
         * The identifier of the conversation associated with the failed file upload.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the conversation associated with the failed file upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of the end user chat message associated with the file upload.
         * </p>
         * 
         * @param userMessageId
         *        The identifier of the end user chat message associated with the file upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessageId(String userMessageId);

        /**
         * <p>
         * The identifier of the AI-generated message associated with the file upload.
         * </p>
         * 
         * @param systemMessageId
         *        The identifier of the AI-generated message associated with the file upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageId(String systemMessageId);

        /**
         * Sets the value of the Attachment property for this object.
         *
         * @param attachment
         *        The new value for the Attachment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(AttachmentOutput attachment);

        /**
         * Sets the value of the Attachment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AttachmentOutput.Builder} avoiding the
         * need to create one manually via {@link AttachmentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #attachment(AttachmentOutput)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link AttachmentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(AttachmentOutput)
         */
        default Builder attachment(Consumer<AttachmentOutput.Builder> attachment) {
            return attachment(AttachmentOutput.builder().applyMutation(attachment).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String conversationId;

        private String userMessageId;

        private String systemMessageId;

        private AttachmentOutput attachment;

        protected BuilderImpl() {
        }

        protected BuilderImpl(FailedAttachmentEvent model) {
            conversationId(model.conversationId);
            userMessageId(model.userMessageId);
            systemMessageId(model.systemMessageId);
            attachment(model.attachment);
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final AttachmentOutput.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentOutput.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(AttachmentOutput attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public FailedAttachmentEvent build() {
            return new FailedAttachmentEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
