/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on boosting supported Amazon Q Business document attribute types. When an end user chat query
 * matches document attributes that have been boosted, Amazon Q Business prioritizes generating responses from content
 * that matches the boosted document attributes.
 * </p>
 * <p>
 * In version 2, boosting uses numeric values (ONE, TWO) to indicate priority tiers that establish clear hierarchical
 * relationships between boosted attributes. This allows for more precise control over how different attributes
 * influence search results.
 * </p>
 * <note>
 * <p>
 * For <code>STRING</code> and <code>STRING_LIST</code> type document attributes to be used for boosting on the console
 * and the API, they must be enabled for search using the <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html"
 * >DocumentAttributeConfiguration</a> object of the <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html">UpdateIndex</a> API. If you
 * haven't enabled searching on these attributes, you can't boost attributes of these data types on either the console
 * or the API.
 * </p>
 * </note>
 * <p>
 * For more information on how boosting document attributes work in Amazon Q Business, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html">Boosting using document
 * attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeBoostingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeBoostingConfiguration.Builder, DocumentAttributeBoostingConfiguration> {
    private static final SdkField<NumberAttributeBoostingConfiguration> NUMBER_CONFIGURATION_FIELD = SdkField
            .<NumberAttributeBoostingConfiguration> builder(MarshallingType.SDK_POJO).memberName("numberConfiguration")
            .getter(getter(DocumentAttributeBoostingConfiguration::numberConfiguration))
            .setter(setter(Builder::numberConfiguration)).constructor(NumberAttributeBoostingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberConfiguration").build())
            .build();

    private static final SdkField<StringAttributeBoostingConfiguration> STRING_CONFIGURATION_FIELD = SdkField
            .<StringAttributeBoostingConfiguration> builder(MarshallingType.SDK_POJO).memberName("stringConfiguration")
            .getter(getter(DocumentAttributeBoostingConfiguration::stringConfiguration))
            .setter(setter(Builder::stringConfiguration)).constructor(StringAttributeBoostingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringConfiguration").build())
            .build();

    private static final SdkField<DateAttributeBoostingConfiguration> DATE_CONFIGURATION_FIELD = SdkField
            .<DateAttributeBoostingConfiguration> builder(MarshallingType.SDK_POJO).memberName("dateConfiguration")
            .getter(getter(DocumentAttributeBoostingConfiguration::dateConfiguration)).setter(setter(Builder::dateConfiguration))
            .constructor(DateAttributeBoostingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateConfiguration").build()).build();

    private static final SdkField<StringListAttributeBoostingConfiguration> STRING_LIST_CONFIGURATION_FIELD = SdkField
            .<StringListAttributeBoostingConfiguration> builder(MarshallingType.SDK_POJO).memberName("stringListConfiguration")
            .getter(getter(DocumentAttributeBoostingConfiguration::stringListConfiguration))
            .setter(setter(Builder::stringListConfiguration)).constructor(StringListAttributeBoostingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringListConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_CONFIGURATION_FIELD,
            STRING_CONFIGURATION_FIELD, DATE_CONFIGURATION_FIELD, STRING_LIST_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NumberAttributeBoostingConfiguration numberConfiguration;

    private final StringAttributeBoostingConfiguration stringConfiguration;

    private final DateAttributeBoostingConfiguration dateConfiguration;

    private final StringListAttributeBoostingConfiguration stringListConfiguration;

    private final Type type;

    private DocumentAttributeBoostingConfiguration(BuilderImpl builder) {
        this.numberConfiguration = builder.numberConfiguration;
        this.stringConfiguration = builder.stringConfiguration;
        this.dateConfiguration = builder.dateConfiguration;
        this.stringListConfiguration = builder.stringListConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Provides information on boosting <code>NUMBER</code> type document attributes.
     * </p>
     * <p>
     * <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @return Provides information on boosting <code>NUMBER</code> type document attributes.</p>
     *         <p>
     *         <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version
     *         2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for
     *         source prioritization.
     */
    public final NumberAttributeBoostingConfiguration numberConfiguration() {
        return numberConfiguration;
    }

    /**
     * <p>
     * Provides information on boosting <code>STRING</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @return Provides information on boosting <code>STRING</code> type document attributes.</p>
     *         <p>
     *         Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
     *         relationships with other boosted attributes.
     */
    public final StringAttributeBoostingConfiguration stringConfiguration() {
        return stringConfiguration;
    }

    /**
     * <p>
     * Provides information on boosting <code>DATE</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @return Provides information on boosting <code>DATE</code> type document attributes.</p>
     *         <p>
     *         Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
     *         relationships with other boosted attributes.
     */
    public final DateAttributeBoostingConfiguration dateConfiguration() {
        return dateConfiguration;
    }

    /**
     * <p>
     * Provides information on boosting <code>STRING_LIST</code> type document attributes.
     * </p>
     * <p>
     * <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @return Provides information on boosting <code>STRING_LIST</code> type document attributes.</p>
     *         <p>
     *         <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
     *         version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes
     *         for source prioritization.
     */
    public final StringListAttributeBoostingConfiguration stringListConfiguration() {
        return stringListConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stringListConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeBoostingConfiguration)) {
            return false;
        }
        DocumentAttributeBoostingConfiguration other = (DocumentAttributeBoostingConfiguration) obj;
        return Objects.equals(numberConfiguration(), other.numberConfiguration())
                && Objects.equals(stringConfiguration(), other.stringConfiguration())
                && Objects.equals(dateConfiguration(), other.dateConfiguration())
                && Objects.equals(stringListConfiguration(), other.stringListConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeBoostingConfiguration").add("NumberConfiguration", numberConfiguration())
                .add("StringConfiguration", stringConfiguration()).add("DateConfiguration", dateConfiguration())
                .add("StringListConfiguration", stringListConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberConfiguration":
            return Optional.ofNullable(clazz.cast(numberConfiguration()));
        case "stringConfiguration":
            return Optional.ofNullable(clazz.cast(stringConfiguration()));
        case "dateConfiguration":
            return Optional.ofNullable(clazz.cast(dateConfiguration()));
        case "stringListConfiguration":
            return Optional.ofNullable(clazz.cast(stringListConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #numberConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>NUMBER</code> type document attributes.
     * </p>
     * <p>
     * <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @param numberConfiguration
     *        Provides information on boosting <code>NUMBER</code> type document attributes.</p>
     *        <p>
     *        <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version
     *        2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     *        prioritization.
     */
    public static DocumentAttributeBoostingConfiguration fromNumberConfiguration(
            NumberAttributeBoostingConfiguration numberConfiguration) {
        return builder().numberConfiguration(numberConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #numberConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>NUMBER</code> type document attributes.
     * </p>
     * <p>
     * <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @param numberConfiguration
     *        Provides information on boosting <code>NUMBER</code> type document attributes.</p>
     *        <p>
     *        <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version
     *        2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     *        prioritization.
     */
    public static DocumentAttributeBoostingConfiguration fromNumberConfiguration(
            Consumer<NumberAttributeBoostingConfiguration.Builder> numberConfiguration) {
        NumberAttributeBoostingConfiguration.Builder builder = NumberAttributeBoostingConfiguration.builder();
        numberConfiguration.accept(builder);
        return fromNumberConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>STRING</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @param stringConfiguration
     *        Provides information on boosting <code>STRING</code> type document attributes.</p>
     *        <p>
     *        Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
     *        relationships with other boosted attributes.
     */
    public static DocumentAttributeBoostingConfiguration fromStringConfiguration(
            StringAttributeBoostingConfiguration stringConfiguration) {
        return builder().stringConfiguration(stringConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #stringConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>STRING</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @param stringConfiguration
     *        Provides information on boosting <code>STRING</code> type document attributes.</p>
     *        <p>
     *        Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
     *        relationships with other boosted attributes.
     */
    public static DocumentAttributeBoostingConfiguration fromStringConfiguration(
            Consumer<StringAttributeBoostingConfiguration.Builder> stringConfiguration) {
        StringAttributeBoostingConfiguration.Builder builder = StringAttributeBoostingConfiguration.builder();
        stringConfiguration.accept(builder);
        return fromStringConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dateConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>DATE</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @param dateConfiguration
     *        Provides information on boosting <code>DATE</code> type document attributes.</p>
     *        <p>
     *        Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
     *        relationships with other boosted attributes.
     */
    public static DocumentAttributeBoostingConfiguration fromDateConfiguration(
            DateAttributeBoostingConfiguration dateConfiguration) {
        return builder().dateConfiguration(dateConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #dateConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>DATE</code> type document attributes.
     * </p>
     * <p>
     * Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical relationships
     * with other boosted attributes.
     * </p>
     * 
     * @param dateConfiguration
     *        Provides information on boosting <code>DATE</code> type document attributes.</p>
     *        <p>
     *        Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
     *        relationships with other boosted attributes.
     */
    public static DocumentAttributeBoostingConfiguration fromDateConfiguration(
            Consumer<DateAttributeBoostingConfiguration.Builder> dateConfiguration) {
        DateAttributeBoostingConfiguration.Builder builder = DateAttributeBoostingConfiguration.builder();
        dateConfiguration.accept(builder);
        return fromDateConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringListConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>STRING_LIST</code> type document attributes.
     * </p>
     * <p>
     * <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @param stringListConfiguration
     *        Provides information on boosting <code>STRING_LIST</code> type document attributes.</p>
     *        <p>
     *        <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
     *        version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes
     *        for source prioritization.
     */
    public static DocumentAttributeBoostingConfiguration fromStringListConfiguration(
            StringListAttributeBoostingConfiguration stringListConfiguration) {
        return builder().stringListConfiguration(stringListConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #stringListConfiguration()} initialized to the given value.
     *
     * <p>
     * Provides information on boosting <code>STRING_LIST</code> type document attributes.
     * </p>
     * <p>
     * <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
     * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
     * prioritization.
     * </p>
     * 
     * @param stringListConfiguration
     *        Provides information on boosting <code>STRING_LIST</code> type document attributes.</p>
     *        <p>
     *        <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
     *        version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes
     *        for source prioritization.
     */
    public static DocumentAttributeBoostingConfiguration fromStringListConfiguration(
            Consumer<StringListAttributeBoostingConfiguration.Builder> stringListConfiguration) {
        StringListAttributeBoostingConfiguration.Builder builder = StringListAttributeBoostingConfiguration.builder();
        stringListConfiguration.accept(builder);
        return fromStringListConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numberConfiguration", NUMBER_CONFIGURATION_FIELD);
        map.put("stringConfiguration", STRING_CONFIGURATION_FIELD);
        map.put("dateConfiguration", DATE_CONFIGURATION_FIELD);
        map.put("stringListConfiguration", STRING_LIST_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((DocumentAttributeBoostingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeBoostingConfiguration> {
        /**
         * <p>
         * Provides information on boosting <code>NUMBER</code> type document attributes.
         * </p>
         * <p>
         * <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
         * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
         * prioritization.
         * </p>
         * 
         * @param numberConfiguration
         *        Provides information on boosting <code>NUMBER</code> type document attributes.</p>
         *        <p>
         *        <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
         *        version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code>
         *        attributes for source prioritization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberConfiguration(NumberAttributeBoostingConfiguration numberConfiguration);

        /**
         * <p>
         * Provides information on boosting <code>NUMBER</code> type document attributes.
         * </p>
         * <p>
         * <code>NUMBER</code> attributes are not supported when using <code>NativeIndexConfiguration</code> version 2,
         * which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for source
         * prioritization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NumberAttributeBoostingConfiguration.Builder} avoiding the need to create one manually via
         * {@link NumberAttributeBoostingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberAttributeBoostingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #numberConfiguration(NumberAttributeBoostingConfiguration)}.
         * 
         * @param numberConfiguration
         *        a consumer that will call methods on {@link NumberAttributeBoostingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberConfiguration(NumberAttributeBoostingConfiguration)
         */
        default Builder numberConfiguration(Consumer<NumberAttributeBoostingConfiguration.Builder> numberConfiguration) {
            return numberConfiguration(NumberAttributeBoostingConfiguration.builder().applyMutation(numberConfiguration).build());
        }

        /**
         * <p>
         * Provides information on boosting <code>STRING</code> type document attributes.
         * </p>
         * <p>
         * Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
         * relationships with other boosted attributes.
         * </p>
         * 
         * @param stringConfiguration
         *        Provides information on boosting <code>STRING</code> type document attributes.</p>
         *        <p>
         *        Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
         *        relationships with other boosted attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringConfiguration(StringAttributeBoostingConfiguration stringConfiguration);

        /**
         * <p>
         * Provides information on boosting <code>STRING</code> type document attributes.
         * </p>
         * <p>
         * Version 2 assigns priority tiers to <code>STRING</code> attributes, establishing clear hierarchical
         * relationships with other boosted attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StringAttributeBoostingConfiguration.Builder} avoiding the need to create one manually via
         * {@link StringAttributeBoostingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringAttributeBoostingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #stringConfiguration(StringAttributeBoostingConfiguration)}.
         * 
         * @param stringConfiguration
         *        a consumer that will call methods on {@link StringAttributeBoostingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringConfiguration(StringAttributeBoostingConfiguration)
         */
        default Builder stringConfiguration(Consumer<StringAttributeBoostingConfiguration.Builder> stringConfiguration) {
            return stringConfiguration(StringAttributeBoostingConfiguration.builder().applyMutation(stringConfiguration).build());
        }

        /**
         * <p>
         * Provides information on boosting <code>DATE</code> type document attributes.
         * </p>
         * <p>
         * Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
         * relationships with other boosted attributes.
         * </p>
         * 
         * @param dateConfiguration
         *        Provides information on boosting <code>DATE</code> type document attributes.</p>
         *        <p>
         *        Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
         *        relationships with other boosted attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateConfiguration(DateAttributeBoostingConfiguration dateConfiguration);

        /**
         * <p>
         * Provides information on boosting <code>DATE</code> type document attributes.
         * </p>
         * <p>
         * Version 2 assigns priority tiers to <code>DATE</code> attributes, establishing clear hierarchical
         * relationships with other boosted attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DateAttributeBoostingConfiguration.Builder} avoiding the need to create one manually via
         * {@link DateAttributeBoostingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateAttributeBoostingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dateConfiguration(DateAttributeBoostingConfiguration)}.
         * 
         * @param dateConfiguration
         *        a consumer that will call methods on {@link DateAttributeBoostingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateConfiguration(DateAttributeBoostingConfiguration)
         */
        default Builder dateConfiguration(Consumer<DateAttributeBoostingConfiguration.Builder> dateConfiguration) {
            return dateConfiguration(DateAttributeBoostingConfiguration.builder().applyMutation(dateConfiguration).build());
        }

        /**
         * <p>
         * Provides information on boosting <code>STRING_LIST</code> type document attributes.
         * </p>
         * <p>
         * <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
         * version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for
         * source prioritization.
         * </p>
         * 
         * @param stringListConfiguration
         *        Provides information on boosting <code>STRING_LIST</code> type document attributes.</p>
         *        <p>
         *        <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
         *        version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code>
         *        attributes for source prioritization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListConfiguration(StringListAttributeBoostingConfiguration stringListConfiguration);

        /**
         * <p>
         * Provides information on boosting <code>STRING_LIST</code> type document attributes.
         * </p>
         * <p>
         * <code>STRING_LIST</code> attributes are not supported when using <code>NativeIndexConfiguration</code>
         * version 2, which focuses on <code>DATE</code> attributes for recency and <code>STRING</code> attributes for
         * source prioritization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StringListAttributeBoostingConfiguration.Builder} avoiding the need to create one manually via
         * {@link StringListAttributeBoostingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringListAttributeBoostingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #stringListConfiguration(StringListAttributeBoostingConfiguration)}.
         * 
         * @param stringListConfiguration
         *        a consumer that will call methods on {@link StringListAttributeBoostingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringListConfiguration(StringListAttributeBoostingConfiguration)
         */
        default Builder stringListConfiguration(Consumer<StringListAttributeBoostingConfiguration.Builder> stringListConfiguration) {
            return stringListConfiguration(StringListAttributeBoostingConfiguration.builder()
                    .applyMutation(stringListConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumberAttributeBoostingConfiguration numberConfiguration;

        private StringAttributeBoostingConfiguration stringConfiguration;

        private DateAttributeBoostingConfiguration dateConfiguration;

        private StringListAttributeBoostingConfiguration stringListConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeBoostingConfiguration model) {
            numberConfiguration(model.numberConfiguration);
            stringConfiguration(model.stringConfiguration);
            dateConfiguration(model.dateConfiguration);
            stringListConfiguration(model.stringListConfiguration);
        }

        public final NumberAttributeBoostingConfiguration.Builder getNumberConfiguration() {
            return numberConfiguration != null ? numberConfiguration.toBuilder() : null;
        }

        public final void setNumberConfiguration(NumberAttributeBoostingConfiguration.BuilderImpl numberConfiguration) {
            Object oldValue = this.numberConfiguration;
            this.numberConfiguration = numberConfiguration != null ? numberConfiguration.build() : null;
            handleUnionValueChange(Type.NUMBER_CONFIGURATION, oldValue, this.numberConfiguration);
        }

        @Override
        public final Builder numberConfiguration(NumberAttributeBoostingConfiguration numberConfiguration) {
            Object oldValue = this.numberConfiguration;
            this.numberConfiguration = numberConfiguration;
            handleUnionValueChange(Type.NUMBER_CONFIGURATION, oldValue, this.numberConfiguration);
            return this;
        }

        public final StringAttributeBoostingConfiguration.Builder getStringConfiguration() {
            return stringConfiguration != null ? stringConfiguration.toBuilder() : null;
        }

        public final void setStringConfiguration(StringAttributeBoostingConfiguration.BuilderImpl stringConfiguration) {
            Object oldValue = this.stringConfiguration;
            this.stringConfiguration = stringConfiguration != null ? stringConfiguration.build() : null;
            handleUnionValueChange(Type.STRING_CONFIGURATION, oldValue, this.stringConfiguration);
        }

        @Override
        public final Builder stringConfiguration(StringAttributeBoostingConfiguration stringConfiguration) {
            Object oldValue = this.stringConfiguration;
            this.stringConfiguration = stringConfiguration;
            handleUnionValueChange(Type.STRING_CONFIGURATION, oldValue, this.stringConfiguration);
            return this;
        }

        public final DateAttributeBoostingConfiguration.Builder getDateConfiguration() {
            return dateConfiguration != null ? dateConfiguration.toBuilder() : null;
        }

        public final void setDateConfiguration(DateAttributeBoostingConfiguration.BuilderImpl dateConfiguration) {
            Object oldValue = this.dateConfiguration;
            this.dateConfiguration = dateConfiguration != null ? dateConfiguration.build() : null;
            handleUnionValueChange(Type.DATE_CONFIGURATION, oldValue, this.dateConfiguration);
        }

        @Override
        public final Builder dateConfiguration(DateAttributeBoostingConfiguration dateConfiguration) {
            Object oldValue = this.dateConfiguration;
            this.dateConfiguration = dateConfiguration;
            handleUnionValueChange(Type.DATE_CONFIGURATION, oldValue, this.dateConfiguration);
            return this;
        }

        public final StringListAttributeBoostingConfiguration.Builder getStringListConfiguration() {
            return stringListConfiguration != null ? stringListConfiguration.toBuilder() : null;
        }

        public final void setStringListConfiguration(StringListAttributeBoostingConfiguration.BuilderImpl stringListConfiguration) {
            Object oldValue = this.stringListConfiguration;
            this.stringListConfiguration = stringListConfiguration != null ? stringListConfiguration.build() : null;
            handleUnionValueChange(Type.STRING_LIST_CONFIGURATION, oldValue, this.stringListConfiguration);
        }

        @Override
        public final Builder stringListConfiguration(StringListAttributeBoostingConfiguration stringListConfiguration) {
            Object oldValue = this.stringListConfiguration;
            this.stringListConfiguration = stringListConfiguration;
            handleUnionValueChange(Type.STRING_LIST_CONFIGURATION, oldValue, this.stringListConfiguration);
            return this;
        }

        @Override
        public DocumentAttributeBoostingConfiguration build() {
            return new DocumentAttributeBoostingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DocumentAttributeBoostingConfiguration#type()
     */
    public enum Type {
        NUMBER_CONFIGURATION,

        STRING_CONFIGURATION,

        DATE_CONFIGURATION,

        STRING_LIST_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
