/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents membership rules in the document's ACL, defining how users or groups are associated with access
 * permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAclMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAclMembership.Builder, DocumentAclMembership> {
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberRelation").getter(getter(DocumentAclMembership::memberRelationAsString))
            .setter(setter(Builder::memberRelation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()).build();

    private static final SdkField<List<DocumentAclCondition>> CONDITIONS_FIELD = SdkField
            .<List<DocumentAclCondition>> builder(MarshallingType.LIST)
            .memberName("conditions")
            .getter(getter(DocumentAclMembership::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAclCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAclCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_RELATION_FIELD,
            CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String memberRelation;

    private final List<DocumentAclCondition> conditions;

    private DocumentAclMembership(BuilderImpl builder) {
        this.memberRelation = builder.memberRelation;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * The logical relation between members in the membership rule, determining how multiple conditions are combined.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return The logical relation between members in the membership rule, determining how multiple conditions are
     *         combined.
     * @see MemberRelation
     */
    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(memberRelation);
    }

    /**
     * <p>
     * The logical relation between members in the membership rule, determining how multiple conditions are combined.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return The logical relation between members in the membership rule, determining how multiple conditions are
     *         combined.
     * @see MemberRelation
     */
    public final String memberRelationAsString() {
        return memberRelation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of conditions that define the membership rules. Each condition specifies criteria for users or groups to
     * be included in this membership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return An array of conditions that define the membership rules. Each condition specifies criteria for users or
     *         groups to be included in this membership.
     */
    public final List<DocumentAclCondition> conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberRelationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAclMembership)) {
            return false;
        }
        DocumentAclMembership other = (DocumentAclMembership) obj;
        return Objects.equals(memberRelationAsString(), other.memberRelationAsString())
                && hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAclMembership").add("MemberRelation", memberRelationAsString())
                .add("Conditions", hasConditions() ? conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberRelation":
            return Optional.ofNullable(clazz.cast(memberRelationAsString()));
        case "conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAclMembership, T> g) {
        return obj -> g.apply((DocumentAclMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAclMembership> {
        /**
         * <p>
         * The logical relation between members in the membership rule, determining how multiple conditions are
         * combined.
         * </p>
         * 
         * @param memberRelation
         *        The logical relation between members in the membership rule, determining how multiple conditions are
         *        combined.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(String memberRelation);

        /**
         * <p>
         * The logical relation between members in the membership rule, determining how multiple conditions are
         * combined.
         * </p>
         * 
         * @param memberRelation
         *        The logical relation between members in the membership rule, determining how multiple conditions are
         *        combined.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(MemberRelation memberRelation);

        /**
         * <p>
         * An array of conditions that define the membership rules. Each condition specifies criteria for users or
         * groups to be included in this membership.
         * </p>
         * 
         * @param conditions
         *        An array of conditions that define the membership rules. Each condition specifies criteria for users
         *        or groups to be included in this membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<DocumentAclCondition> conditions);

        /**
         * <p>
         * An array of conditions that define the membership rules. Each condition specifies criteria for users or
         * groups to be included in this membership.
         * </p>
         * 
         * @param conditions
         *        An array of conditions that define the membership rules. Each condition specifies criteria for users
         *        or groups to be included in this membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(DocumentAclCondition... conditions);

        /**
         * <p>
         * An array of conditions that define the membership rules. Each condition specifies criteria for users or
         * groups to be included in this membership.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<DocumentAclCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<DocumentAclCondition>)
         */
        Builder conditions(Consumer<DocumentAclCondition.Builder>... conditions);
    }

    static final class BuilderImpl implements Builder {
        private String memberRelation;

        private List<DocumentAclCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAclMembership model) {
            memberRelation(model.memberRelation);
            conditions(model.conditions);
        }

        public final String getMemberRelation() {
            return memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public final List<DocumentAclCondition.Builder> getConditions() {
            List<DocumentAclCondition.Builder> result = DocumentAclConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<DocumentAclCondition.BuilderImpl> conditions) {
            this.conditions = DocumentAclConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<DocumentAclCondition> conditions) {
            this.conditions = DocumentAclConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(DocumentAclCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<DocumentAclCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> DocumentAclCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentAclMembership build() {
            return new DocumentAclMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
