/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChatVisitorBuilder implements ChatResponseHandler.Visitor.Builder {
    private Consumer<ChatOutputStream> onDefault;

    private Consumer<TextOutputEvent> onTextEvent;

    private Consumer<MetadataEvent> onMetadataEvent;

    private Consumer<ActionReviewEvent> onActionReviewEvent;

    private Consumer<FailedAttachmentEvent> onFailedAttachmentEvent;

    private Consumer<AuthChallengeRequestEvent> onAuthChallengeRequestEvent;

    @Override
    public ChatResponseHandler.Visitor.Builder onDefault(Consumer<ChatOutputStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onTextEvent(Consumer<TextOutputEvent> c) {
        this.onTextEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onMetadataEvent(Consumer<MetadataEvent> c) {
        this.onMetadataEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onActionReviewEvent(Consumer<ActionReviewEvent> c) {
        this.onActionReviewEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onFailedAttachmentEvent(Consumer<FailedAttachmentEvent> c) {
        this.onFailedAttachmentEvent = c;
        return this;
    }

    @Override
    public ChatResponseHandler.Visitor.Builder onAuthChallengeRequestEvent(Consumer<AuthChallengeRequestEvent> c) {
        this.onAuthChallengeRequestEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements ChatResponseHandler.Visitor {
        private final Consumer<ChatOutputStream> onDefault;

        private final Consumer<TextOutputEvent> onTextEvent;

        private final Consumer<MetadataEvent> onMetadataEvent;

        private final Consumer<ActionReviewEvent> onActionReviewEvent;

        private final Consumer<FailedAttachmentEvent> onFailedAttachmentEvent;

        private final Consumer<AuthChallengeRequestEvent> onAuthChallengeRequestEvent;

        VisitorFromBuilder(DefaultChatVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault : ChatResponseHandler.Visitor.super::visitDefault;
            this.onTextEvent = builder.onTextEvent != null ? builder.onTextEvent
                    : ChatResponseHandler.Visitor.super::visitTextEvent;
            this.onMetadataEvent = builder.onMetadataEvent != null ? builder.onMetadataEvent
                    : ChatResponseHandler.Visitor.super::visitMetadataEvent;
            this.onActionReviewEvent = builder.onActionReviewEvent != null ? builder.onActionReviewEvent
                    : ChatResponseHandler.Visitor.super::visitActionReviewEvent;
            this.onFailedAttachmentEvent = builder.onFailedAttachmentEvent != null ? builder.onFailedAttachmentEvent
                    : ChatResponseHandler.Visitor.super::visitFailedAttachmentEvent;
            this.onAuthChallengeRequestEvent = builder.onAuthChallengeRequestEvent != null ? builder.onAuthChallengeRequestEvent
                    : ChatResponseHandler.Visitor.super::visitAuthChallengeRequestEvent;
        }

        @Override
        public void visitDefault(ChatOutputStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitTextEvent(TextOutputEvent event) {
            onTextEvent.accept(event);
        }

        @Override
        public void visitMetadataEvent(MetadataEvent event) {
            onMetadataEvent.accept(event);
        }

        @Override
        public void visitActionReviewEvent(ActionReviewEvent event) {
            onActionReviewEvent.accept(event);
        }

        @Override
        public void visitFailedAttachmentEvent(FailedAttachmentEvent event) {
            onFailedAttachmentEvent.accept(event);
        }

        @Override
        public void visitAuthChallengeRequestEvent(AuthChallengeRequestEvent event) {
            onAuthChallengeRequestEvent.accept(event);
        }
    }
}
