/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for IAM Identity Center Trusted Token Issuer (TTI) authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAccessorIdcTrustedTokenIssuerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataAccessorIdcTrustedTokenIssuerConfiguration.Builder, DataAccessorIdcTrustedTokenIssuerConfiguration> {
    private static final SdkField<String> IDC_TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcTrustedTokenIssuerArn")
            .getter(getter(DataAccessorIdcTrustedTokenIssuerConfiguration::idcTrustedTokenIssuerArn))
            .setter(setter(Builder::idcTrustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcTrustedTokenIssuerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDC_TRUSTED_TOKEN_ISSUER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idcTrustedTokenIssuerArn;

    private DataAccessorIdcTrustedTokenIssuerConfiguration(BuilderImpl builder) {
        this.idcTrustedTokenIssuerArn = builder.idcTrustedTokenIssuerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for
     * authentication.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for
     *         authentication.
     */
    public final String idcTrustedTokenIssuerArn() {
        return idcTrustedTokenIssuerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idcTrustedTokenIssuerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAccessorIdcTrustedTokenIssuerConfiguration)) {
            return false;
        }
        DataAccessorIdcTrustedTokenIssuerConfiguration other = (DataAccessorIdcTrustedTokenIssuerConfiguration) obj;
        return Objects.equals(idcTrustedTokenIssuerArn(), other.idcTrustedTokenIssuerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAccessorIdcTrustedTokenIssuerConfiguration")
                .add("IdcTrustedTokenIssuerArn", idcTrustedTokenIssuerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idcTrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(idcTrustedTokenIssuerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idcTrustedTokenIssuerArn", IDC_TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAccessorIdcTrustedTokenIssuerConfiguration, T> g) {
        return obj -> g.apply((DataAccessorIdcTrustedTokenIssuerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAccessorIdcTrustedTokenIssuerConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for
         * authentication.
         * </p>
         * 
         * @param idcTrustedTokenIssuerArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center Trusted Token Issuer that will be used for
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcTrustedTokenIssuerArn(String idcTrustedTokenIssuerArn);
    }

    static final class BuilderImpl implements Builder {
        private String idcTrustedTokenIssuerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAccessorIdcTrustedTokenIssuerConfiguration model) {
            idcTrustedTokenIssuerArn(model.idcTrustedTokenIssuerArn);
        }

        public final String getIdcTrustedTokenIssuerArn() {
            return idcTrustedTokenIssuerArn;
        }

        public final void setIdcTrustedTokenIssuerArn(String idcTrustedTokenIssuerArn) {
            this.idcTrustedTokenIssuerArn = idcTrustedTokenIssuerArn;
        }

        @Override
        public final Builder idcTrustedTokenIssuerArn(String idcTrustedTokenIssuerArn) {
            this.idcTrustedTokenIssuerArn = idcTrustedTokenIssuerArn;
            return this;
        }

        @Override
        public DataAccessorIdcTrustedTokenIssuerConfiguration build() {
            return new DataAccessorIdcTrustedTokenIssuerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
