/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePluginRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreatePluginRequest.Builder, CreatePluginRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreatePluginRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreatePluginRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreatePluginRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<PluginAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField
            .<PluginAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("authConfiguration")
            .getter(getter(CreatePluginRequest::authConfiguration)).setter(setter(Builder::authConfiguration))
            .constructor(PluginAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()).build();

    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverUrl").getter(getter(CreatePluginRequest::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()).build();

    private static final SdkField<CustomPluginConfiguration> CUSTOM_PLUGIN_CONFIGURATION_FIELD = SdkField
            .<CustomPluginConfiguration> builder(MarshallingType.SDK_POJO).memberName("customPluginConfiguration")
            .getter(getter(CreatePluginRequest::customPluginConfiguration)).setter(setter(Builder::customPluginConfiguration))
            .constructor(CustomPluginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreatePluginRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePluginRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DISPLAY_NAME_FIELD, TYPE_FIELD, AUTH_CONFIGURATION_FIELD, SERVER_URL_FIELD, CUSTOM_PLUGIN_CONFIGURATION_FIELD,
            TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String displayName;

    private final String type;

    private final PluginAuthConfiguration authConfiguration;

    private final String serverUrl;

    private final CustomPluginConfiguration customPluginConfiguration;

    private final List<Tag> tags;

    private final String clientToken;

    private CreatePluginRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.authConfiguration = builder.authConfiguration;
        this.serverUrl = builder.serverUrl;
        this.customPluginConfiguration = builder.customPluginConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the application that will contain the plugin.
     * </p>
     * 
     * @return The identifier of the application that will contain the plugin.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A the name for your plugin.
     * </p>
     * 
     * @return A the name for your plugin.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type of plugin you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of plugin you want to create.
     * @see PluginType
     */
    public final PluginType type() {
        return PluginType.fromValue(type);
    }

    /**
     * <p>
     * The type of plugin you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of plugin you want to create.
     * @see PluginType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the AuthConfiguration property for this object.
     * 
     * @return The value of the AuthConfiguration property for this object.
     */
    public final PluginAuthConfiguration authConfiguration() {
        return authConfiguration;
    }

    /**
     * <p>
     * The source URL used for plugin configuration.
     * </p>
     * 
     * @return The source URL used for plugin configuration.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    /**
     * <p>
     * Contains configuration for a custom plugin.
     * </p>
     * 
     * @return Contains configuration for a custom plugin.
     */
    public final CustomPluginConfiguration customPluginConfiguration() {
        return customPluginConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help
     * control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
     *         help control access to the data source connector. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create your Amazon Q Business plugin.
     * </p>
     * 
     * @return A token that you provide to identify the request to create your Amazon Q Business plugin.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePluginRequest)) {
            return false;
        }
        CreatePluginRequest other = (CreatePluginRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(authConfiguration(), other.authConfiguration())
                && Objects.equals(serverUrl(), other.serverUrl())
                && Objects.equals(customPluginConfiguration(), other.customPluginConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePluginRequest").add("ApplicationId", applicationId()).add("DisplayName", displayName())
                .add("Type", typeAsString()).add("AuthConfiguration", authConfiguration()).add("ServerUrl", serverUrl())
                .add("CustomPluginConfiguration", customPluginConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "authConfiguration":
            return Optional.ofNullable(clazz.cast(authConfiguration()));
        case "serverUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        case "customPluginConfiguration":
            return Optional.ofNullable(clazz.cast(customPluginConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        map.put("customPluginConfiguration", CUSTOM_PLUGIN_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePluginRequest, T> g) {
        return obj -> g.apply((CreatePluginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePluginRequest> {
        /**
         * <p>
         * The identifier of the application that will contain the plugin.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application that will contain the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A the name for your plugin.
         * </p>
         * 
         * @param displayName
         *        A the name for your plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type of plugin you want to create.
         * </p>
         * 
         * @param type
         *        The type of plugin you want to create.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of plugin you want to create.
         * </p>
         * 
         * @param type
         *        The type of plugin you want to create.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(PluginType type);

        /**
         * Sets the value of the AuthConfiguration property for this object.
         *
         * @param authConfiguration
         *        The new value for the AuthConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfiguration(PluginAuthConfiguration authConfiguration);

        /**
         * Sets the value of the AuthConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PluginAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link PluginAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginAuthConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authConfiguration(PluginAuthConfiguration)}.
         * 
         * @param authConfiguration
         *        a consumer that will call methods on {@link PluginAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfiguration(PluginAuthConfiguration)
         */
        default Builder authConfiguration(Consumer<PluginAuthConfiguration.Builder> authConfiguration) {
            return authConfiguration(PluginAuthConfiguration.builder().applyMutation(authConfiguration).build());
        }

        /**
         * <p>
         * The source URL used for plugin configuration.
         * </p>
         * 
         * @param serverUrl
         *        The source URL used for plugin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);

        /**
         * <p>
         * Contains configuration for a custom plugin.
         * </p>
         * 
         * @param customPluginConfiguration
         *        Contains configuration for a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration);

        /**
         * <p>
         * Contains configuration for a custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomPluginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPluginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customPluginConfiguration(CustomPluginConfiguration)}.
         * 
         * @param customPluginConfiguration
         *        a consumer that will call methods on {@link CustomPluginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPluginConfiguration(CustomPluginConfiguration)
         */
        default Builder customPluginConfiguration(Consumer<CustomPluginConfiguration.Builder> customPluginConfiguration) {
            return customPluginConfiguration(CustomPluginConfiguration.builder().applyMutation(customPluginConfiguration).build());
        }

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token that you provide to identify the request to create your Amazon Q Business plugin.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create your Amazon Q Business plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String displayName;

        private String type;

        private PluginAuthConfiguration authConfiguration;

        private String serverUrl;

        private CustomPluginConfiguration customPluginConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePluginRequest model) {
            super(model);
            applicationId(model.applicationId);
            displayName(model.displayName);
            type(model.type);
            authConfiguration(model.authConfiguration);
            serverUrl(model.serverUrl);
            customPluginConfiguration(model.customPluginConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PluginType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final PluginAuthConfiguration.Builder getAuthConfiguration() {
            return authConfiguration != null ? authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(PluginAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(PluginAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final CustomPluginConfiguration.Builder getCustomPluginConfiguration() {
            return customPluginConfiguration != null ? customPluginConfiguration.toBuilder() : null;
        }

        public final void setCustomPluginConfiguration(CustomPluginConfiguration.BuilderImpl customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration != null ? customPluginConfiguration.build() : null;
        }

        @Override
        public final Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePluginRequest build() {
            return new CreatePluginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
