/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDocumentAccessResponse extends QBusinessResponse implements
        ToCopyableBuilder<CheckDocumentAccessResponse.Builder, CheckDocumentAccessResponse> {
    private static final SdkField<List<AssociatedGroup>> USER_GROUPS_FIELD = SdkField
            .<List<AssociatedGroup>> builder(MarshallingType.LIST)
            .memberName("userGroups")
            .getter(getter(CheckDocumentAccessResponse::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssociatedUser>> USER_ALIASES_FIELD = SdkField
            .<List<AssociatedUser>> builder(MarshallingType.LIST)
            .memberName("userAliases")
            .getter(getter(CheckDocumentAccessResponse::userAliases))
            .setter(setter(Builder::userAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasAccess").getter(getter(CheckDocumentAccessResponse::hasAccess)).setter(setter(Builder::hasAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasAccess").build()).build();

    private static final SdkField<DocumentAcl> DOCUMENT_ACL_FIELD = SdkField.<DocumentAcl> builder(MarshallingType.SDK_POJO)
            .memberName("documentAcl").getter(getter(CheckDocumentAccessResponse::documentAcl))
            .setter(setter(Builder::documentAcl)).constructor(DocumentAcl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAcl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUPS_FIELD,
            USER_ALIASES_FIELD, HAS_ACCESS_FIELD, DOCUMENT_ACL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociatedGroup> userGroups;

    private final List<AssociatedUser> userAliases;

    private final Boolean hasAccess;

    private final DocumentAcl documentAcl;

    private CheckDocumentAccessResponse(BuilderImpl builder) {
        super(builder);
        this.userGroups = builder.userGroups;
        this.userAliases = builder.userAliases;
        this.hasAccess = builder.hasAccess;
        this.documentAcl = builder.documentAcl;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of groups the user is part of for the specified data source. Each group has a name and type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroups} method.
     * </p>
     * 
     * @return An array of groups the user is part of for the specified data source. Each group has a name and type.
     */
    public final List<AssociatedGroup> userGroups() {
        return userGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliases() {
        return userAliases != null && !(userAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of aliases associated with the user. This includes both global and local aliases, each with a name and
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliases} method.
     * </p>
     * 
     * @return An array of aliases associated with the user. This includes both global and local aliases, each with a
     *         name and type.
     */
    public final List<AssociatedUser> userAliases() {
        return userAliases;
    }

    /**
     * <p>
     * A boolean value indicating whether the specified user has access to the document, either direct access or
     * transitive access via groups and aliases attached to the document.
     * </p>
     * 
     * @return A boolean value indicating whether the specified user has access to the document, either direct access or
     *         transitive access via groups and aliases attached to the document.
     */
    public final Boolean hasAccess() {
        return hasAccess;
    }

    /**
     * <p>
     * The Access Control List (ACL) associated with the document. Includes allowlist and denylist conditions that
     * determine user access.
     * </p>
     * 
     * @return The Access Control List (ACL) associated with the document. Includes allowlist and denylist conditions
     *         that determine user access.
     */
    public final DocumentAcl documentAcl() {
        return documentAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliases() ? userAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccess());
        hashCode = 31 * hashCode + Objects.hashCode(documentAcl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDocumentAccessResponse)) {
            return false;
        }
        CheckDocumentAccessResponse other = (CheckDocumentAccessResponse) obj;
        return hasUserGroups() == other.hasUserGroups() && Objects.equals(userGroups(), other.userGroups())
                && hasUserAliases() == other.hasUserAliases() && Objects.equals(userAliases(), other.userAliases())
                && Objects.equals(hasAccess(), other.hasAccess()) && Objects.equals(documentAcl(), other.documentAcl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckDocumentAccessResponse").add("UserGroups", hasUserGroups() ? userGroups() : null)
                .add("UserAliases", hasUserAliases() ? userAliases() : null).add("HasAccess", hasAccess())
                .add("DocumentAcl", documentAcl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "userAliases":
            return Optional.ofNullable(clazz.cast(userAliases()));
        case "hasAccess":
            return Optional.ofNullable(clazz.cast(hasAccess()));
        case "documentAcl":
            return Optional.ofNullable(clazz.cast(documentAcl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userGroups", USER_GROUPS_FIELD);
        map.put("userAliases", USER_ALIASES_FIELD);
        map.put("hasAccess", HAS_ACCESS_FIELD);
        map.put("documentAcl", DOCUMENT_ACL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckDocumentAccessResponse, T> g) {
        return obj -> g.apply((CheckDocumentAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CheckDocumentAccessResponse> {
        /**
         * <p>
         * An array of groups the user is part of for the specified data source. Each group has a name and type.
         * </p>
         * 
         * @param userGroups
         *        An array of groups the user is part of for the specified data source. Each group has a name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<AssociatedGroup> userGroups);

        /**
         * <p>
         * An array of groups the user is part of for the specified data source. Each group has a name and type.
         * </p>
         * 
         * @param userGroups
         *        An array of groups the user is part of for the specified data source. Each group has a name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(AssociatedGroup... userGroups);

        /**
         * <p>
         * An array of groups the user is part of for the specified data source. Each group has a name and type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AssociatedGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AssociatedGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AssociatedGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #userGroups(List<AssociatedGroup>)}.
         * 
         * @param userGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AssociatedGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroups(java.util.Collection<AssociatedGroup>)
         */
        Builder userGroups(Consumer<AssociatedGroup.Builder>... userGroups);

        /**
         * <p>
         * An array of aliases associated with the user. This includes both global and local aliases, each with a name
         * and type.
         * </p>
         * 
         * @param userAliases
         *        An array of aliases associated with the user. This includes both global and local aliases, each with a
         *        name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(Collection<AssociatedUser> userAliases);

        /**
         * <p>
         * An array of aliases associated with the user. This includes both global and local aliases, each with a name
         * and type.
         * </p>
         * 
         * @param userAliases
         *        An array of aliases associated with the user. This includes both global and local aliases, each with a
         *        name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(AssociatedUser... userAliases);

        /**
         * <p>
         * An array of aliases associated with the user. This includes both global and local aliases, each with a name
         * and type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AssociatedUser.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AssociatedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AssociatedUser.Builder#build()} is called immediately
         * and its result is passed to {@link #userAliases(List<AssociatedUser>)}.
         * 
         * @param userAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AssociatedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliases(java.util.Collection<AssociatedUser>)
         */
        Builder userAliases(Consumer<AssociatedUser.Builder>... userAliases);

        /**
         * <p>
         * A boolean value indicating whether the specified user has access to the document, either direct access or
         * transitive access via groups and aliases attached to the document.
         * </p>
         * 
         * @param hasAccess
         *        A boolean value indicating whether the specified user has access to the document, either direct access
         *        or transitive access via groups and aliases attached to the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasAccess(Boolean hasAccess);

        /**
         * <p>
         * The Access Control List (ACL) associated with the document. Includes allowlist and denylist conditions that
         * determine user access.
         * </p>
         * 
         * @param documentAcl
         *        The Access Control List (ACL) associated with the document. Includes allowlist and denylist conditions
         *        that determine user access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAcl(DocumentAcl documentAcl);

        /**
         * <p>
         * The Access Control List (ACL) associated with the document. Includes allowlist and denylist conditions that
         * determine user access.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAcl.Builder} avoiding the need to
         * create one manually via {@link DocumentAcl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAcl.Builder#build()} is called immediately and its result
         * is passed to {@link #documentAcl(DocumentAcl)}.
         * 
         * @param documentAcl
         *        a consumer that will call methods on {@link DocumentAcl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAcl(DocumentAcl)
         */
        default Builder documentAcl(Consumer<DocumentAcl.Builder> documentAcl) {
            return documentAcl(DocumentAcl.builder().applyMutation(documentAcl).build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<AssociatedGroup> userGroups = DefaultSdkAutoConstructList.getInstance();

        private List<AssociatedUser> userAliases = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasAccess;

        private DocumentAcl documentAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDocumentAccessResponse model) {
            super(model);
            userGroups(model.userGroups);
            userAliases(model.userAliases);
            hasAccess(model.hasAccess);
            documentAcl(model.documentAcl);
        }

        public final List<AssociatedGroup.Builder> getUserGroups() {
            List<AssociatedGroup.Builder> result = AssociatedGroupsCopier.copyToBuilder(this.userGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserGroups(Collection<AssociatedGroup.BuilderImpl> userGroups) {
            this.userGroups = AssociatedGroupsCopier.copyFromBuilder(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<AssociatedGroup> userGroups) {
            this.userGroups = AssociatedGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(AssociatedGroup... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(Consumer<AssociatedGroup.Builder>... userGroups) {
            userGroups(Stream.of(userGroups).map(c -> AssociatedGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssociatedUser.Builder> getUserAliases() {
            List<AssociatedUser.Builder> result = AssociatedUsersCopier.copyToBuilder(this.userAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliases(Collection<AssociatedUser.BuilderImpl> userAliases) {
            this.userAliases = AssociatedUsersCopier.copyFromBuilder(userAliases);
        }

        @Override
        public final Builder userAliases(Collection<AssociatedUser> userAliases) {
            this.userAliases = AssociatedUsersCopier.copy(userAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(AssociatedUser... userAliases) {
            userAliases(Arrays.asList(userAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(Consumer<AssociatedUser.Builder>... userAliases) {
            userAliases(Stream.of(userAliases).map(c -> AssociatedUser.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getHasAccess() {
            return hasAccess;
        }

        public final void setHasAccess(Boolean hasAccess) {
            this.hasAccess = hasAccess;
        }

        @Override
        public final Builder hasAccess(Boolean hasAccess) {
            this.hasAccess = hasAccess;
            return this;
        }

        public final DocumentAcl.Builder getDocumentAcl() {
            return documentAcl != null ? documentAcl.toBuilder() : null;
        }

        public final void setDocumentAcl(DocumentAcl.BuilderImpl documentAcl) {
            this.documentAcl = documentAcl != null ? documentAcl.build() : null;
        }

        @Override
        public final Builder documentAcl(DocumentAcl documentAcl) {
            this.documentAcl = documentAcl;
            return this;
        }

        @Override
        public CheckDocumentAccessResponse build() {
            return new CheckDocumentAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
