/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDocumentAccessRequest extends QBusinessRequest implements
        ToCopyableBuilder<CheckDocumentAccessRequest.Builder, CheckDocumentAccessRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CheckDocumentAccessRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(CheckDocumentAccessRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(CheckDocumentAccessRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentId").getter(getter(CheckDocumentAccessRequest::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("documentId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(CheckDocumentAccessRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dataSourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, USER_ID_FIELD, DOCUMENT_ID_FIELD, DATA_SOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String indexId;

    private final String userId;

    private final String documentId;

    private final String dataSourceId;

    private CheckDocumentAccessRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.userId = builder.userId;
        this.documentId = builder.documentId;
        this.dataSourceId = builder.dataSourceId;
    }

    /**
     * <p>
     * The unique identifier of the application. This is required to identify the specific Amazon Q Business application
     * context for the document access check.
     * </p>
     * 
     * @return The unique identifier of the application. This is required to identify the specific Amazon Q Business
     *         application context for the document access check.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier of the index. Used to locate the correct index within the application where the document is
     * stored.
     * </p>
     * 
     * @return The unique identifier of the index. Used to locate the correct index within the application where the
     *         document is stored.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The unique identifier of the user. Used to check the access permissions for this specific user against the
     * document's ACL.
     * </p>
     * 
     * @return The unique identifier of the user. Used to check the access permissions for this specific user against
     *         the document's ACL.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The unique identifier of the document. Specifies which document's access permissions are being checked.
     * </p>
     * 
     * @return The unique identifier of the document. Specifies which document's access permissions are being checked.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The unique identifier of the data source. Identifies the specific data source from which the document originates.
     * Should not be used when a document is uploaded directly with BatchPutDocument, as no dataSourceId is available or
     * necessary.
     * </p>
     * 
     * @return The unique identifier of the data source. Identifies the specific data source from which the document
     *         originates. Should not be used when a document is uploaded directly with BatchPutDocument, as no
     *         dataSourceId is available or necessary.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDocumentAccessRequest)) {
            return false;
        }
        CheckDocumentAccessRequest other = (CheckDocumentAccessRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(userId(), other.userId()) && Objects.equals(documentId(), other.documentId())
                && Objects.equals(dataSourceId(), other.dataSourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckDocumentAccessRequest").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("UserId", userId()).add("DocumentId", documentId()).add("DataSourceId", dataSourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "documentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("documentId", DOCUMENT_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckDocumentAccessRequest, T> g) {
        return obj -> g.apply((CheckDocumentAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckDocumentAccessRequest> {
        /**
         * <p>
         * The unique identifier of the application. This is required to identify the specific Amazon Q Business
         * application context for the document access check.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application. This is required to identify the specific Amazon Q Business
         *        application context for the document access check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier of the index. Used to locate the correct index within the application where the
         * document is stored.
         * </p>
         * 
         * @param indexId
         *        The unique identifier of the index. Used to locate the correct index within the application where the
         *        document is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The unique identifier of the user. Used to check the access permissions for this specific user against the
         * document's ACL.
         * </p>
         * 
         * @param userId
         *        The unique identifier of the user. Used to check the access permissions for this specific user against
         *        the document's ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The unique identifier of the document. Specifies which document's access permissions are being checked.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the document. Specifies which document's access permissions are being
         *        checked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The unique identifier of the data source. Identifies the specific data source from which the document
         * originates. Should not be used when a document is uploaded directly with BatchPutDocument, as no dataSourceId
         * is available or necessary.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source. Identifies the specific data source from which the document
         *        originates. Should not be used when a document is uploaded directly with BatchPutDocument, as no
         *        dataSourceId is available or necessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String userId;

        private String documentId;

        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDocumentAccessRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            userId(model.userId);
            documentId(model.documentId);
            dataSourceId(model.dataSourceId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDocumentAccessRequest build() {
            return new CheckDocumentAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
