/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details that define how Amazon Q Business generates and formats responses to user queries in chat
 * interactions. This configuration allows administrators to customize response characteristics to meet specific
 * organizational needs and communication standards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatResponseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatResponseConfiguration.Builder, ChatResponseConfiguration> {
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationId")
            .getter(getter(ChatResponseConfiguration::chatResponseConfigurationId))
            .setter(setter(Builder::chatResponseConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationId")
                    .build()).build();

    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationArn")
            .getter(getter(ChatResponseConfiguration::chatResponseConfigurationArn))
            .setter(setter(Builder::chatResponseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ChatResponseConfiguration::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> RESPONSE_CONFIGURATION_SUMMARY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("responseConfigurationSummary")
            .getter(getter(ChatResponseConfiguration::responseConfigurationSummary))
            .setter(setter(Builder::responseConfigurationSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurationSummary")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ChatResponseConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ChatResponseConfiguration::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(ChatResponseConfiguration::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHAT_RESPONSE_CONFIGURATION_ID_FIELD, CHAT_RESPONSE_CONFIGURATION_ARN_FIELD, DISPLAY_NAME_FIELD,
            RESPONSE_CONFIGURATION_SUMMARY_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String chatResponseConfigurationId;

    private final String chatResponseConfigurationArn;

    private final String displayName;

    private final String responseConfigurationSummary;

    private final String status;

    private final Instant createdAt;

    private final Instant updatedAt;

    private ChatResponseConfiguration(BuilderImpl builder) {
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
        this.chatResponseConfigurationArn = builder.chatResponseConfigurationArn;
        this.displayName = builder.displayName;
        this.responseConfigurationSummary = builder.responseConfigurationSummary;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * A unique identifier for your chat response configuration settings, used to reference and manage the configuration
     * within the Amazon Q Business service.
     * </p>
     * 
     * @return A unique identifier for your chat response configuration settings, used to reference and manage the
     *         configuration within the Amazon Q Business service.
     */
    public final String chatResponseConfigurationId() {
        return chatResponseConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the chat response configuration, which uniquely identifies the resource across
     * all Amazon Web Services services and accounts.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the chat response configuration, which uniquely identifies the resource
     *         across all Amazon Web Services services and accounts.
     */
    public final String chatResponseConfigurationArn() {
        return chatResponseConfigurationArn;
    }

    /**
     * <p>
     * A human-readable name for the chat response configuration, making it easier to identify and manage multiple
     * configurations within an organization.
     * </p>
     * 
     * @return A human-readable name for the chat response configuration, making it easier to identify and manage
     *         multiple configurations within an organization.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A summary of the response configuration settings, providing a concise overview of the key parameters that define
     * how responses are generated and formatted.
     * </p>
     * 
     * @return A summary of the response configuration settings, providing a concise overview of the key parameters that
     *         define how responses are generated and formatted.
     */
    public final String responseConfigurationSummary() {
        return responseConfigurationSummary;
    }

    /**
     * <p>
     * The current status of the chat response configuration, indicating whether it is active, pending, or in another
     * state that affects its availability for use in chat interactions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChatResponseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the chat response configuration, indicating whether it is active, pending, or in
     *         another state that affects its availability for use in chat interactions.
     * @see ChatResponseConfigurationStatus
     */
    public final ChatResponseConfigurationStatus status() {
        return ChatResponseConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the chat response configuration, indicating whether it is active, pending, or in another
     * state that affects its availability for use in chat interactions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChatResponseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the chat response configuration, indicating whether it is active, pending, or in
     *         another state that affects its availability for use in chat interactions.
     * @see ChatResponseConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp indicating when the chat response configuration was initially created, useful for tracking the
     * lifecycle of configuration resources.
     * </p>
     * 
     * @return The timestamp indicating when the chat response configuration was initially created, useful for tracking
     *         the lifecycle of configuration resources.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp indicating when the chat response configuration was last modified, helping administrators track
     * changes and maintain version awareness.
     * </p>
     * 
     * @return The timestamp indicating when the chat response configuration was last modified, helping administrators
     *         track changes and maintain version awareness.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(responseConfigurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatResponseConfiguration)) {
            return false;
        }
        ChatResponseConfiguration other = (ChatResponseConfiguration) obj;
        return Objects.equals(chatResponseConfigurationId(), other.chatResponseConfigurationId())
                && Objects.equals(chatResponseConfigurationArn(), other.chatResponseConfigurationArn())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(responseConfigurationSummary(), other.responseConfigurationSummary())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatResponseConfiguration").add("ChatResponseConfigurationId", chatResponseConfigurationId())
                .add("ChatResponseConfigurationArn", chatResponseConfigurationArn()).add("DisplayName", displayName())
                .add("ResponseConfigurationSummary", responseConfigurationSummary()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatResponseConfigurationId":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationId()));
        case "chatResponseConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "responseConfigurationSummary":
            return Optional.ofNullable(clazz.cast(responseConfigurationSummary()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        map.put("chatResponseConfigurationArn", CHAT_RESPONSE_CONFIGURATION_ARN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("responseConfigurationSummary", RESPONSE_CONFIGURATION_SUMMARY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatResponseConfiguration, T> g) {
        return obj -> g.apply((ChatResponseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatResponseConfiguration> {
        /**
         * <p>
         * A unique identifier for your chat response configuration settings, used to reference and manage the
         * configuration within the Amazon Q Business service.
         * </p>
         * 
         * @param chatResponseConfigurationId
         *        A unique identifier for your chat response configuration settings, used to reference and manage the
         *        configuration within the Amazon Q Business service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationId(String chatResponseConfigurationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the chat response configuration, which uniquely identifies the resource
         * across all Amazon Web Services services and accounts.
         * </p>
         * 
         * @param chatResponseConfigurationArn
         *        The Amazon Resource Name (ARN) of the chat response configuration, which uniquely identifies the
         *        resource across all Amazon Web Services services and accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationArn(String chatResponseConfigurationArn);

        /**
         * <p>
         * A human-readable name for the chat response configuration, making it easier to identify and manage multiple
         * configurations within an organization.
         * </p>
         * 
         * @param displayName
         *        A human-readable name for the chat response configuration, making it easier to identify and manage
         *        multiple configurations within an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A summary of the response configuration settings, providing a concise overview of the key parameters that
         * define how responses are generated and formatted.
         * </p>
         * 
         * @param responseConfigurationSummary
         *        A summary of the response configuration settings, providing a concise overview of the key parameters
         *        that define how responses are generated and formatted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurationSummary(String responseConfigurationSummary);

        /**
         * <p>
         * The current status of the chat response configuration, indicating whether it is active, pending, or in
         * another state that affects its availability for use in chat interactions.
         * </p>
         * 
         * @param status
         *        The current status of the chat response configuration, indicating whether it is active, pending, or in
         *        another state that affects its availability for use in chat interactions.
         * @see ChatResponseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatResponseConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the chat response configuration, indicating whether it is active, pending, or in
         * another state that affects its availability for use in chat interactions.
         * </p>
         * 
         * @param status
         *        The current status of the chat response configuration, indicating whether it is active, pending, or in
         *        another state that affects its availability for use in chat interactions.
         * @see ChatResponseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatResponseConfigurationStatus
         */
        Builder status(ChatResponseConfigurationStatus status);

        /**
         * <p>
         * The timestamp indicating when the chat response configuration was initially created, useful for tracking the
         * lifecycle of configuration resources.
         * </p>
         * 
         * @param createdAt
         *        The timestamp indicating when the chat response configuration was initially created, useful for
         *        tracking the lifecycle of configuration resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp indicating when the chat response configuration was last modified, helping administrators track
         * changes and maintain version awareness.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp indicating when the chat response configuration was last modified, helping
         *        administrators track changes and maintain version awareness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String chatResponseConfigurationId;

        private String chatResponseConfigurationArn;

        private String displayName;

        private String responseConfigurationSummary;

        private String status;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatResponseConfiguration model) {
            chatResponseConfigurationId(model.chatResponseConfigurationId);
            chatResponseConfigurationArn(model.chatResponseConfigurationArn);
            displayName(model.displayName);
            responseConfigurationSummary(model.responseConfigurationSummary);
            status(model.status);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getChatResponseConfigurationId() {
            return chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        public final String getChatResponseConfigurationArn() {
            return chatResponseConfigurationArn;
        }

        public final void setChatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
        }

        @Override
        public final Builder chatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getResponseConfigurationSummary() {
            return responseConfigurationSummary;
        }

        public final void setResponseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
        }

        @Override
        public final Builder responseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChatResponseConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ChatResponseConfiguration build() {
            return new ChatResponseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
