/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for Amazon Q Business conversation modes.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin
 * controls and guardrails</a> and <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
 * >Conversation settings</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatModeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatModeConfiguration.Builder, ChatModeConfiguration> {
    private static final SdkField<PluginConfiguration> PLUGIN_CONFIGURATION_FIELD = SdkField
            .<PluginConfiguration> builder(MarshallingType.SDK_POJO).memberName("pluginConfiguration")
            .getter(getter(ChatModeConfiguration::pluginConfiguration)).setter(setter(Builder::pluginConfiguration))
            .constructor(PluginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PluginConfiguration pluginConfiguration;

    private final Type type;

    private ChatModeConfiguration(BuilderImpl builder) {
        this.pluginConfiguration = builder.pluginConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     * </p>
     * 
     * @return Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     */
    public final PluginConfiguration pluginConfiguration() {
        return pluginConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pluginConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatModeConfiguration)) {
            return false;
        }
        ChatModeConfiguration other = (ChatModeConfiguration) obj;
        return Objects.equals(pluginConfiguration(), other.pluginConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatModeConfiguration").add("PluginConfiguration", pluginConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pluginConfiguration":
            return Optional.ofNullable(clazz.cast(pluginConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #pluginConfiguration()} initialized to the given value.
     *
     * <p>
     * Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     * </p>
     * 
     * @param pluginConfiguration
     *        Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     */
    public static ChatModeConfiguration fromPluginConfiguration(PluginConfiguration pluginConfiguration) {
        return builder().pluginConfiguration(pluginConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #pluginConfiguration()} initialized to the given value.
     *
     * <p>
     * Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     * </p>
     * 
     * @param pluginConfiguration
     *        Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
     */
    public static ChatModeConfiguration fromPluginConfiguration(Consumer<PluginConfiguration.Builder> pluginConfiguration) {
        PluginConfiguration.Builder builder = PluginConfiguration.builder();
        pluginConfiguration.accept(builder);
        return fromPluginConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pluginConfiguration", PLUGIN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatModeConfiguration, T> g) {
        return obj -> g.apply((ChatModeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatModeConfiguration> {
        /**
         * <p>
         * Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
         * </p>
         * 
         * @param pluginConfiguration
         *        Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginConfiguration(PluginConfiguration pluginConfiguration);

        /**
         * <p>
         * Configuration information required to invoke chat in <code>PLUGIN_MODE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginConfiguration.Builder} avoiding the
         * need to create one manually via {@link PluginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #pluginConfiguration(PluginConfiguration)}.
         * 
         * @param pluginConfiguration
         *        a consumer that will call methods on {@link PluginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pluginConfiguration(PluginConfiguration)
         */
        default Builder pluginConfiguration(Consumer<PluginConfiguration.Builder> pluginConfiguration) {
            return pluginConfiguration(PluginConfiguration.builder().applyMutation(pluginConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PluginConfiguration pluginConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChatModeConfiguration model) {
            pluginConfiguration(model.pluginConfiguration);
        }

        public final PluginConfiguration.Builder getPluginConfiguration() {
            return pluginConfiguration != null ? pluginConfiguration.toBuilder() : null;
        }

        public final void setPluginConfiguration(PluginConfiguration.BuilderImpl pluginConfiguration) {
            Object oldValue = this.pluginConfiguration;
            this.pluginConfiguration = pluginConfiguration != null ? pluginConfiguration.build() : null;
            handleUnionValueChange(Type.PLUGIN_CONFIGURATION, oldValue, this.pluginConfiguration);
        }

        @Override
        public final Builder pluginConfiguration(PluginConfiguration pluginConfiguration) {
            Object oldValue = this.pluginConfiguration;
            this.pluginConfiguration = pluginConfiguration;
            handleUnionValueChange(Type.PLUGIN_CONFIGURATION, oldValue, this.pluginConfiguration);
            return this;
        }

        @Override
        public ChatModeConfiguration build() {
            return new ChatModeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ChatModeConfiguration#type()
     */
    public enum Type {
        PLUGIN_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
