/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for audio content extraction and processing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioExtractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioExtractionConfiguration.Builder, AudioExtractionConfiguration> {
    private static final SdkField<String> AUDIO_EXTRACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audioExtractionStatus").getter(getter(AudioExtractionConfiguration::audioExtractionStatusAsString))
            .setter(setter(Builder::audioExtractionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioExtractionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUDIO_EXTRACTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String audioExtractionStatus;

    private AudioExtractionConfiguration(BuilderImpl builder) {
        this.audioExtractionStatus = builder.audioExtractionStatus;
    }

    /**
     * <p>
     * The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioExtractionStatus} will return {@link AudioExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioExtractionStatusAsString}.
     * </p>
     * 
     * @return The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
     * @see AudioExtractionStatus
     */
    public final AudioExtractionStatus audioExtractionStatus() {
        return AudioExtractionStatus.fromValue(audioExtractionStatus);
    }

    /**
     * <p>
     * The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioExtractionStatus} will return {@link AudioExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioExtractionStatusAsString}.
     * </p>
     * 
     * @return The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
     * @see AudioExtractionStatus
     */
    public final String audioExtractionStatusAsString() {
        return audioExtractionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioExtractionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioExtractionConfiguration)) {
            return false;
        }
        AudioExtractionConfiguration other = (AudioExtractionConfiguration) obj;
        return Objects.equals(audioExtractionStatusAsString(), other.audioExtractionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioExtractionConfiguration").add("AudioExtractionStatus", audioExtractionStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioExtractionStatus":
            return Optional.ofNullable(clazz.cast(audioExtractionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioExtractionStatus", AUDIO_EXTRACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioExtractionConfiguration, T> g) {
        return obj -> g.apply((AudioExtractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioExtractionConfiguration> {
        /**
         * <p>
         * The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
         * </p>
         * 
         * @param audioExtractionStatus
         *        The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
         * @see AudioExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioExtractionStatus
         */
        Builder audioExtractionStatus(String audioExtractionStatus);

        /**
         * <p>
         * The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
         * </p>
         * 
         * @param audioExtractionStatus
         *        The status of audio extraction (ENABLED or DISABLED) for processing audio content from files.
         * @see AudioExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioExtractionStatus
         */
        Builder audioExtractionStatus(AudioExtractionStatus audioExtractionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String audioExtractionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioExtractionConfiguration model) {
            audioExtractionStatus(model.audioExtractionStatus);
        }

        public final String getAudioExtractionStatus() {
            return audioExtractionStatus;
        }

        public final void setAudioExtractionStatus(String audioExtractionStatus) {
            this.audioExtractionStatus = audioExtractionStatus;
        }

        @Override
        public final Builder audioExtractionStatus(String audioExtractionStatus) {
            this.audioExtractionStatus = audioExtractionStatus;
            return this;
        }

        @Override
        public final Builder audioExtractionStatus(AudioExtractionStatus audioExtractionStatus) {
            this.audioExtractionStatus(audioExtractionStatus == null ? null : audioExtractionStatus.toString());
            return this;
        }

        @Override
        public AudioExtractionConfiguration build() {
            return new AudioExtractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
