/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A file input event activated by a end user request to upload files into their web experience chat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachmentInputEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentInputEvent.Builder, AttachmentInputEvent>, ChatInputStream {
    private static final SdkField<AttachmentInput> ATTACHMENT_FIELD = SdkField
            .<AttachmentInput> builder(MarshallingType.SDK_POJO).memberName("attachment")
            .getter(getter(AttachmentInputEvent::attachment)).setter(setter(Builder::attachment))
            .constructor(AttachmentInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttachmentInput attachment;

    protected AttachmentInputEvent(BuilderImpl builder) {
        this.attachment = builder.attachment;
    }

    /**
     * Returns the value of the Attachment property for this object.
     * 
     * @return The value of the Attachment property for this object.
     */
    public final AttachmentInput attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentInputEvent)) {
            return false;
        }
        AttachmentInputEvent other = (AttachmentInputEvent) obj;
        return Objects.equals(attachment(), other.attachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachmentInputEvent").add("Attachment", attachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final AttachmentInputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachment", ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachmentInputEvent, T> g) {
        return obj -> g.apply((AttachmentInputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentInputEvent> {
        /**
         * Sets the value of the Attachment property for this object.
         *
         * @param attachment
         *        The new value for the Attachment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(AttachmentInput attachment);

        /**
         * Sets the value of the Attachment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AttachmentInput.Builder} avoiding the
         * need to create one manually via {@link AttachmentInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentInput.Builder#build()} is called immediately and its
         * result is passed to {@link #attachment(AttachmentInput)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link AttachmentInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(AttachmentInput)
         */
        default Builder attachment(Consumer<AttachmentInput.Builder> attachment) {
            return attachment(AttachmentInput.builder().applyMutation(attachment).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private AttachmentInput attachment;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AttachmentInputEvent model) {
            attachment(model.attachment);
        }

        public final AttachmentInput.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentInput.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(AttachmentInput attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public AttachmentInputEvent build() {
            return new AttachmentInputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
