/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePermissionRequest extends QBusinessRequest implements
        ToCopyableBuilder<AssociatePermissionRequest.Builder, AssociatePermissionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(AssociatePermissionRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(AssociatePermissionRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(AssociatePermissionRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PermissionCondition>> CONDITIONS_FIELD = SdkField
            .<List<PermissionCondition>> builder(MarshallingType.LIST)
            .memberName("conditions")
            .getter(getter(AssociatePermissionRequest::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(AssociatePermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            STATEMENT_ID_FIELD, ACTIONS_FIELD, CONDITIONS_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String statementId;

    private final List<String> actions;

    private final List<PermissionCondition> conditions;

    private final String principal;

    private AssociatePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.statementId = builder.statementId;
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A unique identifier for the policy statement.
     * </p>
     * 
     * @return A unique identifier for the policy statement.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Q Business actions that the ISV is allowed to perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The list of Amazon Q Business actions that the ISV is allowed to perform.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions that restrict when the permission is effective. These conditions can be used to limit the
     * permission based on specific attributes of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return The conditions that restrict when the permission is effective. These conditions can be used to limit the
     *         permission based on specific attributes of the request.
     */
    public final List<PermissionCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * The Amazon Resource Name of the IAM role for the ISV that is being granted permission.
     * </p>
     * 
     * @return The Amazon Resource Name of the IAM role for the ISV that is being granted permission.
     */
    public final String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePermissionRequest)) {
            return false;
        }
        AssociatePermissionRequest other = (AssociatePermissionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(statementId(), other.statementId())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions())
                && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePermissionRequest").add("ApplicationId", applicationId())
                .add("StatementId", statementId()).add("Actions", hasActions() ? actions() : null)
                .add("Conditions", hasConditions() ? conditions() : null).add("Principal", principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatePermissionRequest, T> g) {
        return obj -> g.apply((AssociatePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociatePermissionRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A unique identifier for the policy statement.
         * </p>
         * 
         * @param statementId
         *        A unique identifier for the policy statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * The list of Amazon Q Business actions that the ISV is allowed to perform.
         * </p>
         * 
         * @param actions
         *        The list of Amazon Q Business actions that the ISV is allowed to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The list of Amazon Q Business actions that the ISV is allowed to perform.
         * </p>
         * 
         * @param actions
         *        The list of Amazon Q Business actions that the ISV is allowed to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * The conditions that restrict when the permission is effective. These conditions can be used to limit the
         * permission based on specific attributes of the request.
         * </p>
         * 
         * @param conditions
         *        The conditions that restrict when the permission is effective. These conditions can be used to limit
         *        the permission based on specific attributes of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<PermissionCondition> conditions);

        /**
         * <p>
         * The conditions that restrict when the permission is effective. These conditions can be used to limit the
         * permission based on specific attributes of the request.
         * </p>
         * 
         * @param conditions
         *        The conditions that restrict when the permission is effective. These conditions can be used to limit
         *        the permission based on specific attributes of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(PermissionCondition... conditions);

        /**
         * <p>
         * The conditions that restrict when the permission is effective. These conditions can be used to limit the
         * permission based on specific attributes of the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.PermissionCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.PermissionCondition#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.PermissionCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<PermissionCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.PermissionCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<PermissionCondition>)
         */
        Builder conditions(Consumer<PermissionCondition.Builder>... conditions);

        /**
         * <p>
         * The Amazon Resource Name of the IAM role for the ISV that is being granted permission.
         * </p>
         * 
         * @param principal
         *        The Amazon Resource Name of the IAM role for the ISV that is being granted permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String statementId;

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private List<PermissionCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePermissionRequest model) {
            super(model);
            applicationId(model.applicationId);
            statementId(model.statementId);
            actions(model.actions);
            conditions(model.conditions);
            principal(model.principal);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = QIamActionsCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = QIamActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final List<PermissionCondition.Builder> getConditions() {
            List<PermissionCondition.Builder> result = PermissionConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<PermissionCondition.BuilderImpl> conditions) {
            this.conditions = PermissionConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<PermissionCondition> conditions) {
            this.conditions = PermissionConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(PermissionCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<PermissionCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> PermissionCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePermissionRequest build() {
            return new AssociatePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
