/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A user input field in an plugin action review payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionReviewPayloadField implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionReviewPayloadField.Builder, ActionReviewPayloadField> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ActionReviewPayloadField::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("displayOrder").getter(getter(ActionReviewPayloadField::displayOrder))
            .setter(setter(Builder::displayOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayOrder").build()).build();

    private static final SdkField<String> DISPLAY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayDescription").getter(getter(ActionReviewPayloadField::displayDescription))
            .setter(setter(Builder::displayDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayDescription").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ActionReviewPayloadField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Document> VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("value").getter(getter(ActionReviewPayloadField::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<ActionReviewPayloadFieldAllowedValue>> ALLOWED_VALUES_FIELD = SdkField
            .<List<ActionReviewPayloadFieldAllowedValue>> builder(MarshallingType.LIST)
            .memberName("allowedValues")
            .getter(getter(ActionReviewPayloadField::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionReviewPayloadFieldAllowedValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionReviewPayloadFieldAllowedValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOWED_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allowedFormat").getter(getter(ActionReviewPayloadField::allowedFormat))
            .setter(setter(Builder::allowedFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFormat").build()).build();

    private static final SdkField<Document> ARRAY_ITEM_JSON_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("arrayItemJsonSchema").getter(getter(ActionReviewPayloadField::arrayItemJsonSchema))
            .setter(setter(Builder::arrayItemJsonSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayItemJsonSchema").build())
            .build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(ActionReviewPayloadField::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            DISPLAY_ORDER_FIELD, DISPLAY_DESCRIPTION_FIELD, TYPE_FIELD, VALUE_FIELD, ALLOWED_VALUES_FIELD, ALLOWED_FORMAT_FIELD,
            ARRAY_ITEM_JSON_SCHEMA_FIELD, REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final Integer displayOrder;

    private final String displayDescription;

    private final String type;

    private final Document value;

    private final List<ActionReviewPayloadFieldAllowedValue> allowedValues;

    private final String allowedFormat;

    private final Document arrayItemJsonSchema;

    private final Boolean required;

    private ActionReviewPayloadField(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.displayOrder = builder.displayOrder;
        this.displayDescription = builder.displayDescription;
        this.type = builder.type;
        this.value = builder.value;
        this.allowedValues = builder.allowedValues;
        this.allowedFormat = builder.allowedFormat;
        this.arrayItemJsonSchema = builder.arrayItemJsonSchema;
        this.required = builder.required;
    }

    /**
     * <p>
     * The name of the field.
     * </p>
     * 
     * @return The name of the field.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The display order of fields in a payload.
     * </p>
     * 
     * @return The display order of fields in a payload.
     */
    public final Integer displayOrder() {
        return displayOrder;
    }

    /**
     * <p>
     * The field level description of each action review input field. This could be an explanation of the field. In the
     * Amazon Q Business web experience, these descriptions could be used to display as tool tips to help users
     * understand the field.
     * </p>
     * 
     * @return The field level description of each action review input field. This could be an explanation of the field.
     *         In the Amazon Q Business web experience, these descriptions could be used to display as tool tips to help
     *         users understand the field.
     */
    public final String displayDescription() {
        return displayDescription;
    }

    /**
     * <p>
     * The type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionPayloadFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of field.
     * @see ActionPayloadFieldType
     */
    public final ActionPayloadFieldType type() {
        return ActionPayloadFieldType.fromValue(type);
    }

    /**
     * <p>
     * The type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionPayloadFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of field.
     * @see ActionPayloadFieldType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The field value.
     * </p>
     * 
     * @return The field value.
     */
    public final Document value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q Business
     * to perform the requested plugin action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q
     *         Business to perform the requested plugin action.
     */
    public final List<ActionReviewPayloadFieldAllowedValue> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * The expected data format for the action review input field value. For example, in PTO request, <code>from</code>
     * and <code>to</code> would be of <code>datetime</code> allowed format.
     * </p>
     * 
     * @return The expected data format for the action review input field value. For example, in PTO request,
     *         <code>from</code> and <code>to</code> would be of <code>datetime</code> allowed format.
     */
    public final String allowedFormat() {
        return allowedFormat;
    }

    /**
     * <p>
     * Use to create a custom form with array fields (fields with nested objects inside an array).
     * </p>
     * 
     * @return Use to create a custom form with array fields (fields with nested objects inside an array).
     */
    public final Document arrayItemJsonSchema() {
        return arrayItemJsonSchema;
    }

    /**
     * <p>
     * Information about whether the field is required.
     * </p>
     * 
     * @return Information about whether the field is required.
     */
    public final Boolean required() {
        return required;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(displayDescription());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedFormat());
        hashCode = 31 * hashCode + Objects.hashCode(arrayItemJsonSchema());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReviewPayloadField)) {
            return false;
        }
        ActionReviewPayloadField other = (ActionReviewPayloadField) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(displayOrder(), other.displayOrder())
                && Objects.equals(displayDescription(), other.displayDescription())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value())
                && hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(allowedFormat(), other.allowedFormat())
                && Objects.equals(arrayItemJsonSchema(), other.arrayItemJsonSchema())
                && Objects.equals(required(), other.required());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionReviewPayloadField").add("DisplayName", displayName()).add("DisplayOrder", displayOrder())
                .add("DisplayDescription", displayDescription()).add("Type", typeAsString()).add("Value", value())
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null).add("AllowedFormat", allowedFormat())
                .add("ArrayItemJsonSchema", arrayItemJsonSchema()).add("Required", required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "displayOrder":
            return Optional.ofNullable(clazz.cast(displayOrder()));
        case "displayDescription":
            return Optional.ofNullable(clazz.cast(displayDescription()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "allowedFormat":
            return Optional.ofNullable(clazz.cast(allowedFormat()));
        case "arrayItemJsonSchema":
            return Optional.ofNullable(clazz.cast(arrayItemJsonSchema()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("displayOrder", DISPLAY_ORDER_FIELD);
        map.put("displayDescription", DISPLAY_DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("allowedValues", ALLOWED_VALUES_FIELD);
        map.put("allowedFormat", ALLOWED_FORMAT_FIELD);
        map.put("arrayItemJsonSchema", ARRAY_ITEM_JSON_SCHEMA_FIELD);
        map.put("required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionReviewPayloadField, T> g) {
        return obj -> g.apply((ActionReviewPayloadField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionReviewPayloadField> {
        /**
         * <p>
         * The name of the field.
         * </p>
         * 
         * @param displayName
         *        The name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The display order of fields in a payload.
         * </p>
         * 
         * @param displayOrder
         *        The display order of fields in a payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOrder(Integer displayOrder);

        /**
         * <p>
         * The field level description of each action review input field. This could be an explanation of the field. In
         * the Amazon Q Business web experience, these descriptions could be used to display as tool tips to help users
         * understand the field.
         * </p>
         * 
         * @param displayDescription
         *        The field level description of each action review input field. This could be an explanation of the
         *        field. In the Amazon Q Business web experience, these descriptions could be used to display as tool
         *        tips to help users understand the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayDescription(String displayDescription);

        /**
         * <p>
         * The type of field.
         * </p>
         * 
         * @param type
         *        The type of field.
         * @see ActionPayloadFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionPayloadFieldType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of field.
         * </p>
         * 
         * @param type
         *        The type of field.
         * @see ActionPayloadFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionPayloadFieldType
         */
        Builder type(ActionPayloadFieldType type);

        /**
         * <p>
         * The field value.
         * </p>
         * 
         * @param value
         *        The field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Document value);

        /**
         * <p>
         * Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q
         * Business to perform the requested plugin action.
         * </p>
         * 
         * @param allowedValues
         *        Information about the field values that an end user can use to provide to Amazon Q Business for Amazon
         *        Q Business to perform the requested plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<ActionReviewPayloadFieldAllowedValue> allowedValues);

        /**
         * <p>
         * Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q
         * Business to perform the requested plugin action.
         * </p>
         * 
         * @param allowedValues
         *        Information about the field values that an end user can use to provide to Amazon Q Business for Amazon
         *        Q Business to perform the requested plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(ActionReviewPayloadFieldAllowedValue... allowedValues);

        /**
         * <p>
         * Information about the field values that an end user can use to provide to Amazon Q Business for Amazon Q
         * Business to perform the requested plugin action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValue.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValue.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #allowedValues(List<ActionReviewPayloadFieldAllowedValue>)}.
         * 
         * @param allowedValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedValues(java.util.Collection<ActionReviewPayloadFieldAllowedValue>)
         */
        Builder allowedValues(Consumer<ActionReviewPayloadFieldAllowedValue.Builder>... allowedValues);

        /**
         * <p>
         * The expected data format for the action review input field value. For example, in PTO request,
         * <code>from</code> and <code>to</code> would be of <code>datetime</code> allowed format.
         * </p>
         * 
         * @param allowedFormat
         *        The expected data format for the action review input field value. For example, in PTO request,
         *        <code>from</code> and <code>to</code> would be of <code>datetime</code> allowed format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFormat(String allowedFormat);

        /**
         * <p>
         * Use to create a custom form with array fields (fields with nested objects inside an array).
         * </p>
         * 
         * @param arrayItemJsonSchema
         *        Use to create a custom form with array fields (fields with nested objects inside an array).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayItemJsonSchema(Document arrayItemJsonSchema);

        /**
         * <p>
         * Information about whether the field is required.
         * </p>
         * 
         * @param required
         *        Information about whether the field is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private Integer displayOrder;

        private String displayDescription;

        private String type;

        private Document value;

        private List<ActionReviewPayloadFieldAllowedValue> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private String allowedFormat;

        private Document arrayItemJsonSchema;

        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionReviewPayloadField model) {
            displayName(model.displayName);
            displayOrder(model.displayOrder);
            displayDescription(model.displayDescription);
            type(model.type);
            value(model.value);
            allowedValues(model.allowedValues);
            allowedFormat(model.allowedFormat);
            arrayItemJsonSchema(model.arrayItemJsonSchema);
            required(model.required);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Integer getDisplayOrder() {
            return displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final String getDisplayDescription() {
            return displayDescription;
        }

        public final void setDisplayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
        }

        @Override
        public final Builder displayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionPayloadFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Document getValue() {
            return value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final List<ActionReviewPayloadFieldAllowedValue.Builder> getAllowedValues() {
            List<ActionReviewPayloadFieldAllowedValue.Builder> result = ActionReviewPayloadFieldAllowedValuesCopier
                    .copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<ActionReviewPayloadFieldAllowedValue.BuilderImpl> allowedValues) {
            this.allowedValues = ActionReviewPayloadFieldAllowedValuesCopier.copyFromBuilder(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<ActionReviewPayloadFieldAllowedValue> allowedValues) {
            this.allowedValues = ActionReviewPayloadFieldAllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(ActionReviewPayloadFieldAllowedValue... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(Consumer<ActionReviewPayloadFieldAllowedValue.Builder>... allowedValues) {
            allowedValues(Stream.of(allowedValues)
                    .map(c -> ActionReviewPayloadFieldAllowedValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAllowedFormat() {
            return allowedFormat;
        }

        public final void setAllowedFormat(String allowedFormat) {
            this.allowedFormat = allowedFormat;
        }

        @Override
        public final Builder allowedFormat(String allowedFormat) {
            this.allowedFormat = allowedFormat;
            return this;
        }

        public final Document getArrayItemJsonSchema() {
            return arrayItemJsonSchema;
        }

        public final void setArrayItemJsonSchema(Document arrayItemJsonSchema) {
            this.arrayItemJsonSchema = arrayItemJsonSchema;
        }

        @Override
        public final Builder arrayItemJsonSchema(Document arrayItemJsonSchema) {
            this.arrayItemJsonSchema = arrayItemJsonSchema;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public ActionReviewPayloadField build() {
            return new ActionReviewPayloadField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
