/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies filters to apply to an allowed action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionFilterConfiguration.Builder, ActionFilterConfiguration> {
    private static final SdkField<AttributeFilter> DOCUMENT_ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("documentAttributeFilter")
            .getter(getter(ActionFilterConfiguration::documentAttributeFilter)).setter(setter(Builder::documentAttributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributeFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOCUMENT_ATTRIBUTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttributeFilter documentAttributeFilter;

    private ActionFilterConfiguration(BuilderImpl builder) {
        this.documentAttributeFilter = builder.documentAttributeFilter;
    }

    /**
     * Returns the value of the DocumentAttributeFilter property for this object.
     * 
     * @return The value of the DocumentAttributeFilter property for this object.
     */
    public final AttributeFilter documentAttributeFilter() {
        return documentAttributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionFilterConfiguration)) {
            return false;
        }
        ActionFilterConfiguration other = (ActionFilterConfiguration) obj;
        return Objects.equals(documentAttributeFilter(), other.documentAttributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionFilterConfiguration").add("DocumentAttributeFilter", documentAttributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentAttributeFilter":
            return Optional.ofNullable(clazz.cast(documentAttributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentAttributeFilter", DOCUMENT_ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionFilterConfiguration, T> g) {
        return obj -> g.apply((ActionFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionFilterConfiguration> {
        /**
         * Sets the value of the DocumentAttributeFilter property for this object.
         *
         * @param documentAttributeFilter
         *        The new value for the DocumentAttributeFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeFilter(AttributeFilter documentAttributeFilter);

        /**
         * Sets the value of the DocumentAttributeFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #documentAttributeFilter(AttributeFilter)}.
         * 
         * @param documentAttributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeFilter(AttributeFilter)
         */
        default Builder documentAttributeFilter(Consumer<AttributeFilter.Builder> documentAttributeFilter) {
            return documentAttributeFilter(AttributeFilter.builder().applyMutation(documentAttributeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeFilter documentAttributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionFilterConfiguration model) {
            documentAttributeFilter(model.documentAttributeFilter);
        }

        public final AttributeFilter.Builder getDocumentAttributeFilter() {
            return documentAttributeFilter != null ? documentAttributeFilter.toBuilder() : null;
        }

        public final void setDocumentAttributeFilter(AttributeFilter.BuilderImpl documentAttributeFilter) {
            this.documentAttributeFilter = documentAttributeFilter != null ? documentAttributeFilter.build() : null;
        }

        @Override
        public final Builder documentAttributeFilter(AttributeFilter documentAttributeFilter) {
            this.documentAttributeFilter = documentAttributeFilter;
            return this;
        }

        @Override
        public ActionFilterConfiguration build() {
            return new ActionFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
