/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ActionSummary;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse;

public class ListPluginActionsIterable
implements SdkIterable<ListPluginActionsResponse> {
    private final QBusinessClient client;
    private final ListPluginActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPluginActionsIterable(QBusinessClient client, ListPluginActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPluginActionsResponseFetcher();
    }

    public Iterator<ListPluginActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionSummary> items() {
        Function<ListPluginActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPluginActionsResponseFetcher
    implements SyncPageFetcher<ListPluginActionsResponse> {
        private ListPluginActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPluginActionsResponse nextPage(ListPluginActionsResponse previousPage) {
            if (previousPage == null) {
                return ListPluginActionsIterable.this.client.listPluginActions(ListPluginActionsIterable.this.firstRequest);
            }
            return ListPluginActionsIterable.this.client.listPluginActions((ListPluginActionsRequest)((Object)ListPluginActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

