/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.SamlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebExperienceAuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebExperienceAuthConfiguration> {
    private static final SdkField<SamlConfiguration> SAML_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlConfiguration").getter(WebExperienceAuthConfiguration.getter(WebExperienceAuthConfiguration::samlConfiguration)).setter(WebExperienceAuthConfiguration.setter(Builder::samlConfiguration)).constructor(SamlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebExperienceAuthConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SamlConfiguration samlConfiguration;
    private final Type type;

    private WebExperienceAuthConfiguration(BuilderImpl builder) {
        this.samlConfiguration = builder.samlConfiguration;
        this.type = builder.type;
    }

    public final SamlConfiguration samlConfiguration() {
        return this.samlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebExperienceAuthConfiguration)) {
            return false;
        }
        WebExperienceAuthConfiguration other = (WebExperienceAuthConfiguration)obj;
        return Objects.equals(this.samlConfiguration(), other.samlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"WebExperienceAuthConfiguration").add("SamlConfiguration", (Object)this.samlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.samlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static WebExperienceAuthConfiguration fromSamlConfiguration(SamlConfiguration samlConfiguration) {
        return (WebExperienceAuthConfiguration)WebExperienceAuthConfiguration.builder().samlConfiguration(samlConfiguration).build();
    }

    public static WebExperienceAuthConfiguration fromSamlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
        SamlConfiguration.Builder builder = SamlConfiguration.builder();
        samlConfiguration.accept(builder);
        return WebExperienceAuthConfiguration.fromSamlConfiguration((SamlConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SamlConfiguration>> map = new HashMap<String, SdkField<SamlConfiguration>>();
        map.put("samlConfiguration", SAML_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebExperienceAuthConfiguration, T> g) {
        return obj -> g.apply((WebExperienceAuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SAML_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SamlConfiguration samlConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WebExperienceAuthConfiguration model) {
            this.samlConfiguration(model.samlConfiguration);
        }

        public final SamlConfiguration.Builder getSamlConfiguration() {
            return this.samlConfiguration != null ? this.samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlConfiguration.BuilderImpl samlConfiguration) {
            SamlConfiguration oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
            this.handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
        }

        @Override
        public final Builder samlConfiguration(SamlConfiguration samlConfiguration) {
            SamlConfiguration oldValue = this.samlConfiguration;
            this.samlConfiguration = samlConfiguration;
            this.handleUnionValueChange(Type.SAML_CONFIGURATION, oldValue, this.samlConfiguration);
            return this;
        }

        public WebExperienceAuthConfiguration build() {
            return new WebExperienceAuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebExperienceAuthConfiguration> {
        public Builder samlConfiguration(SamlConfiguration var1);

        default public Builder samlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
            return this.samlConfiguration((SamlConfiguration)((SamlConfiguration.Builder)SamlConfiguration.builder().applyMutation(samlConfiguration)).build());
        }
    }
}

