/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWebExperienceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, DeleteWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(DeleteWebExperienceRequest.getter(DeleteWebExperienceRequest::applicationId)).setter(DeleteWebExperienceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webExperienceId").getter(DeleteWebExperienceRequest.getter(DeleteWebExperienceRequest::webExperienceId)).setter(DeleteWebExperienceRequest.setter(Builder::webExperienceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("webExperienceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, WEB_EXPERIENCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteWebExperienceRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String webExperienceId;

    private DeleteWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.webExperienceId = builder.webExperienceId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String webExperienceId() {
        return this.webExperienceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webExperienceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWebExperienceRequest)) {
            return false;
        }
        DeleteWebExperienceRequest other = (DeleteWebExperienceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.webExperienceId(), other.webExperienceId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWebExperienceRequest").add("ApplicationId", (Object)this.applicationId()).add("WebExperienceId", (Object)this.webExperienceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "webExperienceId": {
                return Optional.ofNullable(clazz.cast(this.webExperienceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("webExperienceId", WEB_EXPERIENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWebExperienceRequest, T> g) {
        return obj -> g.apply((DeleteWebExperienceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String webExperienceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWebExperienceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.webExperienceId(model.webExperienceId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getWebExperienceId() {
            return this.webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWebExperienceRequest build() {
            return new DeleteWebExperienceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWebExperienceRequest> {
        public Builder applicationId(String var1);

        public Builder webExperienceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

