/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.MemberRelation;
import software.amazon.awssdk.services.qbusiness.model.Principal;
import software.amazon.awssdk.services.qbusiness.model.PrincipalsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessControl> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principals").getter(AccessControl.getter(AccessControl::principals)).setter(AccessControl.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberRelation").getter(AccessControl.getter(AccessControl::memberRelationAsString)).setter(AccessControl.setter(Builder::memberRelation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD, MEMBER_RELATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessControl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Principal> principals;
    private final String memberRelation;

    private AccessControl(BuilderImpl builder) {
        this.principals = builder.principals;
        this.memberRelation = builder.memberRelation;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<Principal> principals() {
        return this.principals;
    }

    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(this.memberRelation);
    }

    public final String memberRelationAsString() {
        return this.memberRelation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRelationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControl)) {
            return false;
        }
        AccessControl other = (AccessControl)obj;
        return this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.memberRelationAsString(), other.memberRelationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessControl").add("Principals", this.hasPrincipals() ? this.principals() : null).add("MemberRelation", (Object)this.memberRelationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "memberRelation": {
                return Optional.ofNullable(clazz.cast(this.memberRelationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("principals", PRINCIPALS_FIELD);
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessControl, T> g) {
        return obj -> g.apply((AccessControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();
        private String memberRelation;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControl model) {
            this.principals(model.principals);
            this.memberRelation(model.memberRelation);
        }

        public final List<Principal.Builder> getPrincipals() {
            List<Principal.Builder> result = PrincipalsCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalsCopier.copyFromBuilder(principals);
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMemberRelation() {
            return this.memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public AccessControl build() {
            return new AccessControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessControl> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder principals(Consumer<Principal.Builder> ... var1);

        public Builder memberRelation(String var1);

        public Builder memberRelation(MemberRelation var1);
    }
}

