/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJobMetrics;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJobStatus;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceSyncJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceSyncJob> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(DataSourceSyncJob.getter(DataSourceSyncJob::executionId)).setter(DataSourceSyncJob.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DataSourceSyncJob.getter(DataSourceSyncJob::startTime)).setter(DataSourceSyncJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DataSourceSyncJob.getter(DataSourceSyncJob::endTime)).setter(DataSourceSyncJob.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataSourceSyncJob.getter(DataSourceSyncJob::statusAsString)).setter(DataSourceSyncJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(DataSourceSyncJob.getter(DataSourceSyncJob::error)).setter(DataSourceSyncJob.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceErrorCode").getter(DataSourceSyncJob.getter(DataSourceSyncJob::dataSourceErrorCode)).setter(DataSourceSyncJob.setter(Builder::dataSourceErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceErrorCode").build()}).build();
    private static final SdkField<DataSourceSyncJobMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(DataSourceSyncJob.getter(DataSourceSyncJob::metrics)).setter(DataSourceSyncJob.setter(Builder::metrics)).constructor(DataSourceSyncJobMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ERROR_FIELD, DATA_SOURCE_ERROR_CODE_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceSyncJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final ErrorDetail error;
    private final String dataSourceErrorCode;
    private final DataSourceSyncJobMetrics metrics;

    private DataSourceSyncJob(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.error = builder.error;
        this.dataSourceErrorCode = builder.dataSourceErrorCode;
        this.metrics = builder.metrics;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final DataSourceSyncJobStatus status() {
        return DataSourceSyncJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final String dataSourceErrorCode() {
        return this.dataSourceErrorCode;
    }

    public final DataSourceSyncJobMetrics metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJob)) {
            return false;
        }
        DataSourceSyncJob other = (DataSourceSyncJob)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.dataSourceErrorCode(), other.dataSourceErrorCode()) && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceSyncJob").add("ExecutionId", (Object)this.executionId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("Error", (Object)this.error()).add("DataSourceErrorCode", (Object)this.dataSourceErrorCode()).add("Metrics", (Object)this.metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "dataSourceErrorCode": {
                return Optional.ofNullable(clazz.cast(this.dataSourceErrorCode()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("dataSourceErrorCode", DATA_SOURCE_ERROR_CODE_FIELD);
        map.put("metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJob, T> g) {
        return obj -> g.apply((DataSourceSyncJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private ErrorDetail error;
        private String dataSourceErrorCode;
        private DataSourceSyncJobMetrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJob model) {
            this.executionId(model.executionId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.error(model.error);
            this.dataSourceErrorCode(model.dataSourceErrorCode);
            this.metrics(model.metrics);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceSyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final String getDataSourceErrorCode() {
            return this.dataSourceErrorCode;
        }

        public final void setDataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
        }

        @Override
        public final Builder dataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
            return this;
        }

        public final DataSourceSyncJobMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(DataSourceSyncJobMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(DataSourceSyncJobMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public DataSourceSyncJob build() {
            return new DataSourceSyncJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceSyncJob> {
        public Builder executionId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(DataSourceSyncJobStatus var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder dataSourceErrorCode(String var1);

        public Builder metrics(DataSourceSyncJobMetrics var1);

        default public Builder metrics(Consumer<DataSourceSyncJobMetrics.Builder> metrics) {
            return this.metrics((DataSourceSyncJobMetrics)((DataSourceSyncJobMetrics.Builder)DataSourceSyncJobMetrics.builder().applyMutation(metrics)).build());
        }
    }
}

