/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.BrowserExtension;
import software.amazon.awssdk.services.qbusiness.model.BrowserExtensionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrowserExtensionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrowserExtensionConfiguration> {
    private static final SdkField<List<String>> ENABLED_BROWSER_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("enabledBrowserExtensions").getter(BrowserExtensionConfiguration.getter(BrowserExtensionConfiguration::enabledBrowserExtensionsAsStrings)).setter(BrowserExtensionConfiguration.setter(Builder::enabledBrowserExtensionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBrowserExtensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_BROWSER_EXTENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrowserExtensionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> enabledBrowserExtensions;

    private BrowserExtensionConfiguration(BuilderImpl builder) {
        this.enabledBrowserExtensions = builder.enabledBrowserExtensions;
    }

    public final List<BrowserExtension> enabledBrowserExtensions() {
        return BrowserExtensionListCopier.copyStringToEnum(this.enabledBrowserExtensions);
    }

    public final boolean hasEnabledBrowserExtensions() {
        return this.enabledBrowserExtensions != null && !(this.enabledBrowserExtensions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledBrowserExtensionsAsStrings() {
        return this.enabledBrowserExtensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledBrowserExtensions() ? this.enabledBrowserExtensionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserExtensionConfiguration)) {
            return false;
        }
        BrowserExtensionConfiguration other = (BrowserExtensionConfiguration)obj;
        return this.hasEnabledBrowserExtensions() == other.hasEnabledBrowserExtensions() && Objects.equals(this.enabledBrowserExtensionsAsStrings(), other.enabledBrowserExtensionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BrowserExtensionConfiguration").add("EnabledBrowserExtensions", this.hasEnabledBrowserExtensions() ? this.enabledBrowserExtensionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabledBrowserExtensions": {
                return Optional.ofNullable(clazz.cast(this.enabledBrowserExtensionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("enabledBrowserExtensions", ENABLED_BROWSER_EXTENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrowserExtensionConfiguration, T> g) {
        return obj -> g.apply((BrowserExtensionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> enabledBrowserExtensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserExtensionConfiguration model) {
            this.enabledBrowserExtensionsWithStrings(model.enabledBrowserExtensions);
        }

        public final Collection<String> getEnabledBrowserExtensions() {
            if (this.enabledBrowserExtensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledBrowserExtensions;
        }

        public final void setEnabledBrowserExtensions(Collection<String> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copy(enabledBrowserExtensions);
        }

        @Override
        public final Builder enabledBrowserExtensionsWithStrings(Collection<String> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copy(enabledBrowserExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBrowserExtensionsWithStrings(String ... enabledBrowserExtensions) {
            this.enabledBrowserExtensionsWithStrings(Arrays.asList(enabledBrowserExtensions));
            return this;
        }

        @Override
        public final Builder enabledBrowserExtensions(Collection<BrowserExtension> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copyEnumToString(enabledBrowserExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBrowserExtensions(BrowserExtension ... enabledBrowserExtensions) {
            this.enabledBrowserExtensions(Arrays.asList(enabledBrowserExtensions));
            return this;
        }

        public BrowserExtensionConfiguration build() {
            return new BrowserExtensionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrowserExtensionConfiguration> {
        public Builder enabledBrowserExtensionsWithStrings(Collection<String> var1);

        public Builder enabledBrowserExtensionsWithStrings(String ... var1);

        public Builder enabledBrowserExtensions(Collection<BrowserExtension> var1);

        public Builder enabledBrowserExtensions(BrowserExtension ... var1);
    }
}

