/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionExecution;
import software.amazon.awssdk.services.qbusiness.model.AttachmentInput;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsInputCopier;
import software.amazon.awssdk.services.qbusiness.model.AttributeFilter;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeResponse;
import software.amazon.awssdk.services.qbusiness.model.ChatMode;
import software.amazon.awssdk.services.qbusiness.model.ChatModeConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.UserGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatSyncRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, ChatSyncRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ChatSyncRequest.getter(ChatSyncRequest::applicationId)).setter(ChatSyncRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ChatSyncRequest.getter(ChatSyncRequest::userId)).setter(ChatSyncRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userGroups").getter(ChatSyncRequest.getter(ChatSyncRequest::userGroups)).setter(ChatSyncRequest.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessage").getter(ChatSyncRequest.getter(ChatSyncRequest::userMessage)).setter(ChatSyncRequest.setter(Builder::userMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessage").build()}).build();
    private static final SdkField<List<AttachmentInput>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(ChatSyncRequest.getter(ChatSyncRequest::attachments)).setter(ChatSyncRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ActionExecution> ACTION_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionExecution").getter(ChatSyncRequest.getter(ChatSyncRequest::actionExecution)).setter(ChatSyncRequest.setter(Builder::actionExecution)).constructor(ActionExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecution").build()}).build();
    private static final SdkField<AuthChallengeResponse> AUTH_CHALLENGE_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authChallengeResponse").getter(ChatSyncRequest.getter(ChatSyncRequest::authChallengeResponse)).setter(ChatSyncRequest.setter(Builder::authChallengeResponse)).constructor(AuthChallengeResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authChallengeResponse").build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ChatSyncRequest.getter(ChatSyncRequest::conversationId)).setter(ChatSyncRequest.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> PARENT_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentMessageId").getter(ChatSyncRequest.getter(ChatSyncRequest::parentMessageId)).setter(ChatSyncRequest.setter(Builder::parentMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentMessageId").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributeFilter").getter(ChatSyncRequest.getter(ChatSyncRequest::attributeFilter)).setter(ChatSyncRequest.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()}).build();
    private static final SdkField<String> CHAT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chatMode").getter(ChatSyncRequest.getter(ChatSyncRequest::chatModeAsString)).setter(ChatSyncRequest.setter(Builder::chatMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatMode").build()}).build();
    private static final SdkField<ChatModeConfiguration> CHAT_MODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatModeConfiguration").getter(ChatSyncRequest.getter(ChatSyncRequest::chatModeConfiguration)).setter(ChatSyncRequest.setter(Builder::chatModeConfiguration)).constructor(ChatModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatModeConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ChatSyncRequest.getter(ChatSyncRequest::clientToken)).setter(ChatSyncRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, USER_ID_FIELD, USER_GROUPS_FIELD, USER_MESSAGE_FIELD, ATTACHMENTS_FIELD, ACTION_EXECUTION_FIELD, AUTH_CHALLENGE_RESPONSE_FIELD, CONVERSATION_ID_FIELD, PARENT_MESSAGE_ID_FIELD, ATTRIBUTE_FILTER_FIELD, CHAT_MODE_FIELD, CHAT_MODE_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatSyncRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String userId;
    private final List<String> userGroups;
    private final String userMessage;
    private final List<AttachmentInput> attachments;
    private final ActionExecution actionExecution;
    private final AuthChallengeResponse authChallengeResponse;
    private final String conversationId;
    private final String parentMessageId;
    private final AttributeFilter attributeFilter;
    private final String chatMode;
    private final ChatModeConfiguration chatModeConfiguration;
    private final String clientToken;

    private ChatSyncRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.userGroups = builder.userGroups;
        this.userMessage = builder.userMessage;
        this.attachments = builder.attachments;
        this.actionExecution = builder.actionExecution;
        this.authChallengeResponse = builder.authChallengeResponse;
        this.conversationId = builder.conversationId;
        this.parentMessageId = builder.parentMessageId;
        this.attributeFilter = builder.attributeFilter;
        this.chatMode = builder.chatMode;
        this.chatModeConfiguration = builder.chatModeConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public final String userMessage() {
        return this.userMessage;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentInput> attachments() {
        return this.attachments;
    }

    public final ActionExecution actionExecution() {
        return this.actionExecution;
    }

    public final AuthChallengeResponse authChallengeResponse() {
        return this.authChallengeResponse;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String parentMessageId() {
        return this.parentMessageId;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public final ChatMode chatMode() {
        return ChatMode.fromValue(this.chatMode);
    }

    public final String chatModeAsString() {
        return this.chatMode;
    }

    public final ChatModeConfiguration chatModeConfiguration() {
        return this.chatModeConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.actionExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.authChallengeResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatModeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncRequest)) {
            return false;
        }
        ChatSyncRequest other = (ChatSyncRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.userId(), other.userId()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && Objects.equals(this.userMessage(), other.userMessage()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.actionExecution(), other.actionExecution()) && Objects.equals(this.authChallengeResponse(), other.authChallengeResponse()) && Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.parentMessageId(), other.parentMessageId()) && Objects.equals(this.attributeFilter(), other.attributeFilter()) && Objects.equals(this.chatModeAsString(), other.chatModeAsString()) && Objects.equals(this.chatModeConfiguration(), other.chatModeConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ChatSyncRequest").add("ApplicationId", (Object)this.applicationId()).add("UserId", (Object)this.userId()).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("UserMessage", (Object)this.userMessage()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("ActionExecution", (Object)this.actionExecution()).add("AuthChallengeResponse", (Object)this.authChallengeResponse()).add("ConversationId", (Object)this.conversationId()).add("ParentMessageId", (Object)this.parentMessageId()).add("AttributeFilter", (Object)this.attributeFilter()).add("ChatMode", (Object)this.chatModeAsString()).add("ChatModeConfiguration", (Object)this.chatModeConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "userMessage": {
                return Optional.ofNullable(clazz.cast(this.userMessage()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "actionExecution": {
                return Optional.ofNullable(clazz.cast(this.actionExecution()));
            }
            case "authChallengeResponse": {
                return Optional.ofNullable(clazz.cast(this.authChallengeResponse()));
            }
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "parentMessageId": {
                return Optional.ofNullable(clazz.cast(this.parentMessageId()));
            }
            case "attributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
            case "chatMode": {
                return Optional.ofNullable(clazz.cast(this.chatModeAsString()));
            }
            case "chatModeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chatModeConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("userGroups", USER_GROUPS_FIELD);
        map.put("userMessage", USER_MESSAGE_FIELD);
        map.put("attachments", ATTACHMENTS_FIELD);
        map.put("actionExecution", ACTION_EXECUTION_FIELD);
        map.put("authChallengeResponse", AUTH_CHALLENGE_RESPONSE_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("parentMessageId", PARENT_MESSAGE_ID_FIELD);
        map.put("attributeFilter", ATTRIBUTE_FILTER_FIELD);
        map.put("chatMode", CHAT_MODE_FIELD);
        map.put("chatModeConfiguration", CHAT_MODE_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatSyncRequest, T> g) {
        return obj -> g.apply((ChatSyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String userId;
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();
        private String userMessage;
        private List<AttachmentInput> attachments = DefaultSdkAutoConstructList.getInstance();
        private ActionExecution actionExecution;
        private AuthChallengeResponse authChallengeResponse;
        private String conversationId;
        private String parentMessageId;
        private AttributeFilter attributeFilter;
        private String chatMode;
        private ChatModeConfiguration chatModeConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatSyncRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.userId(model.userId);
            this.userGroups(model.userGroups);
            this.userMessage(model.userMessage);
            this.attachments(model.attachments);
            this.actionExecution(model.actionExecution);
            this.authChallengeResponse(model.authChallengeResponse);
            this.conversationId(model.conversationId);
            this.parentMessageId(model.parentMessageId);
            this.attributeFilter(model.attributeFilter);
            this.chatMode(model.chatMode);
            this.chatModeConfiguration(model.chatModeConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final String getUserMessage() {
            return this.userMessage;
        }

        public final void setUserMessage(String userMessage) {
            this.userMessage = userMessage;
        }

        @Override
        public final Builder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public final List<AttachmentInput.Builder> getAttachments() {
            List<AttachmentInput.Builder> result = AttachmentsInputCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentInput.BuilderImpl> attachments) {
            this.attachments = AttachmentsInputCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentInput> attachments) {
            this.attachments = AttachmentsInputCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentInput ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentInput.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AttachmentInput)((AttachmentInput.Builder)AttachmentInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ActionExecution.Builder getActionExecution() {
            return this.actionExecution != null ? this.actionExecution.toBuilder() : null;
        }

        public final void setActionExecution(ActionExecution.BuilderImpl actionExecution) {
            this.actionExecution = actionExecution != null ? actionExecution.build() : null;
        }

        @Override
        public final Builder actionExecution(ActionExecution actionExecution) {
            this.actionExecution = actionExecution;
            return this;
        }

        public final AuthChallengeResponse.Builder getAuthChallengeResponse() {
            return this.authChallengeResponse != null ? this.authChallengeResponse.toBuilder() : null;
        }

        public final void setAuthChallengeResponse(AuthChallengeResponse.BuilderImpl authChallengeResponse) {
            this.authChallengeResponse = authChallengeResponse != null ? authChallengeResponse.build() : null;
        }

        @Override
        public final Builder authChallengeResponse(AuthChallengeResponse authChallengeResponse) {
            this.authChallengeResponse = authChallengeResponse;
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getParentMessageId() {
            return this.parentMessageId;
        }

        public final void setParentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
        }

        @Override
        public final Builder parentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final String getChatMode() {
            return this.chatMode;
        }

        public final void setChatMode(String chatMode) {
            this.chatMode = chatMode;
        }

        @Override
        public final Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        @Override
        public final Builder chatMode(ChatMode chatMode) {
            this.chatMode(chatMode == null ? null : chatMode.toString());
            return this;
        }

        public final ChatModeConfiguration.Builder getChatModeConfiguration() {
            return this.chatModeConfiguration != null ? this.chatModeConfiguration.toBuilder() : null;
        }

        public final void setChatModeConfiguration(ChatModeConfiguration.BuilderImpl chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration != null ? chatModeConfiguration.build() : null;
        }

        @Override
        public final Builder chatModeConfiguration(ChatModeConfiguration chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChatSyncRequest build() {
            return new ChatSyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChatSyncRequest> {
        public Builder applicationId(String var1);

        public Builder userId(String var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder userMessage(String var1);

        public Builder attachments(Collection<AttachmentInput> var1);

        public Builder attachments(AttachmentInput ... var1);

        public Builder attachments(Consumer<AttachmentInput.Builder> ... var1);

        public Builder actionExecution(ActionExecution var1);

        default public Builder actionExecution(Consumer<ActionExecution.Builder> actionExecution) {
            return this.actionExecution((ActionExecution)((ActionExecution.Builder)ActionExecution.builder().applyMutation(actionExecution)).build());
        }

        public Builder authChallengeResponse(AuthChallengeResponse var1);

        default public Builder authChallengeResponse(Consumer<AuthChallengeResponse.Builder> authChallengeResponse) {
            return this.authChallengeResponse((AuthChallengeResponse)((AuthChallengeResponse.Builder)AuthChallengeResponse.builder().applyMutation(authChallengeResponse)).build());
        }

        public Builder conversationId(String var1);

        public Builder parentMessageId(String var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }

        public Builder chatMode(String var1);

        public Builder chatMode(ChatMode var1);

        public Builder chatModeConfiguration(ChatModeConfiguration var1);

        default public Builder chatModeConfiguration(Consumer<ChatModeConfiguration.Builder> chatModeConfiguration) {
            return this.chatModeConfiguration((ChatModeConfiguration)((ChatModeConfiguration.Builder)ChatModeConfiguration.builder().applyMutation(chatModeConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

