/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.UserGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, ChatRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ChatRequest.getter(ChatRequest::applicationId)).setter(ChatRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ChatRequest.getter(ChatRequest::userId)).setter(ChatRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userGroups").getter(ChatRequest.getter(ChatRequest::userGroups)).setter(ChatRequest.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ChatRequest.getter(ChatRequest::conversationId)).setter(ChatRequest.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("conversationId").build()}).build();
    private static final SdkField<String> PARENT_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentMessageId").getter(ChatRequest.getter(ChatRequest::parentMessageId)).setter(ChatRequest.setter(Builder::parentMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parentMessageId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ChatRequest.getter(ChatRequest::clientToken)).setter(ChatRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, USER_ID_FIELD, USER_GROUPS_FIELD, CONVERSATION_ID_FIELD, PARENT_MESSAGE_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String userId;
    private final List<String> userGroups;
    private final String conversationId;
    private final String parentMessageId;
    private final String clientToken;

    private ChatRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.userGroups = builder.userGroups;
        this.conversationId = builder.conversationId;
        this.parentMessageId = builder.parentMessageId;
        this.clientToken = builder.clientToken;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String parentMessageId() {
        return this.parentMessageId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.userId(), other.userId()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.parentMessageId(), other.parentMessageId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ChatRequest").add("ApplicationId", (Object)this.applicationId()).add("UserId", (Object)this.userId()).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("ConversationId", (Object)this.conversationId()).add("ParentMessageId", (Object)this.parentMessageId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "parentMessageId": {
                return Optional.ofNullable(clazz.cast(this.parentMessageId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("userGroups", USER_GROUPS_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("parentMessageId", PARENT_MESSAGE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatRequest, T> g) {
        return obj -> g.apply((ChatRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String userId;
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();
        private String conversationId;
        private String parentMessageId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.userId(model.userId);
            this.userGroups(model.userGroups);
            this.conversationId(model.conversationId);
            this.parentMessageId(model.parentMessageId);
            this.clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getParentMessageId() {
            return this.parentMessageId;
        }

        public final void setParentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
        }

        @Override
        public final Builder parentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChatRequest build() {
            return new ChatRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChatRequest> {
        public Builder applicationId(String var1);

        public Builder userId(String var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder conversationId(String var1);

        public Builder parentMessageId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

