/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.CustomPluginConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PluginAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PluginState;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePluginRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdatePluginRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdatePluginRequest.getter(UpdatePluginRequest::applicationId)).setter(UpdatePluginRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(UpdatePluginRequest.getter(UpdatePluginRequest::pluginId)).setter(UpdatePluginRequest.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("pluginId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdatePluginRequest.getter(UpdatePluginRequest::displayName)).setter(UpdatePluginRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(UpdatePluginRequest.getter(UpdatePluginRequest::stateAsString)).setter(UpdatePluginRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverUrl").getter(UpdatePluginRequest.getter(UpdatePluginRequest::serverUrl)).setter(UpdatePluginRequest.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()}).build();
    private static final SdkField<CustomPluginConfiguration> CUSTOM_PLUGIN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customPluginConfiguration").getter(UpdatePluginRequest.getter(UpdatePluginRequest::customPluginConfiguration)).setter(UpdatePluginRequest.setter(Builder::customPluginConfiguration)).constructor(CustomPluginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginConfiguration").build()}).build();
    private static final SdkField<PluginAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authConfiguration").getter(UpdatePluginRequest.getter(UpdatePluginRequest::authConfiguration)).setter(UpdatePluginRequest.setter(Builder::authConfiguration)).constructor(PluginAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, PLUGIN_ID_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, SERVER_URL_FIELD, CUSTOM_PLUGIN_CONFIGURATION_FIELD, AUTH_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePluginRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String pluginId;
    private final String displayName;
    private final String state;
    private final String serverUrl;
    private final CustomPluginConfiguration customPluginConfiguration;
    private final PluginAuthConfiguration authConfiguration;

    private UpdatePluginRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pluginId = builder.pluginId;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.serverUrl = builder.serverUrl;
        this.customPluginConfiguration = builder.customPluginConfiguration;
        this.authConfiguration = builder.authConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final PluginState state() {
        return PluginState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final CustomPluginConfiguration customPluginConfiguration() {
        return this.customPluginConfiguration;
    }

    public final PluginAuthConfiguration authConfiguration() {
        return this.authConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPluginConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePluginRequest)) {
            return false;
        }
        UpdatePluginRequest other = (UpdatePluginRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.customPluginConfiguration(), other.customPluginConfiguration()) && Objects.equals(this.authConfiguration(), other.authConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePluginRequest").add("ApplicationId", (Object)this.applicationId()).add("PluginId", (Object)this.pluginId()).add("DisplayName", (Object)this.displayName()).add("State", (Object)this.stateAsString()).add("ServerUrl", (Object)this.serverUrl()).add("CustomPluginConfiguration", (Object)this.customPluginConfiguration()).add("AuthConfiguration", (Object)this.authConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "serverUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "customPluginConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customPluginConfiguration()));
            }
            case "authConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        map.put("customPluginConfiguration", CUSTOM_PLUGIN_CONFIGURATION_FIELD);
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePluginRequest, T> g) {
        return obj -> g.apply((UpdatePluginRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String pluginId;
        private String displayName;
        private String state;
        private String serverUrl;
        private CustomPluginConfiguration customPluginConfiguration;
        private PluginAuthConfiguration authConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePluginRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.pluginId(model.pluginId);
            this.displayName(model.displayName);
            this.state(model.state);
            this.serverUrl(model.serverUrl);
            this.customPluginConfiguration(model.customPluginConfiguration);
            this.authConfiguration(model.authConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final CustomPluginConfiguration.Builder getCustomPluginConfiguration() {
            return this.customPluginConfiguration != null ? this.customPluginConfiguration.toBuilder() : null;
        }

        public final void setCustomPluginConfiguration(CustomPluginConfiguration.BuilderImpl customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration != null ? customPluginConfiguration.build() : null;
        }

        @Override
        public final Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        public final PluginAuthConfiguration.Builder getAuthConfiguration() {
            return this.authConfiguration != null ? this.authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(PluginAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(PluginAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePluginRequest build() {
            return new UpdatePluginRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePluginRequest> {
        public Builder applicationId(String var1);

        public Builder pluginId(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(PluginState var1);

        public Builder serverUrl(String var1);

        public Builder customPluginConfiguration(CustomPluginConfiguration var1);

        default public Builder customPluginConfiguration(Consumer<CustomPluginConfiguration.Builder> customPluginConfiguration) {
            return this.customPluginConfiguration((CustomPluginConfiguration)((CustomPluginConfiguration.Builder)CustomPluginConfiguration.builder().applyMutation(customPluginConfiguration)).build());
        }

        public Builder authConfiguration(PluginAuthConfiguration var1);

        default public Builder authConfiguration(Consumer<PluginAuthConfiguration.Builder> authConfiguration) {
            return this.authConfiguration((PluginAuthConfiguration)((PluginAuthConfiguration.Builder)PluginAuthConfiguration.builder().applyMutation(authConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

