/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ActionSummary;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse;

public class ListPluginTypeActionsIterable
implements SdkIterable<ListPluginTypeActionsResponse> {
    private final QBusinessClient client;
    private final ListPluginTypeActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPluginTypeActionsIterable(QBusinessClient client, ListPluginTypeActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPluginTypeActionsResponseFetcher();
    }

    public Iterator<ListPluginTypeActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionSummary> items() {
        Function<ListPluginTypeActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPluginTypeActionsResponseFetcher
    implements SyncPageFetcher<ListPluginTypeActionsResponse> {
        private ListPluginTypeActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginTypeActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPluginTypeActionsResponse nextPage(ListPluginTypeActionsResponse previousPage) {
            if (previousPage == null) {
                return ListPluginTypeActionsIterable.this.client.listPluginTypeActions(ListPluginTypeActionsIterable.this.firstRequest);
            }
            return ListPluginTypeActionsIterable.this.client.listPluginTypeActions((ListPluginTypeActionsRequest)((Object)ListPluginTypeActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

