/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.AccessControl;
import software.amazon.awssdk.services.qbusiness.model.AccessControlsCopier;
import software.amazon.awssdk.services.qbusiness.model.MemberRelation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessConfiguration> {
    private static final SdkField<List<AccessControl>> ACCESS_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessControls").getter(AccessConfiguration.getter(AccessConfiguration::accessControls)).setter(AccessConfiguration.setter(Builder::accessControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberRelation").getter(AccessConfiguration.getter(AccessConfiguration::memberRelationAsString)).setter(AccessConfiguration.setter(Builder::memberRelation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROLS_FIELD, MEMBER_RELATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AccessControl> accessControls;
    private final String memberRelation;

    private AccessConfiguration(BuilderImpl builder) {
        this.accessControls = builder.accessControls;
        this.memberRelation = builder.memberRelation;
    }

    public final boolean hasAccessControls() {
        return this.accessControls != null && !(this.accessControls instanceof SdkAutoConstructList);
    }

    public final List<AccessControl> accessControls() {
        return this.accessControls;
    }

    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(this.memberRelation);
    }

    public final String memberRelationAsString() {
        return this.memberRelation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControls() ? this.accessControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRelationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessConfiguration)) {
            return false;
        }
        AccessConfiguration other = (AccessConfiguration)obj;
        return this.hasAccessControls() == other.hasAccessControls() && Objects.equals(this.accessControls(), other.accessControls()) && Objects.equals(this.memberRelationAsString(), other.memberRelationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessConfiguration").add("AccessControls", this.hasAccessControls() ? this.accessControls() : null).add("MemberRelation", (Object)this.memberRelationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessControls": {
                return Optional.ofNullable(clazz.cast(this.accessControls()));
            }
            case "memberRelation": {
                return Optional.ofNullable(clazz.cast(this.memberRelationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessControls", ACCESS_CONTROLS_FIELD);
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessConfiguration, T> g) {
        return obj -> g.apply((AccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AccessControl> accessControls = DefaultSdkAutoConstructList.getInstance();
        private String memberRelation;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessConfiguration model) {
            this.accessControls(model.accessControls);
            this.memberRelation(model.memberRelation);
        }

        public final List<AccessControl.Builder> getAccessControls() {
            List<AccessControl.Builder> result = AccessControlsCopier.copyToBuilder(this.accessControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControls(Collection<AccessControl.BuilderImpl> accessControls) {
            this.accessControls = AccessControlsCopier.copyFromBuilder(accessControls);
        }

        @Override
        public final Builder accessControls(Collection<AccessControl> accessControls) {
            this.accessControls = AccessControlsCopier.copy(accessControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControls(AccessControl ... accessControls) {
            this.accessControls(Arrays.asList(accessControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControls(Consumer<AccessControl.Builder> ... accessControls) {
            this.accessControls(Stream.of(accessControls).map(c -> (AccessControl)((AccessControl.Builder)AccessControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMemberRelation() {
            return this.memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public AccessConfiguration build() {
            return new AccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessConfiguration> {
        public Builder accessControls(Collection<AccessControl> var1);

        public Builder accessControls(AccessControl ... var1);

        public Builder accessControls(Consumer<AccessControl.Builder> ... var1);

        public Builder memberRelation(String var1);

        public Builder memberRelation(MemberRelation var1);
    }
}

