/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionReview;
import software.amazon.awssdk.services.qbusiness.model.AttachmentOutput;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsOutputCopier;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequest;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.SourceAttribution;
import software.amazon.awssdk.services.qbusiness.model.SourceAttributionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatSyncResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ChatSyncResponse> {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ChatSyncResponse.getter(ChatSyncResponse::conversationId)).setter(ChatSyncResponse.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessage").getter(ChatSyncResponse.getter(ChatSyncResponse::systemMessage)).setter(ChatSyncResponse.setter(Builder::systemMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageId").getter(ChatSyncResponse.getter(ChatSyncResponse::systemMessageId)).setter(ChatSyncResponse.setter(Builder::systemMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()}).build();
    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessageId").getter(ChatSyncResponse.getter(ChatSyncResponse::userMessageId)).setter(ChatSyncResponse.setter(Builder::userMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()}).build();
    private static final SdkField<ActionReview> ACTION_REVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionReview").getter(ChatSyncResponse.getter(ChatSyncResponse::actionReview)).setter(ChatSyncResponse.setter(Builder::actionReview)).constructor(ActionReview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReview").build()}).build();
    private static final SdkField<AuthChallengeRequest> AUTH_CHALLENGE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authChallengeRequest").getter(ChatSyncResponse.getter(ChatSyncResponse::authChallengeRequest)).setter(ChatSyncResponse.setter(Builder::authChallengeRequest)).constructor(AuthChallengeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authChallengeRequest").build()}).build();
    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceAttributions").getter(ChatSyncResponse.getter(ChatSyncResponse::sourceAttributions)).setter(ChatSyncResponse.setter(Builder::sourceAttributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAttribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentOutput>> FAILED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAttachments").getter(ChatSyncResponse.getter(ChatSyncResponse::failedAttachments)).setter(ChatSyncResponse.setter(Builder::failedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, SYSTEM_MESSAGE_FIELD, SYSTEM_MESSAGE_ID_FIELD, USER_MESSAGE_ID_FIELD, ACTION_REVIEW_FIELD, AUTH_CHALLENGE_REQUEST_FIELD, SOURCE_ATTRIBUTIONS_FIELD, FAILED_ATTACHMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatSyncResponse.memberNameToFieldInitializer();
    private final String conversationId;
    private final String systemMessage;
    private final String systemMessageId;
    private final String userMessageId;
    private final ActionReview actionReview;
    private final AuthChallengeRequest authChallengeRequest;
    private final List<SourceAttribution> sourceAttributions;
    private final List<AttachmentOutput> failedAttachments;

    private ChatSyncResponse(BuilderImpl builder) {
        super(builder);
        this.conversationId = builder.conversationId;
        this.systemMessage = builder.systemMessage;
        this.systemMessageId = builder.systemMessageId;
        this.userMessageId = builder.userMessageId;
        this.actionReview = builder.actionReview;
        this.authChallengeRequest = builder.authChallengeRequest;
        this.sourceAttributions = builder.sourceAttributions;
        this.failedAttachments = builder.failedAttachments;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String systemMessage() {
        return this.systemMessage;
    }

    public final String systemMessageId() {
        return this.systemMessageId;
    }

    public final String userMessageId() {
        return this.userMessageId;
    }

    public final ActionReview actionReview() {
        return this.actionReview;
    }

    public final AuthChallengeRequest authChallengeRequest() {
        return this.authChallengeRequest;
    }

    public final boolean hasSourceAttributions() {
        return this.sourceAttributions != null && !(this.sourceAttributions instanceof SdkAutoConstructList);
    }

    public final List<SourceAttribution> sourceAttributions() {
        return this.sourceAttributions;
    }

    public final boolean hasFailedAttachments() {
        return this.failedAttachments != null && !(this.failedAttachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentOutput> failedAttachments() {
        return this.failedAttachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionReview());
        hashCode = 31 * hashCode + Objects.hashCode(this.authChallengeRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAttributions() ? this.sourceAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAttachments() ? this.failedAttachments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncResponse)) {
            return false;
        }
        ChatSyncResponse other = (ChatSyncResponse)((Object)obj);
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.systemMessage(), other.systemMessage()) && Objects.equals(this.systemMessageId(), other.systemMessageId()) && Objects.equals(this.userMessageId(), other.userMessageId()) && Objects.equals(this.actionReview(), other.actionReview()) && Objects.equals(this.authChallengeRequest(), other.authChallengeRequest()) && this.hasSourceAttributions() == other.hasSourceAttributions() && Objects.equals(this.sourceAttributions(), other.sourceAttributions()) && this.hasFailedAttachments() == other.hasFailedAttachments() && Objects.equals(this.failedAttachments(), other.failedAttachments());
    }

    public final String toString() {
        return ToString.builder((String)"ChatSyncResponse").add("ConversationId", (Object)this.conversationId()).add("SystemMessage", (Object)this.systemMessage()).add("SystemMessageId", (Object)this.systemMessageId()).add("UserMessageId", (Object)this.userMessageId()).add("ActionReview", (Object)this.actionReview()).add("AuthChallengeRequest", (Object)this.authChallengeRequest()).add("SourceAttributions", this.hasSourceAttributions() ? this.sourceAttributions() : null).add("FailedAttachments", this.hasFailedAttachments() ? this.failedAttachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "systemMessage": {
                return Optional.ofNullable(clazz.cast(this.systemMessage()));
            }
            case "systemMessageId": {
                return Optional.ofNullable(clazz.cast(this.systemMessageId()));
            }
            case "userMessageId": {
                return Optional.ofNullable(clazz.cast(this.userMessageId()));
            }
            case "actionReview": {
                return Optional.ofNullable(clazz.cast(this.actionReview()));
            }
            case "authChallengeRequest": {
                return Optional.ofNullable(clazz.cast(this.authChallengeRequest()));
            }
            case "sourceAttributions": {
                return Optional.ofNullable(clazz.cast(this.sourceAttributions()));
            }
            case "failedAttachments": {
                return Optional.ofNullable(clazz.cast(this.failedAttachments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("systemMessage", SYSTEM_MESSAGE_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("actionReview", ACTION_REVIEW_FIELD);
        map.put("authChallengeRequest", AUTH_CHALLENGE_REQUEST_FIELD);
        map.put("sourceAttributions", SOURCE_ATTRIBUTIONS_FIELD);
        map.put("failedAttachments", FAILED_ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatSyncResponse, T> g) {
        return obj -> g.apply((ChatSyncResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String conversationId;
        private String systemMessage;
        private String systemMessageId;
        private String userMessageId;
        private ActionReview actionReview;
        private AuthChallengeRequest authChallengeRequest;
        private List<SourceAttribution> sourceAttributions = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentOutput> failedAttachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChatSyncResponse model) {
            super(model);
            this.conversationId(model.conversationId);
            this.systemMessage(model.systemMessage);
            this.systemMessageId(model.systemMessageId);
            this.userMessageId(model.userMessageId);
            this.actionReview(model.actionReview);
            this.authChallengeRequest(model.authChallengeRequest);
            this.sourceAttributions(model.sourceAttributions);
            this.failedAttachments(model.failedAttachments);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getSystemMessage() {
            return this.systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public final String getSystemMessageId() {
            return this.systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getUserMessageId() {
            return this.userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final ActionReview.Builder getActionReview() {
            return this.actionReview != null ? this.actionReview.toBuilder() : null;
        }

        public final void setActionReview(ActionReview.BuilderImpl actionReview) {
            this.actionReview = actionReview != null ? actionReview.build() : null;
        }

        @Override
        public final Builder actionReview(ActionReview actionReview) {
            this.actionReview = actionReview;
            return this;
        }

        public final AuthChallengeRequest.Builder getAuthChallengeRequest() {
            return this.authChallengeRequest != null ? this.authChallengeRequest.toBuilder() : null;
        }

        public final void setAuthChallengeRequest(AuthChallengeRequest.BuilderImpl authChallengeRequest) {
            this.authChallengeRequest = authChallengeRequest != null ? authChallengeRequest.build() : null;
        }

        @Override
        public final Builder authChallengeRequest(AuthChallengeRequest authChallengeRequest) {
            this.authChallengeRequest = authChallengeRequest;
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttributions() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttributions(Collection<SourceAttribution.BuilderImpl> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copyFromBuilder(sourceAttributions);
        }

        @Override
        public final Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copy(sourceAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(SourceAttribution ... sourceAttributions) {
            this.sourceAttributions(Arrays.asList(sourceAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... sourceAttributions) {
            this.sourceAttributions(Stream.of(sourceAttributions).map(c -> (SourceAttribution)((SourceAttribution.Builder)SourceAttribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttachmentOutput.Builder> getFailedAttachments() {
            List<AttachmentOutput.Builder> result = AttachmentsOutputCopier.copyToBuilder(this.failedAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAttachments(Collection<AttachmentOutput.BuilderImpl> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copyFromBuilder(failedAttachments);
        }

        @Override
        public final Builder failedAttachments(Collection<AttachmentOutput> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copy(failedAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(AttachmentOutput ... failedAttachments) {
            this.failedAttachments(Arrays.asList(failedAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(Consumer<AttachmentOutput.Builder> ... failedAttachments) {
            this.failedAttachments(Stream.of(failedAttachments).map(c -> (AttachmentOutput)((AttachmentOutput.Builder)AttachmentOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChatSyncResponse build() {
            return new ChatSyncResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChatSyncResponse> {
        public Builder conversationId(String var1);

        public Builder systemMessage(String var1);

        public Builder systemMessageId(String var1);

        public Builder userMessageId(String var1);

        public Builder actionReview(ActionReview var1);

        default public Builder actionReview(Consumer<ActionReview.Builder> actionReview) {
            return this.actionReview((ActionReview)((ActionReview.Builder)ActionReview.builder().applyMutation(actionReview)).build());
        }

        public Builder authChallengeRequest(AuthChallengeRequest var1);

        default public Builder authChallengeRequest(Consumer<AuthChallengeRequest.Builder> authChallengeRequest) {
            return this.authChallengeRequest((AuthChallengeRequest)((AuthChallengeRequest.Builder)AuthChallengeRequest.builder().applyMutation(authChallengeRequest)).build());
        }

        public Builder sourceAttributions(Collection<SourceAttribution> var1);

        public Builder sourceAttributions(SourceAttribution ... var1);

        public Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... var1);

        public Builder failedAttachments(Collection<AttachmentOutput> var1);

        public Builder failedAttachments(AttachmentOutput ... var1);

        public Builder failedAttachments(Consumer<AttachmentOutput.Builder> ... var1);
    }
}

