/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SystemMessageType {
    RESPONSE("RESPONSE"),
    GROUNDED_RESPONSE("GROUNDED_RESPONSE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SystemMessageType> VALUE_MAP;
    private final String value;

    private SystemMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SystemMessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SystemMessageType> knownValues() {
        EnumSet<SystemMessageType> knownValues = EnumSet.allOf(SystemMessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SystemMessageType.class, SystemMessageType::toString);
    }
}

