/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJobStatus;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourceSyncJobsRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::dataSourceId)).setter(ListDataSourceSyncJobsRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::applicationId)).setter(ListDataSourceSyncJobsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::indexId)).setter(ListDataSourceSyncJobsRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::nextToken)).setter(ListDataSourceSyncJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::maxResults)).setter(ListDataSourceSyncJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::startTime)).setter(ListDataSourceSyncJobsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::endTime)).setter(ListDataSourceSyncJobsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusFilter").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::statusFilterAsString)).setter(ListDataSourceSyncJobsRequest.setter(Builder::statusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("syncStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, APPLICATION_ID_FIELD, INDEX_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataSourceSyncJobsRequest.memberNameToFieldInitializer();
    private final String dataSourceId;
    private final String applicationId;
    private final String indexId;
    private final String nextToken;
    private final Integer maxResults;
    private final Instant startTime;
    private final Instant endTime;
    private final String statusFilter;

    private ListDataSourceSyncJobsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusFilter = builder.statusFilter;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final DataSourceSyncJobStatus statusFilter() {
        return DataSourceSyncJobStatus.fromValue(this.statusFilter);
    }

    public final String statusFilterAsString() {
        return this.statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsRequest)) {
            return false;
        }
        ListDataSourceSyncJobsRequest other = (ListDataSourceSyncJobsRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusFilterAsString(), other.statusFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSourceSyncJobsRequest").add("DataSourceId", (Object)this.dataSourceId()).add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StatusFilter", (Object)this.statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "statusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("syncStatus", STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsRequest, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String applicationId;
        private String indexId;
        private String nextToken;
        private Integer maxResults;
        private Instant startTime;
        private Instant endTime;
        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.statusFilter(model.statusFilter);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DataSourceSyncJobStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourceSyncJobsRequest build() {
            return new ListDataSourceSyncJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
        public Builder dataSourceId(String var1);

        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusFilter(String var1);

        public Builder statusFilter(DataSourceSyncJobStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

