/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.qbusiness.model.Subscription;

public class ListSubscriptionsIterable
implements SdkIterable<ListSubscriptionsResponse> {
    private final QBusinessClient client;
    private final ListSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionsIterable(QBusinessClient client, ListSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubscriptionsResponseFetcher();
    }

    public Iterator<ListSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionsResponse> {
        private ListSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscriptionsResponse nextPage(ListSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsIterable.this.client.listSubscriptions(ListSubscriptionsIterable.this.firstRequest);
            }
            return ListSubscriptionsIterable.this.client.listSubscriptions((ListSubscriptionsRequest)((Object)ListSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

