/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AutoSubscriptionStatus;
import software.amazon.awssdk.services.qbusiness.model.SubscriptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoSubscriptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoSubscriptionConfiguration> {
    private static final SdkField<String> AUTO_SUBSCRIBE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoSubscribe").getter(AutoSubscriptionConfiguration.getter(AutoSubscriptionConfiguration::autoSubscribeAsString)).setter(AutoSubscriptionConfiguration.setter(Builder::autoSubscribe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubscribe").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultSubscriptionType").getter(AutoSubscriptionConfiguration.getter(AutoSubscriptionConfiguration::defaultSubscriptionTypeAsString)).setter(AutoSubscriptionConfiguration.setter(Builder::defaultSubscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSubscriptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SUBSCRIBE_FIELD, DEFAULT_SUBSCRIPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoSubscriptionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String autoSubscribe;
    private final String defaultSubscriptionType;

    private AutoSubscriptionConfiguration(BuilderImpl builder) {
        this.autoSubscribe = builder.autoSubscribe;
        this.defaultSubscriptionType = builder.defaultSubscriptionType;
    }

    public final AutoSubscriptionStatus autoSubscribe() {
        return AutoSubscriptionStatus.fromValue(this.autoSubscribe);
    }

    public final String autoSubscribeAsString() {
        return this.autoSubscribe;
    }

    public final SubscriptionType defaultSubscriptionType() {
        return SubscriptionType.fromValue(this.defaultSubscriptionType);
    }

    public final String defaultSubscriptionTypeAsString() {
        return this.defaultSubscriptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSubscribeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubscriptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoSubscriptionConfiguration)) {
            return false;
        }
        AutoSubscriptionConfiguration other = (AutoSubscriptionConfiguration)obj;
        return Objects.equals(this.autoSubscribeAsString(), other.autoSubscribeAsString()) && Objects.equals(this.defaultSubscriptionTypeAsString(), other.defaultSubscriptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoSubscriptionConfiguration").add("AutoSubscribe", (Object)this.autoSubscribeAsString()).add("DefaultSubscriptionType", (Object)this.defaultSubscriptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoSubscribe": {
                return Optional.ofNullable(clazz.cast(this.autoSubscribeAsString()));
            }
            case "defaultSubscriptionType": {
                return Optional.ofNullable(clazz.cast(this.defaultSubscriptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("autoSubscribe", AUTO_SUBSCRIBE_FIELD);
        map.put("defaultSubscriptionType", DEFAULT_SUBSCRIPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoSubscriptionConfiguration, T> g) {
        return obj -> g.apply((AutoSubscriptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoSubscribe;
        private String defaultSubscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoSubscriptionConfiguration model) {
            this.autoSubscribe(model.autoSubscribe);
            this.defaultSubscriptionType(model.defaultSubscriptionType);
        }

        public final String getAutoSubscribe() {
            return this.autoSubscribe;
        }

        public final void setAutoSubscribe(String autoSubscribe) {
            this.autoSubscribe = autoSubscribe;
        }

        @Override
        public final Builder autoSubscribe(String autoSubscribe) {
            this.autoSubscribe = autoSubscribe;
            return this;
        }

        @Override
        public final Builder autoSubscribe(AutoSubscriptionStatus autoSubscribe) {
            this.autoSubscribe(autoSubscribe == null ? null : autoSubscribe.toString());
            return this;
        }

        public final String getDefaultSubscriptionType() {
            return this.defaultSubscriptionType;
        }

        public final void setDefaultSubscriptionType(String defaultSubscriptionType) {
            this.defaultSubscriptionType = defaultSubscriptionType;
        }

        @Override
        public final Builder defaultSubscriptionType(String defaultSubscriptionType) {
            this.defaultSubscriptionType = defaultSubscriptionType;
            return this;
        }

        @Override
        public final Builder defaultSubscriptionType(SubscriptionType defaultSubscriptionType) {
            this.defaultSubscriptionType(defaultSubscriptionType == null ? null : defaultSubscriptionType.toString());
            return this;
        }

        public AutoSubscriptionConfiguration build() {
            return new AutoSubscriptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoSubscriptionConfiguration> {
        public Builder autoSubscribe(String var1);

        public Builder autoSubscribe(AutoSubscriptionStatus var1);

        public Builder defaultSubscriptionType(String var1);

        public Builder defaultSubscriptionType(SubscriptionType var1);
    }
}

