/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse;

public class ListSubscriptionsPublisher
implements SdkPublisher<ListSubscriptionsResponse> {
    private final QBusinessAsyncClient client;
    private final ListSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionsPublisher(QBusinessAsyncClient client, ListSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionsPublisher(QBusinessAsyncClient client, ListSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<software.amazon.awssdk.services.qbusiness.model.Subscription> subscriptions() {
        Function<ListSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionsResponse> {
        private ListSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscriptionsResponse> nextPage(ListSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsPublisher.this.client.listSubscriptions(ListSubscriptionsPublisher.this.firstRequest);
            }
            return ListSubscriptionsPublisher.this.client.listSubscriptions((ListSubscriptionsRequest)((Object)ListSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

